// ==UserScript==
// @name         보이스복스 딸깍툴
// @namespace    npm/vite-plugin-monkey
// @version      0.0.0
// @description  보이스복스 딸깍
// @icon         https://vitejs.dev/logo.svg
// @match        *://*/*
// @require      https://cdn.jsdelivr.net/npm/vue@3.5.22/dist/vue.global.prod.js
// @connect      localhost
// @connect      127.0.0.1
// @connect      generativelanguage.googleapis.com
// @connect      api.anthropic.com
// @connect      *
// @grant        GM_addStyle
// @grant        GM_getValue
// @grant        GM_registerMenuCommand
// @grant        GM_setValue
// @grant        GM_xmlhttpRequest
// @run-at       document-end
// ==/UserScript==

(function (vue) {
  'use strict';

  const d=new Set;const a = async e=>{d.has(e)||(d.add(e),(t=>{typeof GM_addStyle=="function"?GM_addStyle(t):document.head.appendChild(document.createElement("style")).append(t);})(e));};

  a(" .router-link-active[data-v-c31ba9e1]{background-color:#1f2937;color:#60a5fa}.router-link-active div[data-v-c31ba9e1]{display:block} ");

  /*!
   * pinia v3.0.3
   * (c) 2025 Eduardo San Martin Morote
   * @license MIT
   */
  let activePinia;
  const setActivePinia = (pinia) => activePinia = pinia;
  const piniaSymbol = (
Symbol()
  );
  function isPlainObject(o) {
    return o && typeof o === "object" && Object.prototype.toString.call(o) === "[object Object]" && typeof o.toJSON !== "function";
  }
  var MutationType;
  (function(MutationType2) {
    MutationType2["direct"] = "direct";
    MutationType2["patchObject"] = "patch object";
    MutationType2["patchFunction"] = "patch function";
  })(MutationType || (MutationType = {}));
  function createPinia() {
    const scope = vue.effectScope(true);
    const state = scope.run(() => vue.ref({}));
    let _p = [];
    let toBeInstalled = [];
    const pinia = vue.markRaw({
      install(app) {
        setActivePinia(pinia);
        pinia._a = app;
        app.provide(piniaSymbol, pinia);
        app.config.globalProperties.$pinia = pinia;
        toBeInstalled.forEach((plugin) => _p.push(plugin));
        toBeInstalled = [];
      },
      use(plugin) {
        if (!this._a) {
          toBeInstalled.push(plugin);
        } else {
          _p.push(plugin);
        }
        return this;
      },
      _p,

_a: null,
      _e: scope,
      _s: new Map(),
      state
    });
    return pinia;
  }
  const noop$1 = () => {
  };
  function addSubscription(subscriptions, callback, detached, onCleanup = noop$1) {
    subscriptions.push(callback);
    const removeSubscription = () => {
      const idx = subscriptions.indexOf(callback);
      if (idx > -1) {
        subscriptions.splice(idx, 1);
        onCleanup();
      }
    };
    if (!detached && vue.getCurrentScope()) {
      vue.onScopeDispose(removeSubscription);
    }
    return removeSubscription;
  }
  function triggerSubscriptions(subscriptions, ...args) {
    subscriptions.slice().forEach((callback) => {
      callback(...args);
    });
  }
  const fallbackRunWithContext = (fn) => fn();
  const ACTION_MARKER = Symbol();
  const ACTION_NAME = Symbol();
  function mergeReactiveObjects(target, patchToApply) {
    if (target instanceof Map && patchToApply instanceof Map) {
      patchToApply.forEach((value, key) => target.set(key, value));
    } else if (target instanceof Set && patchToApply instanceof Set) {
      patchToApply.forEach(target.add, target);
    }
    for (const key in patchToApply) {
      if (!patchToApply.hasOwnProperty(key))
        continue;
      const subPatch = patchToApply[key];
      const targetValue = target[key];
      if (isPlainObject(targetValue) && isPlainObject(subPatch) && target.hasOwnProperty(key) && !vue.isRef(subPatch) && !vue.isReactive(subPatch)) {
        target[key] = mergeReactiveObjects(targetValue, subPatch);
      } else {
        target[key] = subPatch;
      }
    }
    return target;
  }
  const skipHydrateSymbol = (
Symbol()
  );
  function shouldHydrate(obj) {
    return !isPlainObject(obj) || !Object.prototype.hasOwnProperty.call(obj, skipHydrateSymbol);
  }
  const { assign: assign$1 } = Object;
  function isComputed(o) {
    return !!(vue.isRef(o) && o.effect);
  }
  function createOptionsStore(id, options, pinia, hot) {
    const { state, actions, getters } = options;
    const initialState = pinia.state.value[id];
    let store;
    function setup() {
      if (!initialState && true) {
        pinia.state.value[id] = state ? state() : {};
      }
      const localState = vue.toRefs(pinia.state.value[id]);
      return assign$1(localState, actions, Object.keys(getters || {}).reduce((computedGetters, name) => {
        computedGetters[name] = vue.markRaw(vue.computed(() => {
          setActivePinia(pinia);
          const store2 = pinia._s.get(id);
          return getters[name].call(store2, store2);
        }));
        return computedGetters;
      }, {}));
    }
    store = createSetupStore(id, setup, options, pinia, hot, true);
    return store;
  }
  function createSetupStore($id, setup, options = {}, pinia, hot, isOptionsStore) {
    let scope;
    const optionsForPlugin = assign$1({ actions: {} }, options);
    const $subscribeOptions = { deep: true };
    let isListening;
    let isSyncListening;
    let subscriptions = [];
    let actionSubscriptions = [];
    let debuggerEvents;
    const initialState = pinia.state.value[$id];
    if (!isOptionsStore && !initialState && true) {
      pinia.state.value[$id] = {};
    }
    vue.ref({});
    let activeListener;
    function $patch(partialStateOrMutator) {
      let subscriptionMutation;
      isListening = isSyncListening = false;
      if (typeof partialStateOrMutator === "function") {
        partialStateOrMutator(pinia.state.value[$id]);
        subscriptionMutation = {
          type: MutationType.patchFunction,
          storeId: $id,
          events: debuggerEvents
        };
      } else {
        mergeReactiveObjects(pinia.state.value[$id], partialStateOrMutator);
        subscriptionMutation = {
          type: MutationType.patchObject,
          payload: partialStateOrMutator,
          storeId: $id,
          events: debuggerEvents
        };
      }
      const myListenerId = activeListener = Symbol();
      vue.nextTick().then(() => {
        if (activeListener === myListenerId) {
          isListening = true;
        }
      });
      isSyncListening = true;
      triggerSubscriptions(subscriptions, subscriptionMutation, pinia.state.value[$id]);
    }
    const $reset = isOptionsStore ? function $reset2() {
      const { state } = options;
      const newState = state ? state() : {};
      this.$patch(($state) => {
        assign$1($state, newState);
      });
    } : (
noop$1
    );
    function $dispose() {
      scope.stop();
      subscriptions = [];
      actionSubscriptions = [];
      pinia._s.delete($id);
    }
    const action = (fn, name = "") => {
      if (ACTION_MARKER in fn) {
        fn[ACTION_NAME] = name;
        return fn;
      }
      const wrappedAction = function() {
        setActivePinia(pinia);
        const args = Array.from(arguments);
        const afterCallbackList = [];
        const onErrorCallbackList = [];
        function after(callback) {
          afterCallbackList.push(callback);
        }
        function onError(callback) {
          onErrorCallbackList.push(callback);
        }
        triggerSubscriptions(actionSubscriptions, {
          args,
          name: wrappedAction[ACTION_NAME],
          store,
          after,
          onError
        });
        let ret;
        try {
          ret = fn.apply(this && this.$id === $id ? this : store, args);
        } catch (error) {
          triggerSubscriptions(onErrorCallbackList, error);
          throw error;
        }
        if (ret instanceof Promise) {
          return ret.then((value) => {
            triggerSubscriptions(afterCallbackList, value);
            return value;
          }).catch((error) => {
            triggerSubscriptions(onErrorCallbackList, error);
            return Promise.reject(error);
          });
        }
        triggerSubscriptions(afterCallbackList, ret);
        return ret;
      };
      wrappedAction[ACTION_MARKER] = true;
      wrappedAction[ACTION_NAME] = name;
      return wrappedAction;
    };
    const partialStore = {
      _p: pinia,
$id,
      $onAction: addSubscription.bind(null, actionSubscriptions),
      $patch,
      $reset,
      $subscribe(callback, options2 = {}) {
        const removeSubscription = addSubscription(subscriptions, callback, options2.detached, () => stopWatcher());
        const stopWatcher = scope.run(() => vue.watch(() => pinia.state.value[$id], (state) => {
          if (options2.flush === "sync" ? isSyncListening : isListening) {
            callback({
              storeId: $id,
              type: MutationType.direct,
              events: debuggerEvents
            }, state);
          }
        }, assign$1({}, $subscribeOptions, options2)));
        return removeSubscription;
      },
      $dispose
    };
    const store = vue.reactive(partialStore);
    pinia._s.set($id, store);
    const runWithContext = pinia._a && pinia._a.runWithContext || fallbackRunWithContext;
    const setupStore = runWithContext(() => pinia._e.run(() => (scope = vue.effectScope()).run(() => setup({ action }))));
    for (const key in setupStore) {
      const prop = setupStore[key];
      if (vue.isRef(prop) && !isComputed(prop) || vue.isReactive(prop)) {
        if (!isOptionsStore) {
          if (initialState && shouldHydrate(prop)) {
            if (vue.isRef(prop)) {
              prop.value = initialState[key];
            } else {
              mergeReactiveObjects(prop, initialState[key]);
            }
          }
          pinia.state.value[$id][key] = prop;
        }
      } else if (typeof prop === "function") {
        const actionValue = action(prop, key);
        setupStore[key] = actionValue;
        optionsForPlugin.actions[key] = prop;
      } else ;
    }
    assign$1(store, setupStore);
    assign$1(vue.toRaw(store), setupStore);
    Object.defineProperty(store, "$state", {
      get: () => pinia.state.value[$id],
      set: (state) => {
        $patch(($state) => {
          assign$1($state, state);
        });
      }
    });
    pinia._p.forEach((extender) => {
      {
        assign$1(store, scope.run(() => extender({
          store,
          app: pinia._a,
          pinia,
          options: optionsForPlugin
        })));
      }
    });
    if (initialState && isOptionsStore && options.hydrate) {
      options.hydrate(store.$state, initialState);
    }
    isListening = true;
    isSyncListening = true;
    return store;
  }

function defineStore(id, setup, setupOptions) {
    let options;
    const isSetupStore = typeof setup === "function";
    options = isSetupStore ? setupOptions : setup;
    function useStore(pinia, hot) {
      const hasContext = vue.hasInjectionContext();
      pinia =

pinia || (hasContext ? vue.inject(piniaSymbol, null) : null);
      if (pinia)
        setActivePinia(pinia);
      pinia = activePinia;
      if (!pinia._s.has(id)) {
        if (isSetupStore) {
          createSetupStore(id, setup, options, pinia);
        } else {
          createOptionsStore(id, options, pinia);
        }
      }
      const store = pinia._s.get(id);
      return store;
    }
    useStore.$id = id;
    return useStore;
  }
  function storeToRefs(store) {
    const rawStore = vue.toRaw(store);
    const refs = {};
    for (const key in rawStore) {
      const value = rawStore[key];
      if (value.effect) {
        refs[key] =
vue.computed({
          get: () => store[key],
          set(value2) {
            store[key] = value2;
          }
        });
      } else if (vue.isRef(value) || vue.isReactive(value)) {
        refs[key] =
vue.toRef(store, key);
      }
    }
    return refs;
  }
  var _GM_getValue = (() => typeof GM_getValue != "undefined" ? GM_getValue : void 0)();
  var _GM_registerMenuCommand = (() => typeof GM_registerMenuCommand != "undefined" ? GM_registerMenuCommand : void 0)();
  var _GM_setValue = (() => typeof GM_setValue != "undefined" ? GM_setValue : void 0)();
  var _GM_xmlhttpRequest = (() => typeof GM_xmlhttpRequest != "undefined" ? GM_xmlhttpRequest : void 0)();
  /*!
   * vue-router v4.6.3
   * (c) 2025 Eduardo San Martin Morote
   * @license MIT
   */
  const isBrowser = typeof document !== "undefined";
  function isRouteComponent(component) {
    return typeof component === "object" || "displayName" in component || "props" in component || "__vccOpts" in component;
  }
  function isESModule(obj) {
    return obj.__esModule || obj[Symbol.toStringTag] === "Module" || obj.default && isRouteComponent(obj.default);
  }
  const assign = Object.assign;
  function applyToParams(fn, params) {
    const newParams = {};
    for (const key in params) {
      const value = params[key];
      newParams[key] = isArray(value) ? value.map(fn) : fn(value);
    }
    return newParams;
  }
  const noop = () => {
  };
  const isArray = Array.isArray;
  function mergeOptions(defaults, partialOptions) {
    const options = {};
    for (const key in defaults) options[key] = key in partialOptions ? partialOptions[key] : defaults[key];
    return options;
  }
  const HASH_RE = /#/g;
  const AMPERSAND_RE = /&/g;
  const SLASH_RE = /\//g;
  const EQUAL_RE = /=/g;
  const IM_RE = /\?/g;
  const PLUS_RE = /\+/g;
  const ENC_BRACKET_OPEN_RE = /%5B/g;
  const ENC_BRACKET_CLOSE_RE = /%5D/g;
  const ENC_CARET_RE = /%5E/g;
  const ENC_BACKTICK_RE = /%60/g;
  const ENC_CURLY_OPEN_RE = /%7B/g;
  const ENC_PIPE_RE = /%7C/g;
  const ENC_CURLY_CLOSE_RE = /%7D/g;
  const ENC_SPACE_RE = /%20/g;
  function commonEncode(text) {
    return text == null ? "" : encodeURI("" + text).replace(ENC_PIPE_RE, "|").replace(ENC_BRACKET_OPEN_RE, "[").replace(ENC_BRACKET_CLOSE_RE, "]");
  }
  function encodeHash(text) {
    return commonEncode(text).replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
  }
  function encodeQueryValue(text) {
    return commonEncode(text).replace(PLUS_RE, "%2B").replace(ENC_SPACE_RE, "+").replace(HASH_RE, "%23").replace(AMPERSAND_RE, "%26").replace(ENC_BACKTICK_RE, "`").replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
  }
  function encodeQueryKey(text) {
    return encodeQueryValue(text).replace(EQUAL_RE, "%3D");
  }
  function encodePath(text) {
    return commonEncode(text).replace(HASH_RE, "%23").replace(IM_RE, "%3F");
  }
  function encodeParam(text) {
    return encodePath(text).replace(SLASH_RE, "%2F");
  }
  function decode(text) {
    if (text == null) return null;
    try {
      return decodeURIComponent("" + text);
    } catch (err) {
    }
    return "" + text;
  }
  const TRAILING_SLASH_RE = /\/$/;
  const removeTrailingSlash = (path) => path.replace(TRAILING_SLASH_RE, "");
  function parseURL(parseQuery$1, location2, currentLocation = "/") {
    let path, query = {}, searchString = "", hash = "";
    const hashPos = location2.indexOf("#");
    let searchPos = location2.indexOf("?");
    searchPos = hashPos >= 0 && searchPos > hashPos ? -1 : searchPos;
    if (searchPos >= 0) {
      path = location2.slice(0, searchPos);
      searchString = location2.slice(searchPos, hashPos > 0 ? hashPos : location2.length);
      query = parseQuery$1(searchString.slice(1));
    }
    if (hashPos >= 0) {
      path = path || location2.slice(0, hashPos);
      hash = location2.slice(hashPos, location2.length);
    }
    path = resolveRelativePath(path != null ? path : location2, currentLocation);
    return {
      fullPath: path + searchString + hash,
      path,
      query,
      hash: decode(hash)
    };
  }
  function stringifyURL(stringifyQuery$1, location2) {
    const query = location2.query ? stringifyQuery$1(location2.query) : "";
    return location2.path + (query && "?") + query + (location2.hash || "");
  }
  function stripBase(pathname, base) {
    if (!base || !pathname.toLowerCase().startsWith(base.toLowerCase())) return pathname;
    return pathname.slice(base.length) || "/";
  }
  function isSameRouteLocation(stringifyQuery$1, a, b) {
    const aLastIndex = a.matched.length - 1;
    const bLastIndex = b.matched.length - 1;
    return aLastIndex > -1 && aLastIndex === bLastIndex && isSameRouteRecord(a.matched[aLastIndex], b.matched[bLastIndex]) && isSameRouteLocationParams(a.params, b.params) && stringifyQuery$1(a.query) === stringifyQuery$1(b.query) && a.hash === b.hash;
  }
  function isSameRouteRecord(a, b) {
    return (a.aliasOf || a) === (b.aliasOf || b);
  }
  function isSameRouteLocationParams(a, b) {
    if (Object.keys(a).length !== Object.keys(b).length) return false;
    for (const key in a) if (!isSameRouteLocationParamsValue(a[key], b[key])) return false;
    return true;
  }
  function isSameRouteLocationParamsValue(a, b) {
    return isArray(a) ? isEquivalentArray(a, b) : isArray(b) ? isEquivalentArray(b, a) : a === b;
  }
  function isEquivalentArray(a, b) {
    return isArray(b) ? a.length === b.length && a.every((value, i) => value === b[i]) : a.length === 1 && a[0] === b;
  }
  function resolveRelativePath(to, from) {
    if (to.startsWith("/")) return to;
    if (!to) return from;
    const fromSegments = from.split("/");
    const toSegments = to.split("/");
    const lastToSegment = toSegments[toSegments.length - 1];
    if (lastToSegment === ".." || lastToSegment === ".") toSegments.push("");
    let position = fromSegments.length - 1;
    let toPosition;
    let segment;
    for (toPosition = 0; toPosition < toSegments.length; toPosition++) {
      segment = toSegments[toPosition];
      if (segment === ".") continue;
      if (segment === "..") {
        if (position > 1) position--;
      } else break;
    }
    return fromSegments.slice(0, position).join("/") + "/" + toSegments.slice(toPosition).join("/");
  }
  const START_LOCATION_NORMALIZED = {
    path: "/",
    name: void 0,
    params: {},
    query: {},
    hash: "",
    fullPath: "/",
    matched: [],
    meta: {},
    redirectedFrom: void 0
  };
  let NavigationType = (function(NavigationType$1) {
    NavigationType$1["pop"] = "pop";
    NavigationType$1["push"] = "push";
    return NavigationType$1;
  })({});
  let NavigationDirection = (function(NavigationDirection$1) {
    NavigationDirection$1["back"] = "back";
    NavigationDirection$1["forward"] = "forward";
    NavigationDirection$1["unknown"] = "";
    return NavigationDirection$1;
  })({});
  function normalizeBase(base) {
    if (!base) if (isBrowser) {
      const baseEl = document.querySelector("base");
      base = baseEl && baseEl.getAttribute("href") || "/";
      base = base.replace(/^\w+:\/\/[^\/]+/, "");
    } else base = "/";
    if (base[0] !== "/" && base[0] !== "#") base = "/" + base;
    return removeTrailingSlash(base);
  }
  const BEFORE_HASH_RE = /^[^#]+#/;
  function createHref(base, location2) {
    return base.replace(BEFORE_HASH_RE, "#") + location2;
  }
  function getElementPosition(el, offset) {
    const docRect = document.documentElement.getBoundingClientRect();
    const elRect = el.getBoundingClientRect();
    return {
      behavior: offset.behavior,
      left: elRect.left - docRect.left - (offset.left || 0),
      top: elRect.top - docRect.top - (offset.top || 0)
    };
  }
  const computeScrollPosition = () => ({
    left: window.scrollX,
    top: window.scrollY
  });
  function scrollToPosition(position) {
    let scrollToOptions;
    if ("el" in position) {
      const positionEl = position.el;
      const isIdSelector = typeof positionEl === "string" && positionEl.startsWith("#");
      const el = typeof positionEl === "string" ? isIdSelector ? document.getElementById(positionEl.slice(1)) : document.querySelector(positionEl) : positionEl;
      if (!el) {
        return;
      }
      scrollToOptions = getElementPosition(el, position);
    } else scrollToOptions = position;
    if ("scrollBehavior" in document.documentElement.style) window.scrollTo(scrollToOptions);
    else window.scrollTo(scrollToOptions.left != null ? scrollToOptions.left : window.scrollX, scrollToOptions.top != null ? scrollToOptions.top : window.scrollY);
  }
  function getScrollKey(path, delta) {
    return (history.state ? history.state.position - delta : -1) + path;
  }
  const scrollPositions = new Map();
  function saveScrollPosition(key, scrollPosition) {
    scrollPositions.set(key, scrollPosition);
  }
  function getSavedScrollPosition(key) {
    const scroll = scrollPositions.get(key);
    scrollPositions.delete(key);
    return scroll;
  }
  function isRouteLocation(route) {
    return typeof route === "string" || route && typeof route === "object";
  }
  function isRouteName(name) {
    return typeof name === "string" || typeof name === "symbol";
  }
  let ErrorTypes = (function(ErrorTypes$1) {
    ErrorTypes$1[ErrorTypes$1["MATCHER_NOT_FOUND"] = 1] = "MATCHER_NOT_FOUND";
    ErrorTypes$1[ErrorTypes$1["NAVIGATION_GUARD_REDIRECT"] = 2] = "NAVIGATION_GUARD_REDIRECT";
    ErrorTypes$1[ErrorTypes$1["NAVIGATION_ABORTED"] = 4] = "NAVIGATION_ABORTED";
    ErrorTypes$1[ErrorTypes$1["NAVIGATION_CANCELLED"] = 8] = "NAVIGATION_CANCELLED";
    ErrorTypes$1[ErrorTypes$1["NAVIGATION_DUPLICATED"] = 16] = "NAVIGATION_DUPLICATED";
    return ErrorTypes$1;
  })({});
  const NavigationFailureSymbol = Symbol("");
  ({
    [ErrorTypes.MATCHER_NOT_FOUND]({ location: location2, currentLocation }) {
      return `No match for
 ${JSON.stringify(location2)}${currentLocation ? "\nwhile being at\n" + JSON.stringify(currentLocation) : ""}`;
    },
    [ErrorTypes.NAVIGATION_GUARD_REDIRECT]({ from, to }) {
      return `Redirected from "${from.fullPath}" to "${stringifyRoute(to)}" via a navigation guard.`;
    },
    [ErrorTypes.NAVIGATION_ABORTED]({ from, to }) {
      return `Navigation aborted from "${from.fullPath}" to "${to.fullPath}" via a navigation guard.`;
    },
    [ErrorTypes.NAVIGATION_CANCELLED]({ from, to }) {
      return `Navigation cancelled from "${from.fullPath}" to "${to.fullPath}" with a new navigation.`;
    },
    [ErrorTypes.NAVIGATION_DUPLICATED]({ from, to }) {
      return `Avoided redundant navigation to current location: "${from.fullPath}".`;
    }
  });
  function createRouterError(type, params) {
    return assign( new Error(), {
      type,
      [NavigationFailureSymbol]: true
    }, params);
  }
  function isNavigationFailure(error, type) {
    return error instanceof Error && NavigationFailureSymbol in error && (type == null || !!(error.type & type));
  }
  const propertiesToLog = [
    "params",
    "query",
    "hash"
  ];
  function stringifyRoute(to) {
    if (typeof to === "string") return to;
    if (to.path != null) return to.path;
    const location2 = {};
    for (const key of propertiesToLog) if (key in to) location2[key] = to[key];
    return JSON.stringify(location2, null, 2);
  }
  function parseQuery(search) {
    const query = {};
    if (search === "" || search === "?") return query;
    const searchParams = (search[0] === "?" ? search.slice(1) : search).split("&");
    for (let i = 0; i < searchParams.length; ++i) {
      const searchParam = searchParams[i].replace(PLUS_RE, " ");
      const eqPos = searchParam.indexOf("=");
      const key = decode(eqPos < 0 ? searchParam : searchParam.slice(0, eqPos));
      const value = eqPos < 0 ? null : decode(searchParam.slice(eqPos + 1));
      if (key in query) {
        let currentValue = query[key];
        if (!isArray(currentValue)) currentValue = query[key] = [currentValue];
        currentValue.push(value);
      } else query[key] = value;
    }
    return query;
  }
  function stringifyQuery(query) {
    let search = "";
    for (let key in query) {
      const value = query[key];
      key = encodeQueryKey(key);
      if (value == null) {
        if (value !== void 0) search += (search.length ? "&" : "") + key;
        continue;
      }
      (isArray(value) ? value.map((v) => v && encodeQueryValue(v)) : [value && encodeQueryValue(value)]).forEach((value$1) => {
        if (value$1 !== void 0) {
          search += (search.length ? "&" : "") + key;
          if (value$1 != null) search += "=" + value$1;
        }
      });
    }
    return search;
  }
  function normalizeQuery(query) {
    const normalizedQuery = {};
    for (const key in query) {
      const value = query[key];
      if (value !== void 0) normalizedQuery[key] = isArray(value) ? value.map((v) => v == null ? null : "" + v) : value == null ? value : "" + value;
    }
    return normalizedQuery;
  }
  const matchedRouteKey = Symbol("");
  const viewDepthKey = Symbol("");
  const routerKey = Symbol("");
  const routeLocationKey = Symbol("");
  const routerViewLocationKey = Symbol("");
  function useCallbacks() {
    let handlers = [];
    function add(handler) {
      handlers.push(handler);
      return () => {
        const i = handlers.indexOf(handler);
        if (i > -1) handlers.splice(i, 1);
      };
    }
    function reset() {
      handlers = [];
    }
    return {
      add,
      list: () => handlers.slice(),
      reset
    };
  }
  function guardToPromiseFn(guard, to, from, record, name, runWithContext = (fn) => fn()) {
    const enterCallbackArray = record && (record.enterCallbacks[name] = record.enterCallbacks[name] || []);
    return () => new Promise((resolve, reject) => {
      const next = (valid) => {
        if (valid === false) reject(createRouterError(ErrorTypes.NAVIGATION_ABORTED, {
          from,
          to
        }));
        else if (valid instanceof Error) reject(valid);
        else if (isRouteLocation(valid)) reject(createRouterError(ErrorTypes.NAVIGATION_GUARD_REDIRECT, {
          from: to,
          to: valid
        }));
        else {
          if (enterCallbackArray && record.enterCallbacks[name] === enterCallbackArray && typeof valid === "function") enterCallbackArray.push(valid);
          resolve();
        }
      };
      const guardReturn = runWithContext(() => guard.call(record && record.instances[name], to, from, next));
      let guardCall = Promise.resolve(guardReturn);
      if (guard.length < 3) guardCall = guardCall.then(next);
      guardCall.catch((err) => reject(err));
    });
  }
  function extractComponentsGuards(matched, guardType, to, from, runWithContext = (fn) => fn()) {
    const guards = [];
    for (const record of matched) {
      for (const name in record.components) {
        let rawComponent = record.components[name];
        if (guardType !== "beforeRouteEnter" && !record.instances[name]) continue;
        if (isRouteComponent(rawComponent)) {
          const guard = (rawComponent.__vccOpts || rawComponent)[guardType];
          guard && guards.push(guardToPromiseFn(guard, to, from, record, name, runWithContext));
        } else {
          let componentPromise = rawComponent();
          guards.push(() => componentPromise.then((resolved) => {
            if (!resolved) throw new Error(`Couldn't resolve component "${name}" at "${record.path}"`);
            const resolvedComponent = isESModule(resolved) ? resolved.default : resolved;
            record.mods[name] = resolved;
            record.components[name] = resolvedComponent;
            const guard = (resolvedComponent.__vccOpts || resolvedComponent)[guardType];
            return guard && guardToPromiseFn(guard, to, from, record, name, runWithContext)();
          }));
        }
      }
    }
    return guards;
  }
  function extractChangingRecords(to, from) {
    const leavingRecords = [];
    const updatingRecords = [];
    const enteringRecords = [];
    const len = Math.max(from.matched.length, to.matched.length);
    for (let i = 0; i < len; i++) {
      const recordFrom = from.matched[i];
      if (recordFrom) if (to.matched.find((record) => isSameRouteRecord(record, recordFrom))) updatingRecords.push(recordFrom);
      else leavingRecords.push(recordFrom);
      const recordTo = to.matched[i];
      if (recordTo) {
        if (!from.matched.find((record) => isSameRouteRecord(record, recordTo))) enteringRecords.push(recordTo);
      }
    }
    return [
      leavingRecords,
      updatingRecords,
      enteringRecords
    ];
  }
  /*!
   * vue-router v4.6.3
   * (c) 2025 Eduardo San Martin Morote
   * @license MIT
   */
  let createBaseLocation = () => location.protocol + "//" + location.host;
  function createCurrentLocation(base, location$1) {
    const { pathname, search, hash } = location$1;
    const hashPos = base.indexOf("#");
    if (hashPos > -1) {
      let slicePos = hash.includes(base.slice(hashPos)) ? base.slice(hashPos).length : 1;
      let pathFromHash = hash.slice(slicePos);
      if (pathFromHash[0] !== "/") pathFromHash = "/" + pathFromHash;
      return stripBase(pathFromHash, "");
    }
    return stripBase(pathname, base) + search + hash;
  }
  function useHistoryListeners(base, historyState, currentLocation, replace) {
    let listeners = [];
    let teardowns = [];
    let pauseState = null;
    const popStateHandler = ({ state }) => {
      const to = createCurrentLocation(base, location);
      const from = currentLocation.value;
      const fromState = historyState.value;
      let delta = 0;
      if (state) {
        currentLocation.value = to;
        historyState.value = state;
        if (pauseState && pauseState === from) {
          pauseState = null;
          return;
        }
        delta = fromState ? state.position - fromState.position : 0;
      } else replace(to);
      listeners.forEach((listener) => {
        listener(currentLocation.value, from, {
          delta,
          type: NavigationType.pop,
          direction: delta ? delta > 0 ? NavigationDirection.forward : NavigationDirection.back : NavigationDirection.unknown
        });
      });
    };
    function pauseListeners() {
      pauseState = currentLocation.value;
    }
    function listen(callback) {
      listeners.push(callback);
      const teardown = () => {
        const index = listeners.indexOf(callback);
        if (index > -1) listeners.splice(index, 1);
      };
      teardowns.push(teardown);
      return teardown;
    }
    function beforeUnloadListener() {
      if (document.visibilityState === "hidden") {
        const { history: history$1 } = window;
        if (!history$1.state) return;
        history$1.replaceState(assign({}, history$1.state, { scroll: computeScrollPosition() }), "");
      }
    }
    function destroy() {
      for (const teardown of teardowns) teardown();
      teardowns = [];
      window.removeEventListener("popstate", popStateHandler);
      window.removeEventListener("pagehide", beforeUnloadListener);
      document.removeEventListener("visibilitychange", beforeUnloadListener);
    }
    window.addEventListener("popstate", popStateHandler);
    window.addEventListener("pagehide", beforeUnloadListener);
    document.addEventListener("visibilitychange", beforeUnloadListener);
    return {
      pauseListeners,
      listen,
      destroy
    };
  }
  function buildState(back, current, forward, replaced = false, computeScroll = false) {
    return {
      back,
      current,
      forward,
      replaced,
      position: window.history.length,
      scroll: computeScroll ? computeScrollPosition() : null
    };
  }
  function useHistoryStateNavigation(base) {
    const { history: history$1, location: location$1 } = window;
    const currentLocation = { value: createCurrentLocation(base, location$1) };
    const historyState = { value: history$1.state };
    if (!historyState.value) changeLocation(currentLocation.value, {
      back: null,
      current: currentLocation.value,
      forward: null,
      position: history$1.length - 1,
      replaced: true,
      scroll: null
    }, true);
    function changeLocation(to, state, replace$1) {
      const hashIndex = base.indexOf("#");
      const url = hashIndex > -1 ? (location$1.host && document.querySelector("base") ? base : base.slice(hashIndex)) + to : createBaseLocation() + base + to;
      try {
        history$1[replace$1 ? "replaceState" : "pushState"](state, "", url);
        historyState.value = state;
      } catch (err) {
        console.error(err);
        location$1[replace$1 ? "replace" : "assign"](url);
      }
    }
    function replace(to, data) {
      changeLocation(to, assign({}, history$1.state, buildState(historyState.value.back, to, historyState.value.forward, true), data, { position: historyState.value.position }), true);
      currentLocation.value = to;
    }
    function push(to, data) {
      const currentState = assign({}, historyState.value, history$1.state, {
        forward: to,
        scroll: computeScrollPosition()
      });
      changeLocation(currentState.current, currentState, true);
      changeLocation(to, assign({}, buildState(currentLocation.value, to, null), { position: currentState.position + 1 }, data), false);
      currentLocation.value = to;
    }
    return {
      location: currentLocation,
      state: historyState,
      push,
      replace
    };
  }
  function createWebHistory(base) {
    base = normalizeBase(base);
    const historyNavigation = useHistoryStateNavigation(base);
    const historyListeners = useHistoryListeners(base, historyNavigation.state, historyNavigation.location, historyNavigation.replace);
    function go(delta, triggerListeners = true) {
      if (!triggerListeners) historyListeners.pauseListeners();
      history.go(delta);
    }
    const routerHistory = assign({
      location: "",
      base,
      go,
      createHref: createHref.bind(null, base)
    }, historyNavigation, historyListeners);
    Object.defineProperty(routerHistory, "location", {
      enumerable: true,
      get: () => historyNavigation.location.value
    });
    Object.defineProperty(routerHistory, "state", {
      enumerable: true,
      get: () => historyNavigation.state.value
    });
    return routerHistory;
  }
  function createWebHashHistory(base) {
    base = location.host ? base || location.pathname + location.search : "";
    if (!base.includes("#")) base += "#";
    return createWebHistory(base);
  }
  let TokenType = (function(TokenType$1) {
    TokenType$1[TokenType$1["Static"] = 0] = "Static";
    TokenType$1[TokenType$1["Param"] = 1] = "Param";
    TokenType$1[TokenType$1["Group"] = 2] = "Group";
    return TokenType$1;
  })({});
  var TokenizerState = (function(TokenizerState$1) {
    TokenizerState$1[TokenizerState$1["Static"] = 0] = "Static";
    TokenizerState$1[TokenizerState$1["Param"] = 1] = "Param";
    TokenizerState$1[TokenizerState$1["ParamRegExp"] = 2] = "ParamRegExp";
    TokenizerState$1[TokenizerState$1["ParamRegExpEnd"] = 3] = "ParamRegExpEnd";
    TokenizerState$1[TokenizerState$1["EscapeNext"] = 4] = "EscapeNext";
    return TokenizerState$1;
  })(TokenizerState || {});
  const ROOT_TOKEN = {
    type: TokenType.Static,
    value: ""
  };
  const VALID_PARAM_RE = /[a-zA-Z0-9_]/;
  function tokenizePath(path) {
    if (!path) return [[]];
    if (path === "/") return [[ROOT_TOKEN]];
    if (!path.startsWith("/")) throw new Error(`Invalid path "${path}"`);
    function crash(message) {
      throw new Error(`ERR (${state})/"${buffer}": ${message}`);
    }
    let state = TokenizerState.Static;
    let previousState = state;
    const tokens = [];
    let segment;
    function finalizeSegment() {
      if (segment) tokens.push(segment);
      segment = [];
    }
    let i = 0;
    let char;
    let buffer = "";
    let customRe = "";
    function consumeBuffer() {
      if (!buffer) return;
      if (state === TokenizerState.Static) segment.push({
        type: TokenType.Static,
        value: buffer
      });
      else if (state === TokenizerState.Param || state === TokenizerState.ParamRegExp || state === TokenizerState.ParamRegExpEnd) {
        if (segment.length > 1 && (char === "*" || char === "+")) crash(`A repeatable param (${buffer}) must be alone in its segment. eg: '/:ids+.`);
        segment.push({
          type: TokenType.Param,
          value: buffer,
          regexp: customRe,
          repeatable: char === "*" || char === "+",
          optional: char === "*" || char === "?"
        });
      } else crash("Invalid state to consume buffer");
      buffer = "";
    }
    function addCharToBuffer() {
      buffer += char;
    }
    while (i < path.length) {
      char = path[i++];
      if (char === "\\" && state !== TokenizerState.ParamRegExp) {
        previousState = state;
        state = TokenizerState.EscapeNext;
        continue;
      }
      switch (state) {
        case TokenizerState.Static:
          if (char === "/") {
            if (buffer) consumeBuffer();
            finalizeSegment();
          } else if (char === ":") {
            consumeBuffer();
            state = TokenizerState.Param;
          } else addCharToBuffer();
          break;
        case TokenizerState.EscapeNext:
          addCharToBuffer();
          state = previousState;
          break;
        case TokenizerState.Param:
          if (char === "(") state = TokenizerState.ParamRegExp;
          else if (VALID_PARAM_RE.test(char)) addCharToBuffer();
          else {
            consumeBuffer();
            state = TokenizerState.Static;
            if (char !== "*" && char !== "?" && char !== "+") i--;
          }
          break;
        case TokenizerState.ParamRegExp:
          if (char === ")") if (customRe[customRe.length - 1] == "\\") customRe = customRe.slice(0, -1) + char;
          else state = TokenizerState.ParamRegExpEnd;
          else customRe += char;
          break;
        case TokenizerState.ParamRegExpEnd:
          consumeBuffer();
          state = TokenizerState.Static;
          if (char !== "*" && char !== "?" && char !== "+") i--;
          customRe = "";
          break;
        default:
          crash("Unknown state");
          break;
      }
    }
    if (state === TokenizerState.ParamRegExp) crash(`Unfinished custom RegExp for param "${buffer}"`);
    consumeBuffer();
    finalizeSegment();
    return tokens;
  }
  const BASE_PARAM_PATTERN = "[^/]+?";
  const BASE_PATH_PARSER_OPTIONS = {
    sensitive: false,
    strict: false,
    start: true,
    end: true
  };
  var PathScore = (function(PathScore$1) {
    PathScore$1[PathScore$1["_multiplier"] = 10] = "_multiplier";
    PathScore$1[PathScore$1["Root"] = 90] = "Root";
    PathScore$1[PathScore$1["Segment"] = 40] = "Segment";
    PathScore$1[PathScore$1["SubSegment"] = 30] = "SubSegment";
    PathScore$1[PathScore$1["Static"] = 40] = "Static";
    PathScore$1[PathScore$1["Dynamic"] = 20] = "Dynamic";
    PathScore$1[PathScore$1["BonusCustomRegExp"] = 10] = "BonusCustomRegExp";
    PathScore$1[PathScore$1["BonusWildcard"] = -50] = "BonusWildcard";
    PathScore$1[PathScore$1["BonusRepeatable"] = -20] = "BonusRepeatable";
    PathScore$1[PathScore$1["BonusOptional"] = -8] = "BonusOptional";
    PathScore$1[PathScore$1["BonusStrict"] = 0.7000000000000001] = "BonusStrict";
    PathScore$1[PathScore$1["BonusCaseSensitive"] = 0.25] = "BonusCaseSensitive";
    return PathScore$1;
  })(PathScore || {});
  const REGEX_CHARS_RE = /[.+*?^${}()[\]/\\]/g;
  function tokensToParser(segments, extraOptions) {
    const options = assign({}, BASE_PATH_PARSER_OPTIONS, extraOptions);
    const score = [];
    let pattern = options.start ? "^" : "";
    const keys = [];
    for (const segment of segments) {
      const segmentScores = segment.length ? [] : [PathScore.Root];
      if (options.strict && !segment.length) pattern += "/";
      for (let tokenIndex = 0; tokenIndex < segment.length; tokenIndex++) {
        const token = segment[tokenIndex];
        let subSegmentScore = PathScore.Segment + (options.sensitive ? PathScore.BonusCaseSensitive : 0);
        if (token.type === TokenType.Static) {
          if (!tokenIndex) pattern += "/";
          pattern += token.value.replace(REGEX_CHARS_RE, "\\$&");
          subSegmentScore += PathScore.Static;
        } else if (token.type === TokenType.Param) {
          const { value, repeatable, optional, regexp } = token;
          keys.push({
            name: value,
            repeatable,
            optional
          });
          const re$1 = regexp ? regexp : BASE_PARAM_PATTERN;
          if (re$1 !== BASE_PARAM_PATTERN) {
            subSegmentScore += PathScore.BonusCustomRegExp;
            try {
              `${re$1}`;
            } catch (err) {
              throw new Error(`Invalid custom RegExp for param "${value}" (${re$1}): ` + err.message);
            }
          }
          let subPattern = repeatable ? `((?:${re$1})(?:/(?:${re$1}))*)` : `(${re$1})`;
          if (!tokenIndex) subPattern = optional && segment.length < 2 ? `(?:/${subPattern})` : "/" + subPattern;
          if (optional) subPattern += "?";
          pattern += subPattern;
          subSegmentScore += PathScore.Dynamic;
          if (optional) subSegmentScore += PathScore.BonusOptional;
          if (repeatable) subSegmentScore += PathScore.BonusRepeatable;
          if (re$1 === ".*") subSegmentScore += PathScore.BonusWildcard;
        }
        segmentScores.push(subSegmentScore);
      }
      score.push(segmentScores);
    }
    if (options.strict && options.end) {
      const i = score.length - 1;
      score[i][score[i].length - 1] += PathScore.BonusStrict;
    }
    if (!options.strict) pattern += "/?";
    if (options.end) pattern += "$";
    else if (options.strict && !pattern.endsWith("/")) pattern += "(?:/|$)";
    const re = new RegExp(pattern, options.sensitive ? "" : "i");
    function parse(path) {
      const match = path.match(re);
      const params = {};
      if (!match) return null;
      for (let i = 1; i < match.length; i++) {
        const value = match[i] || "";
        const key = keys[i - 1];
        params[key.name] = value && key.repeatable ? value.split("/") : value;
      }
      return params;
    }
    function stringify(params) {
      let path = "";
      let avoidDuplicatedSlash = false;
      for (const segment of segments) {
        if (!avoidDuplicatedSlash || !path.endsWith("/")) path += "/";
        avoidDuplicatedSlash = false;
        for (const token of segment) if (token.type === TokenType.Static) path += token.value;
        else if (token.type === TokenType.Param) {
          const { value, repeatable, optional } = token;
          const param = value in params ? params[value] : "";
          if (isArray(param) && !repeatable) throw new Error(`Provided param "${value}" is an array but it is not repeatable (* or + modifiers)`);
          const text = isArray(param) ? param.join("/") : param;
          if (!text) if (optional) {
            if (segment.length < 2) if (path.endsWith("/")) path = path.slice(0, -1);
            else avoidDuplicatedSlash = true;
          } else throw new Error(`Missing required param "${value}"`);
          path += text;
        }
      }
      return path || "/";
    }
    return {
      re,
      score,
      keys,
      parse,
      stringify
    };
  }
  function compareScoreArray(a, b) {
    let i = 0;
    while (i < a.length && i < b.length) {
      const diff = b[i] - a[i];
      if (diff) return diff;
      i++;
    }
    if (a.length < b.length) return a.length === 1 && a[0] === PathScore.Static + PathScore.Segment ? -1 : 1;
    else if (a.length > b.length) return b.length === 1 && b[0] === PathScore.Static + PathScore.Segment ? 1 : -1;
    return 0;
  }
  function comparePathParserScore(a, b) {
    let i = 0;
    const aScore = a.score;
    const bScore = b.score;
    while (i < aScore.length && i < bScore.length) {
      const comp = compareScoreArray(aScore[i], bScore[i]);
      if (comp) return comp;
      i++;
    }
    if (Math.abs(bScore.length - aScore.length) === 1) {
      if (isLastScoreNegative(aScore)) return 1;
      if (isLastScoreNegative(bScore)) return -1;
    }
    return bScore.length - aScore.length;
  }
  function isLastScoreNegative(score) {
    const last = score[score.length - 1];
    return score.length > 0 && last[last.length - 1] < 0;
  }
  const PATH_PARSER_OPTIONS_DEFAULTS = {
    strict: false,
    end: true,
    sensitive: false
  };
  function createRouteRecordMatcher(record, parent, options) {
    const parser = tokensToParser(tokenizePath(record.path), options);
    const matcher = assign(parser, {
      record,
      parent,
      children: [],
      alias: []
    });
    if (parent) {
      if (!matcher.record.aliasOf === !parent.record.aliasOf) parent.children.push(matcher);
    }
    return matcher;
  }
  function createRouterMatcher(routes, globalOptions) {
    const matchers = [];
    const matcherMap = new Map();
    globalOptions = mergeOptions(PATH_PARSER_OPTIONS_DEFAULTS, globalOptions);
    function getRecordMatcher(name) {
      return matcherMap.get(name);
    }
    function addRoute(record, parent, originalRecord) {
      const isRootAdd = !originalRecord;
      const mainNormalizedRecord = normalizeRouteRecord(record);
      mainNormalizedRecord.aliasOf = originalRecord && originalRecord.record;
      const options = mergeOptions(globalOptions, record);
      const normalizedRecords = [mainNormalizedRecord];
      if ("alias" in record) {
        const aliases = typeof record.alias === "string" ? [record.alias] : record.alias;
        for (const alias of aliases) normalizedRecords.push(normalizeRouteRecord(assign({}, mainNormalizedRecord, {
          components: originalRecord ? originalRecord.record.components : mainNormalizedRecord.components,
          path: alias,
          aliasOf: originalRecord ? originalRecord.record : mainNormalizedRecord
        })));
      }
      let matcher;
      let originalMatcher;
      for (const normalizedRecord of normalizedRecords) {
        const { path } = normalizedRecord;
        if (parent && path[0] !== "/") {
          const parentPath = parent.record.path;
          const connectingSlash = parentPath[parentPath.length - 1] === "/" ? "" : "/";
          normalizedRecord.path = parent.record.path + (path && connectingSlash + path);
        }
        matcher = createRouteRecordMatcher(normalizedRecord, parent, options);
        if (originalRecord) {
          originalRecord.alias.push(matcher);
        } else {
          originalMatcher = originalMatcher || matcher;
          if (originalMatcher !== matcher) originalMatcher.alias.push(matcher);
          if (isRootAdd && record.name && !isAliasRecord(matcher)) {
            removeRoute(record.name);
          }
        }
        if (isMatchable(matcher)) insertMatcher(matcher);
        if (mainNormalizedRecord.children) {
          const children = mainNormalizedRecord.children;
          for (let i = 0; i < children.length; i++) addRoute(children[i], matcher, originalRecord && originalRecord.children[i]);
        }
        originalRecord = originalRecord || matcher;
      }
      return originalMatcher ? () => {
        removeRoute(originalMatcher);
      } : noop;
    }
    function removeRoute(matcherRef) {
      if (isRouteName(matcherRef)) {
        const matcher = matcherMap.get(matcherRef);
        if (matcher) {
          matcherMap.delete(matcherRef);
          matchers.splice(matchers.indexOf(matcher), 1);
          matcher.children.forEach(removeRoute);
          matcher.alias.forEach(removeRoute);
        }
      } else {
        const index = matchers.indexOf(matcherRef);
        if (index > -1) {
          matchers.splice(index, 1);
          if (matcherRef.record.name) matcherMap.delete(matcherRef.record.name);
          matcherRef.children.forEach(removeRoute);
          matcherRef.alias.forEach(removeRoute);
        }
      }
    }
    function getRoutes() {
      return matchers;
    }
    function insertMatcher(matcher) {
      const index = findInsertionIndex(matcher, matchers);
      matchers.splice(index, 0, matcher);
      if (matcher.record.name && !isAliasRecord(matcher)) matcherMap.set(matcher.record.name, matcher);
    }
    function resolve(location$1, currentLocation) {
      let matcher;
      let params = {};
      let path;
      let name;
      if ("name" in location$1 && location$1.name) {
        matcher = matcherMap.get(location$1.name);
        if (!matcher) throw createRouterError(ErrorTypes.MATCHER_NOT_FOUND, { location: location$1 });
        name = matcher.record.name;
        params = assign(pickParams(currentLocation.params, matcher.keys.filter((k) => !k.optional).concat(matcher.parent ? matcher.parent.keys.filter((k) => k.optional) : []).map((k) => k.name)), location$1.params && pickParams(location$1.params, matcher.keys.map((k) => k.name)));
        path = matcher.stringify(params);
      } else if (location$1.path != null) {
        path = location$1.path;
        matcher = matchers.find((m) => m.re.test(path));
        if (matcher) {
          params = matcher.parse(path);
          name = matcher.record.name;
        }
      } else {
        matcher = currentLocation.name ? matcherMap.get(currentLocation.name) : matchers.find((m) => m.re.test(currentLocation.path));
        if (!matcher) throw createRouterError(ErrorTypes.MATCHER_NOT_FOUND, {
          location: location$1,
          currentLocation
        });
        name = matcher.record.name;
        params = assign({}, currentLocation.params, location$1.params);
        path = matcher.stringify(params);
      }
      const matched = [];
      let parentMatcher = matcher;
      while (parentMatcher) {
        matched.unshift(parentMatcher.record);
        parentMatcher = parentMatcher.parent;
      }
      return {
        name,
        path,
        params,
        matched,
        meta: mergeMetaFields(matched)
      };
    }
    routes.forEach((route) => addRoute(route));
    function clearRoutes() {
      matchers.length = 0;
      matcherMap.clear();
    }
    return {
      addRoute,
      resolve,
      removeRoute,
      clearRoutes,
      getRoutes,
      getRecordMatcher
    };
  }
  function pickParams(params, keys) {
    const newParams = {};
    for (const key of keys) if (key in params) newParams[key] = params[key];
    return newParams;
  }
  function normalizeRouteRecord(record) {
    const normalized = {
      path: record.path,
      redirect: record.redirect,
      name: record.name,
      meta: record.meta || {},
      aliasOf: record.aliasOf,
      beforeEnter: record.beforeEnter,
      props: normalizeRecordProps(record),
      children: record.children || [],
      instances: {},
      leaveGuards: new Set(),
      updateGuards: new Set(),
      enterCallbacks: {},
      components: "components" in record ? record.components || null : record.component && { default: record.component }
    };
    Object.defineProperty(normalized, "mods", { value: {} });
    return normalized;
  }
  function normalizeRecordProps(record) {
    const propsObject = {};
    const props = record.props || false;
    if ("component" in record) propsObject.default = props;
    else for (const name in record.components) propsObject[name] = typeof props === "object" ? props[name] : props;
    return propsObject;
  }
  function isAliasRecord(record) {
    while (record) {
      if (record.record.aliasOf) return true;
      record = record.parent;
    }
    return false;
  }
  function mergeMetaFields(matched) {
    return matched.reduce((meta, record) => assign(meta, record.meta), {});
  }
  function findInsertionIndex(matcher, matchers) {
    let lower = 0;
    let upper = matchers.length;
    while (lower !== upper) {
      const mid = lower + upper >> 1;
      if (comparePathParserScore(matcher, matchers[mid]) < 0) upper = mid;
      else lower = mid + 1;
    }
    const insertionAncestor = getInsertionAncestor(matcher);
    if (insertionAncestor) {
      upper = matchers.lastIndexOf(insertionAncestor, upper - 1);
    }
    return upper;
  }
  function getInsertionAncestor(matcher) {
    let ancestor = matcher;
    while (ancestor = ancestor.parent) if (isMatchable(ancestor) && comparePathParserScore(matcher, ancestor) === 0) return ancestor;
  }
  function isMatchable({ record }) {
    return !!(record.name || record.components && Object.keys(record.components).length || record.redirect);
  }
  function useLink(props) {
    const router2 = vue.inject(routerKey);
    const currentRoute = vue.inject(routeLocationKey);
    const route = vue.computed(() => {
      const to = vue.unref(props.to);
      return router2.resolve(to);
    });
    const activeRecordIndex = vue.computed(() => {
      const { matched } = route.value;
      const { length } = matched;
      const routeMatched = matched[length - 1];
      const currentMatched = currentRoute.matched;
      if (!routeMatched || !currentMatched.length) return -1;
      const index = currentMatched.findIndex(isSameRouteRecord.bind(null, routeMatched));
      if (index > -1) return index;
      const parentRecordPath = getOriginalPath(matched[length - 2]);
      return length > 1 && getOriginalPath(routeMatched) === parentRecordPath && currentMatched[currentMatched.length - 1].path !== parentRecordPath ? currentMatched.findIndex(isSameRouteRecord.bind(null, matched[length - 2])) : index;
    });
    const isActive = vue.computed(() => activeRecordIndex.value > -1 && includesParams(currentRoute.params, route.value.params));
    const isExactActive = vue.computed(() => activeRecordIndex.value > -1 && activeRecordIndex.value === currentRoute.matched.length - 1 && isSameRouteLocationParams(currentRoute.params, route.value.params));
    function navigate(e = {}) {
      if (guardEvent(e)) {
        const p = router2[vue.unref(props.replace) ? "replace" : "push"](vue.unref(props.to)).catch(noop);
        if (props.viewTransition && typeof document !== "undefined" && "startViewTransition" in document) document.startViewTransition(() => p);
        return p;
      }
      return Promise.resolve();
    }
    return {
      route,
      href: vue.computed(() => route.value.href),
      isActive,
      isExactActive,
      navigate
    };
  }
  function preferSingleVNode(vnodes) {
    return vnodes.length === 1 ? vnodes[0] : vnodes;
  }
  const RouterLinkImpl = vue.defineComponent({
    name: "RouterLink",
    compatConfig: { MODE: 3 },
    props: {
      to: {
        type: [String, Object],
        required: true
      },
      replace: Boolean,
      activeClass: String,
      exactActiveClass: String,
      custom: Boolean,
      ariaCurrentValue: {
        type: String,
        default: "page"
      },
      viewTransition: Boolean
    },
    useLink,
    setup(props, { slots }) {
      const link = vue.reactive(useLink(props));
      const { options } = vue.inject(routerKey);
      const elClass = vue.computed(() => ({
        [getLinkClass(props.activeClass, options.linkActiveClass, "router-link-active")]: link.isActive,
        [getLinkClass(props.exactActiveClass, options.linkExactActiveClass, "router-link-exact-active")]: link.isExactActive
      }));
      return () => {
        const children = slots.default && preferSingleVNode(slots.default(link));
        return props.custom ? children : vue.h("a", {
          "aria-current": link.isExactActive ? props.ariaCurrentValue : null,
          href: link.href,
          onClick: link.navigate,
          class: elClass.value
        }, children);
      };
    }
  });
  const RouterLink = RouterLinkImpl;
  function guardEvent(e) {
    if (e.metaKey || e.altKey || e.ctrlKey || e.shiftKey) return;
    if (e.defaultPrevented) return;
    if (e.button !== void 0 && e.button !== 0) return;
    if (e.currentTarget && e.currentTarget.getAttribute) {
      const target = e.currentTarget.getAttribute("target");
      if (/\b_blank\b/i.test(target)) return;
    }
    if (e.preventDefault) e.preventDefault();
    return true;
  }
  function includesParams(outer, inner) {
    for (const key in inner) {
      const innerValue = inner[key];
      const outerValue = outer[key];
      if (typeof innerValue === "string") {
        if (innerValue !== outerValue) return false;
      } else if (!isArray(outerValue) || outerValue.length !== innerValue.length || innerValue.some((value, i) => value !== outerValue[i])) return false;
    }
    return true;
  }
  function getOriginalPath(record) {
    return record ? record.aliasOf ? record.aliasOf.path : record.path : "";
  }
  const getLinkClass = (propClass, globalClass, defaultClass) => propClass != null ? propClass : globalClass != null ? globalClass : defaultClass;
  const RouterViewImpl = vue.defineComponent({
    name: "RouterView",
    inheritAttrs: false,
    props: {
      name: {
        type: String,
        default: "default"
      },
      route: Object
    },
    compatConfig: { MODE: 3 },
    setup(props, { attrs, slots }) {
      const injectedRoute = vue.inject(routerViewLocationKey);
      const routeToDisplay = vue.computed(() => props.route || injectedRoute.value);
      const injectedDepth = vue.inject(viewDepthKey, 0);
      const depth = vue.computed(() => {
        let initialDepth = vue.unref(injectedDepth);
        const { matched } = routeToDisplay.value;
        let matchedRoute;
        while ((matchedRoute = matched[initialDepth]) && !matchedRoute.components) initialDepth++;
        return initialDepth;
      });
      const matchedRouteRef = vue.computed(() => routeToDisplay.value.matched[depth.value]);
      vue.provide(viewDepthKey, vue.computed(() => depth.value + 1));
      vue.provide(matchedRouteKey, matchedRouteRef);
      vue.provide(routerViewLocationKey, routeToDisplay);
      const viewRef = vue.ref();
      vue.watch(() => [
        viewRef.value,
        matchedRouteRef.value,
        props.name
      ], ([instance, to, name], [oldInstance, from, oldName]) => {
        if (to) {
          to.instances[name] = instance;
          if (from && from !== to && instance && instance === oldInstance) {
            if (!to.leaveGuards.size) to.leaveGuards = from.leaveGuards;
            if (!to.updateGuards.size) to.updateGuards = from.updateGuards;
          }
        }
        if (instance && to && (!from || !isSameRouteRecord(to, from) || !oldInstance)) (to.enterCallbacks[name] || []).forEach((callback) => callback(instance));
      }, { flush: "post" });
      return () => {
        const route = routeToDisplay.value;
        const currentName = props.name;
        const matchedRoute = matchedRouteRef.value;
        const ViewComponent = matchedRoute && matchedRoute.components[currentName];
        if (!ViewComponent) return normalizeSlot(slots.default, {
          Component: ViewComponent,
          route
        });
        const routePropsOption = matchedRoute.props[currentName];
        const routeProps = routePropsOption ? routePropsOption === true ? route.params : typeof routePropsOption === "function" ? routePropsOption(route) : routePropsOption : null;
        const onVnodeUnmounted = (vnode) => {
          if (vnode.component.isUnmounted) matchedRoute.instances[currentName] = null;
        };
        const component = vue.h(ViewComponent, assign({}, routeProps, attrs, {
          onVnodeUnmounted,
          ref: viewRef
        }));
        return normalizeSlot(slots.default, {
          Component: component,
          route
        }) || component;
      };
    }
  });
  function normalizeSlot(slot, data) {
    if (!slot) return null;
    const slotContent = slot(data);
    return slotContent.length === 1 ? slotContent[0] : slotContent;
  }
  const RouterView = RouterViewImpl;
  function createRouter(options) {
    const matcher = createRouterMatcher(options.routes, options);
    const parseQuery$1 = options.parseQuery || parseQuery;
    const stringifyQuery$1 = options.stringifyQuery || stringifyQuery;
    const routerHistory = options.history;
    const beforeGuards = useCallbacks();
    const beforeResolveGuards = useCallbacks();
    const afterGuards = useCallbacks();
    const currentRoute = vue.shallowRef(START_LOCATION_NORMALIZED);
    let pendingLocation = START_LOCATION_NORMALIZED;
    if (isBrowser && options.scrollBehavior && "scrollRestoration" in history) history.scrollRestoration = "manual";
    const normalizeParams = applyToParams.bind(null, (paramValue) => "" + paramValue);
    const encodeParams = applyToParams.bind(null, encodeParam);
    const decodeParams = applyToParams.bind(null, decode);
    function addRoute(parentOrRoute, route) {
      let parent;
      let record;
      if (isRouteName(parentOrRoute)) {
        parent = matcher.getRecordMatcher(parentOrRoute);
        record = route;
      } else record = parentOrRoute;
      return matcher.addRoute(record, parent);
    }
    function removeRoute(name) {
      const recordMatcher = matcher.getRecordMatcher(name);
      if (recordMatcher) matcher.removeRoute(recordMatcher);
    }
    function getRoutes() {
      return matcher.getRoutes().map((routeMatcher) => routeMatcher.record);
    }
    function hasRoute(name) {
      return !!matcher.getRecordMatcher(name);
    }
    function resolve(rawLocation, currentLocation) {
      currentLocation = assign({}, currentLocation || currentRoute.value);
      if (typeof rawLocation === "string") {
        const locationNormalized = parseURL(parseQuery$1, rawLocation, currentLocation.path);
        const matchedRoute$1 = matcher.resolve({ path: locationNormalized.path }, currentLocation);
        const href$1 = routerHistory.createHref(locationNormalized.fullPath);
        return assign(locationNormalized, matchedRoute$1, {
          params: decodeParams(matchedRoute$1.params),
          hash: decode(locationNormalized.hash),
          redirectedFrom: void 0,
          href: href$1
        });
      }
      let matcherLocation;
      if (rawLocation.path != null) {
        matcherLocation = assign({}, rawLocation, { path: parseURL(parseQuery$1, rawLocation.path, currentLocation.path).path });
      } else {
        const targetParams = assign({}, rawLocation.params);
        for (const key in targetParams) if (targetParams[key] == null) delete targetParams[key];
        matcherLocation = assign({}, rawLocation, { params: encodeParams(targetParams) });
        currentLocation.params = encodeParams(currentLocation.params);
      }
      const matchedRoute = matcher.resolve(matcherLocation, currentLocation);
      const hash = rawLocation.hash || "";
      matchedRoute.params = normalizeParams(decodeParams(matchedRoute.params));
      const fullPath = stringifyURL(stringifyQuery$1, assign({}, rawLocation, {
        hash: encodeHash(hash),
        path: matchedRoute.path
      }));
      const href = routerHistory.createHref(fullPath);
      return assign({
        fullPath,
        hash,
        query: stringifyQuery$1 === stringifyQuery ? normalizeQuery(rawLocation.query) : rawLocation.query || {}
      }, matchedRoute, {
        redirectedFrom: void 0,
        href
      });
    }
    function locationAsObject(to) {
      return typeof to === "string" ? parseURL(parseQuery$1, to, currentRoute.value.path) : assign({}, to);
    }
    function checkCanceledNavigation(to, from) {
      if (pendingLocation !== to) return createRouterError(ErrorTypes.NAVIGATION_CANCELLED, {
        from,
        to
      });
    }
    function push(to) {
      return pushWithRedirect(to);
    }
    function replace(to) {
      return push(assign(locationAsObject(to), { replace: true }));
    }
    function handleRedirectRecord(to, from) {
      const lastMatched = to.matched[to.matched.length - 1];
      if (lastMatched && lastMatched.redirect) {
        const { redirect } = lastMatched;
        let newTargetLocation = typeof redirect === "function" ? redirect(to, from) : redirect;
        if (typeof newTargetLocation === "string") {
          newTargetLocation = newTargetLocation.includes("?") || newTargetLocation.includes("#") ? newTargetLocation = locationAsObject(newTargetLocation) : { path: newTargetLocation };
          newTargetLocation.params = {};
        }
        return assign({
          query: to.query,
          hash: to.hash,
          params: newTargetLocation.path != null ? {} : to.params
        }, newTargetLocation);
      }
    }
    function pushWithRedirect(to, redirectedFrom) {
      const targetLocation = pendingLocation = resolve(to);
      const from = currentRoute.value;
      const data = to.state;
      const force = to.force;
      const replace$1 = to.replace === true;
      const shouldRedirect = handleRedirectRecord(targetLocation, from);
      if (shouldRedirect) return pushWithRedirect(assign(locationAsObject(shouldRedirect), {
        state: typeof shouldRedirect === "object" ? assign({}, data, shouldRedirect.state) : data,
        force,
        replace: replace$1
      }), redirectedFrom || targetLocation);
      const toLocation = targetLocation;
      toLocation.redirectedFrom = redirectedFrom;
      let failure;
      if (!force && isSameRouteLocation(stringifyQuery$1, from, targetLocation)) {
        failure = createRouterError(ErrorTypes.NAVIGATION_DUPLICATED, {
          to: toLocation,
          from
        });
        handleScroll(from, from, true, false);
      }
      return (failure ? Promise.resolve(failure) : navigate(toLocation, from)).catch((error) => isNavigationFailure(error) ? isNavigationFailure(error, ErrorTypes.NAVIGATION_GUARD_REDIRECT) ? error : markAsReady(error) : triggerError(error, toLocation, from)).then((failure$1) => {
        if (failure$1) {
          if (isNavigationFailure(failure$1, ErrorTypes.NAVIGATION_GUARD_REDIRECT)) {
            return pushWithRedirect(assign({ replace: replace$1 }, locationAsObject(failure$1.to), {
              state: typeof failure$1.to === "object" ? assign({}, data, failure$1.to.state) : data,
              force
            }), redirectedFrom || toLocation);
          }
        } else failure$1 = finalizeNavigation(toLocation, from, true, replace$1, data);
        triggerAfterEach(toLocation, from, failure$1);
        return failure$1;
      });
    }
    function checkCanceledNavigationAndReject(to, from) {
      const error = checkCanceledNavigation(to, from);
      return error ? Promise.reject(error) : Promise.resolve();
    }
    function runWithContext(fn) {
      const app = installedApps.values().next().value;
      return app && typeof app.runWithContext === "function" ? app.runWithContext(fn) : fn();
    }
    function navigate(to, from) {
      let guards;
      const [leavingRecords, updatingRecords, enteringRecords] = extractChangingRecords(to, from);
      guards = extractComponentsGuards(leavingRecords.reverse(), "beforeRouteLeave", to, from);
      for (const record of leavingRecords) record.leaveGuards.forEach((guard) => {
        guards.push(guardToPromiseFn(guard, to, from));
      });
      const canceledNavigationCheck = checkCanceledNavigationAndReject.bind(null, to, from);
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards).then(() => {
        guards = [];
        for (const guard of beforeGuards.list()) guards.push(guardToPromiseFn(guard, to, from));
        guards.push(canceledNavigationCheck);
        return runGuardQueue(guards);
      }).then(() => {
        guards = extractComponentsGuards(updatingRecords, "beforeRouteUpdate", to, from);
        for (const record of updatingRecords) record.updateGuards.forEach((guard) => {
          guards.push(guardToPromiseFn(guard, to, from));
        });
        guards.push(canceledNavigationCheck);
        return runGuardQueue(guards);
      }).then(() => {
        guards = [];
        for (const record of enteringRecords) if (record.beforeEnter) if (isArray(record.beforeEnter)) for (const beforeEnter of record.beforeEnter) guards.push(guardToPromiseFn(beforeEnter, to, from));
        else guards.push(guardToPromiseFn(record.beforeEnter, to, from));
        guards.push(canceledNavigationCheck);
        return runGuardQueue(guards);
      }).then(() => {
        to.matched.forEach((record) => record.enterCallbacks = {});
        guards = extractComponentsGuards(enteringRecords, "beforeRouteEnter", to, from, runWithContext);
        guards.push(canceledNavigationCheck);
        return runGuardQueue(guards);
      }).then(() => {
        guards = [];
        for (const guard of beforeResolveGuards.list()) guards.push(guardToPromiseFn(guard, to, from));
        guards.push(canceledNavigationCheck);
        return runGuardQueue(guards);
      }).catch((err) => isNavigationFailure(err, ErrorTypes.NAVIGATION_CANCELLED) ? err : Promise.reject(err));
    }
    function triggerAfterEach(to, from, failure) {
      afterGuards.list().forEach((guard) => runWithContext(() => guard(to, from, failure)));
    }
    function finalizeNavigation(toLocation, from, isPush, replace$1, data) {
      const error = checkCanceledNavigation(toLocation, from);
      if (error) return error;
      const isFirstNavigation = from === START_LOCATION_NORMALIZED;
      const state = !isBrowser ? {} : history.state;
      if (isPush) if (replace$1 || isFirstNavigation) routerHistory.replace(toLocation.fullPath, assign({ scroll: isFirstNavigation && state && state.scroll }, data));
      else routerHistory.push(toLocation.fullPath, data);
      currentRoute.value = toLocation;
      handleScroll(toLocation, from, isPush, isFirstNavigation);
      markAsReady();
    }
    let removeHistoryListener;
    function setupListeners() {
      if (removeHistoryListener) return;
      removeHistoryListener = routerHistory.listen((to, _from, info) => {
        if (!router2.listening) return;
        const toLocation = resolve(to);
        const shouldRedirect = handleRedirectRecord(toLocation, router2.currentRoute.value);
        if (shouldRedirect) {
          pushWithRedirect(assign(shouldRedirect, {
            replace: true,
            force: true
          }), toLocation).catch(noop);
          return;
        }
        pendingLocation = toLocation;
        const from = currentRoute.value;
        if (isBrowser) saveScrollPosition(getScrollKey(from.fullPath, info.delta), computeScrollPosition());
        navigate(toLocation, from).catch((error) => {
          if (isNavigationFailure(error, ErrorTypes.NAVIGATION_ABORTED | ErrorTypes.NAVIGATION_CANCELLED)) return error;
          if (isNavigationFailure(error, ErrorTypes.NAVIGATION_GUARD_REDIRECT)) {
            pushWithRedirect(assign(locationAsObject(error.to), { force: true }), toLocation).then((failure) => {
              if (isNavigationFailure(failure, ErrorTypes.NAVIGATION_ABORTED | ErrorTypes.NAVIGATION_DUPLICATED) && !info.delta && info.type === NavigationType.pop) routerHistory.go(-1, false);
            }).catch(noop);
            return Promise.reject();
          }
          if (info.delta) routerHistory.go(-info.delta, false);
          return triggerError(error, toLocation, from);
        }).then((failure) => {
          failure = failure || finalizeNavigation(toLocation, from, false);
          if (failure) {
            if (info.delta && !isNavigationFailure(failure, ErrorTypes.NAVIGATION_CANCELLED)) routerHistory.go(-info.delta, false);
            else if (info.type === NavigationType.pop && isNavigationFailure(failure, ErrorTypes.NAVIGATION_ABORTED | ErrorTypes.NAVIGATION_DUPLICATED)) routerHistory.go(-1, false);
          }
          triggerAfterEach(toLocation, from, failure);
        }).catch(noop);
      });
    }
    let readyHandlers = useCallbacks();
    let errorListeners = useCallbacks();
    let ready;
    function triggerError(error, to, from) {
      markAsReady(error);
      const list = errorListeners.list();
      if (list.length) list.forEach((handler) => handler(error, to, from));
      else {
        console.error(error);
      }
      return Promise.reject(error);
    }
    function isReady() {
      if (ready && currentRoute.value !== START_LOCATION_NORMALIZED) return Promise.resolve();
      return new Promise((resolve$1, reject) => {
        readyHandlers.add([resolve$1, reject]);
      });
    }
    function markAsReady(err) {
      if (!ready) {
        ready = !err;
        setupListeners();
        readyHandlers.list().forEach(([resolve$1, reject]) => err ? reject(err) : resolve$1());
        readyHandlers.reset();
      }
      return err;
    }
    function handleScroll(to, from, isPush, isFirstNavigation) {
      const { scrollBehavior } = options;
      if (!isBrowser || !scrollBehavior) return Promise.resolve();
      const scrollPosition = !isPush && getSavedScrollPosition(getScrollKey(to.fullPath, 0)) || (isFirstNavigation || !isPush) && history.state && history.state.scroll || null;
      return vue.nextTick().then(() => scrollBehavior(to, from, scrollPosition)).then((position) => position && scrollToPosition(position)).catch((err) => triggerError(err, to, from));
    }
    const go = (delta) => routerHistory.go(delta);
    let started;
    const installedApps = new Set();
    const router2 = {
      currentRoute,
      listening: true,
      addRoute,
      removeRoute,
      clearRoutes: matcher.clearRoutes,
      hasRoute,
      getRoutes,
      resolve,
      options,
      push,
      replace,
      go,
      back: () => go(-1),
      forward: () => go(1),
      beforeEach: beforeGuards.add,
      beforeResolve: beforeResolveGuards.add,
      afterEach: afterGuards.add,
      onError: errorListeners.add,
      isReady,
      install(app) {
        app.component("RouterLink", RouterLink);
        app.component("RouterView", RouterView);
        app.config.globalProperties.$router = router2;
        Object.defineProperty(app.config.globalProperties, "$route", {
          enumerable: true,
          get: () => vue.unref(currentRoute)
        });
        if (isBrowser && !started && currentRoute.value === START_LOCATION_NORMALIZED) {
          started = true;
          push(routerHistory.location).catch((err) => {
          });
        }
        const reactiveRoute = {};
        for (const key in START_LOCATION_NORMALIZED) Object.defineProperty(reactiveRoute, key, {
          get: () => currentRoute.value[key],
          enumerable: true
        });
        app.provide(routerKey, router2);
        app.provide(routeLocationKey, vue.shallowReactive(reactiveRoute));
        app.provide(routerViewLocationKey, currentRoute);
        const unmountApp = app.unmount;
        installedApps.add(app);
        app.unmount = function() {
          installedApps.delete(app);
          if (installedApps.size < 1) {
            pendingLocation = START_LOCATION_NORMALIZED;
            removeHistoryListener && removeHistoryListener();
            removeHistoryListener = null;
            currentRoute.value = START_LOCATION_NORMALIZED;
            started = false;
            ready = false;
          }
          unmountApp();
        };
      }
    };
    function runGuardQueue(guards) {
      return guards.reduce((promise, guard) => promise.then(() => runWithContext(guard)), Promise.resolve());
    }
    return router2;
  }
  const _hoisted_1$5 = {
    class: "w-full h-screen flex flex-col bg-gray-950 text-white overflow-hidden",
    style: { "min-width": "1270px", "min-height": "720px" }
  };
  const _hoisted_2$5 = { class: "flex-shrink-0 bg-gray-900 border-b border-gray-800 shadow-lg" };
  const _hoisted_3$5 = { class: "flex items-center h-14" };
  const _hoisted_4$4 = { class: "flex-1 overflow-hidden" };
  const _sfc_main$5 = vue.defineComponent({
    __name: "App",
    setup(__props) {
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$5, [
          vue.createElementVNode("nav", _hoisted_2$5, [
            vue.createElementVNode("div", _hoisted_3$5, [
              vue.createVNode(vue.unref(RouterLink), {
                to: "/tts",
                class: "relative px-8 h-full flex items-center text-sm font-semibold transition-all duration-200 hover:bg-gray-800/50"
              }, {
                default: vue.withCtx(() => [..._cache[0] || (_cache[0] = [
                  vue.createElementVNode("span", { class: "relative z-10" }, "TTS 자막 변환", -1),
                  vue.createElementVNode("div", { class: "absolute bottom-0 left-0 right-0 h-0.5 bg-blue-500 router-link-active:block hidden" }, null, -1)
                ])]),
                _: 1
              }),
              vue.createVNode(vue.unref(RouterLink), {
                to: "/settings",
                class: "relative px-8 h-full flex items-center text-sm font-semibold transition-all duration-200 hover:bg-gray-800/50"
              }, {
                default: vue.withCtx(() => [..._cache[1] || (_cache[1] = [
                  vue.createElementVNode("span", { class: "relative z-10" }, "설정", -1),
                  vue.createElementVNode("div", { class: "absolute bottom-0 left-0 right-0 h-0.5 bg-blue-500 router-link-active:block hidden" }, null, -1)
                ])]),
                _: 1
              })
            ])
          ]),
          vue.createElementVNode("div", _hoisted_4$4, [
            vue.createVNode(vue.unref(RouterView))
          ])
        ]);
      };
    }
  });
  const _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };
  const App = _export_sfc(_sfc_main$5, [["__scopeId", "data-v-c31ba9e1"]]);
  function getGM_xmlhttpRequest$1() {
    console.log("[VOICEVOX] getGM_xmlhttpRequest 호출");
    console.log("[VOICEVOX] window.parentGM_xmlhttpRequest:", typeof window.parentGM_xmlhttpRequest);
    if (window.parentGM_xmlhttpRequest) {
      console.log("[VOICEVOX] ✅ 팝업 창의 parentGM_xmlhttpRequest 사용");
      return window.parentGM_xmlhttpRequest;
    }
    try {
      const { GM_xmlhttpRequest: GM_xmlhttpRequest2 } = require("$");
      console.log("[VOICEVOX] ✅ require($)에서 GM_xmlhttpRequest 가져옴");
      return GM_xmlhttpRequest2;
    } catch (error) {
      console.error("[VOICEVOX] ❌ GM_xmlhttpRequest를 찾을 수 없음:", error);
      console.warn("[VOICEVOX] ⚠️ 개발 모드: 일반 fetch로 대체 시도 (CORS 문제 발생 가능)");
      return null;
    }
  }
  function gmFetch$1(url, options) {
    console.log(`[VOICEVOX] 요청 시작: ${options.method} ${url}`);
    return new Promise((resolve, reject) => {
      try {
        const GM_xmlhttpRequest2 = getGM_xmlhttpRequest$1();
        if (GM_xmlhttpRequest2) {
          GM_xmlhttpRequest2({
            method: options.method,
            url,
            headers: options.headers,
            data: options.data,
            responseType: options.responseType,
            timeout: options.timeout || 3e4,
onload: (response) => {
              console.log(`[VOICEVOX] 응답 수신: ${response.status} ${response.statusText}`);
              if (response.status >= 200 && response.status < 300) {
                resolve(response.response);
              } else {
                const error = new Error(`HTTP ${response.status}: ${response.statusText}`);
                console.error("[VOICEVOX] HTTP 에러:", error);
                reject(error);
              }
            },
            onerror: (error) => {
              console.error("[VOICEVOX] 네트워크 에러:", error);
              reject(new Error("VOICEVOX 서버 연결 실패"));
            },
            ontimeout: () => {
              console.error("[VOICEVOX] 타임아웃 (30초 초과)");
              reject(new Error("VOICEVOX 서버 응답 시간 초과 (30초)"));
            }
          });
        } else {
          console.warn("[VOICEVOX] ⚠️ GM_xmlhttpRequest 없음, fetch API 사용");
          fetch(url, {
            method: options.method,
            headers: options.headers,
            body: options.data
          }).then(async (response) => {
            console.log(`[VOICEVOX] 응답 수신 (fetch): ${response.status} ${response.statusText}`);
            if (!response.ok) {
              throw new Error(`HTTP ${response.status}: ${response.statusText}`);
            }
            if (options.responseType === "blob") {
              return response.blob();
            } else {
              return response.json();
            }
          }).then(resolve).catch((error) => {
            console.error("[VOICEVOX] Fetch 에러:", error);
            reject(error);
          });
        }
      } catch (error) {
        console.error("[VOICEVOX] 요청 실행 에러:", error);
        reject(error);
      }
    });
  }
  async function checkServerStatus(serverUrl) {
    try {
      await gmFetch$1(`${serverUrl}/version`, {
        method: "GET",
        responseType: "json"
      });
      return true;
    } catch (error) {
      console.error("[VOICEVOX] 서버 연결 실패:", error);
      return false;
    }
  }
  async function fetchSpeakers(serverUrl) {
    const data = await gmFetch$1(`${serverUrl}/speakers`, {
      method: "GET",
      responseType: "json"
    });
    return data;
  }
  async function createAudioQuery(serverUrl, text, speaker) {
    const url = new URL(`${serverUrl}/audio_query`);
    url.searchParams.append("text", text);
    url.searchParams.append("speaker", speaker.toString());
    const data = await gmFetch$1(url.toString(), {
      method: "POST",
      responseType: "json"
    });
    return data;
  }
  async function synthesizeVoice(serverUrl, query, speaker) {
    const url = new URL(`${serverUrl}/synthesis`);
    url.searchParams.append("speaker", speaker.toString());
    const blob = await gmFetch$1(url.toString(), {
      method: "POST",
      headers: {
        "Content-Type": "application/json"
      },
      data: JSON.stringify(query),
      responseType: "blob"
    });
    return blob;
  }
  async function generateTTS(serverUrl, text, speaker, speed = 1) {
    const query = await createAudioQuery(serverUrl, text, speaker);
    query.speedScale = speed;
    const audioBlob = await synthesizeVoice(serverUrl, query, speaker);
    return audioBlob;
  }
  function getGM_xmlhttpRequest() {
    if (window.parentGM_xmlhttpRequest) {
      return window.parentGM_xmlhttpRequest;
    }
    try {
      const { GM_xmlhttpRequest: GM_xmlhttpRequest2 } = require("$");
      return GM_xmlhttpRequest2;
    } catch {
      throw new Error("GM_xmlhttpRequest를 사용할 수 없습니다.");
    }
  }
  function gmFetch(url, options, logPrefix = "AI") {
    console.log(`[${logPrefix}] 요청 시작: ${options.method} ${url}`);
    return new Promise((resolve, reject) => {
      try {
        const GM_xmlhttpRequest2 = getGM_xmlhttpRequest();
        GM_xmlhttpRequest2({
          method: options.method,
          url,
          headers: options.headers,
          data: options.data,
          responseType: options.responseType,
          timeout: options.timeout || 3e5,
onload: (response) => {
            console.log(`[${logPrefix}] 응답 수신: ${response.status} ${response.statusText}`);
            if (response.status >= 200 && response.status < 300) {
              resolve(response.response);
            } else {
              const error = new Error(`HTTP ${response.status}: ${response.statusText}`);
              console.error(`[${logPrefix}] HTTP 에러:`, error);
              reject(error);
            }
          },
          onerror: (error) => {
            console.error(`[${logPrefix}] 네트워크 에러:`, error);
            reject(new Error("네트워크 요청 실패"));
          },
          ontimeout: () => {
            console.error(`[${logPrefix}] 타임아웃 (5분 초과)`);
            reject(new Error("요청 시간 초과 (5분)"));
          }
        });
      } catch (error) {
        console.error(`[${logPrefix}] GM_xmlhttpRequest 호출 에러:`, error);
        reject(error);
      }
    });
  }
  function countKanji(text) {
    const kanjiRegex = /[\u4E00-\u9FAF\u3400-\u4DBF]/g;
    const matches = text.match(kanjiRegex);
    return matches ? matches.length : 0;
  }
  class BaseAiProvider {
async convertToYomi(text, apiKey, chunkSize = 50, onProgress, modelId = "") {
      if (!apiKey) {
        throw new Error(`${this.name} API 키가 설정되지 않았습니다.`);
      }
      if (!modelId) {
        throw new Error(`모델 ID가 지정되지 않았습니다.`);
      }
      const CHUNK_SIZE = chunkSize;
      const MAX_RETRIES = 3;
      const allLines = text.split("\n");
      const nonEmptyLines = allLines.filter((line) => line.trim().length > 0);
      console.log(`[${this.name}] 독음 변환 시작 (총 ${nonEmptyLines.length}줄, ${Math.ceil(nonEmptyLines.length / CHUNK_SIZE)}개 청크)`);
      const chunks = [];
      for (let i = 0; i < nonEmptyLines.length; i += CHUNK_SIZE) {
        chunks.push(nonEmptyLines.slice(i, i + CHUNK_SIZE));
      }
      const convertedChunks = [];
      let totalOriginalKanji = 0;
      let totalRemainingKanji = 0;
      for (let chunkIndex = 0; chunkIndex < chunks.length; chunkIndex++) {
        const chunk = chunks[chunkIndex];
        const chunkText = chunk.join("\n");
        const startLine = chunkIndex * CHUNK_SIZE + 1;
        const endLine = Math.min((chunkIndex + 1) * CHUNK_SIZE, nonEmptyLines.length);
        let retryCount = 0;
        let success = false;
        let convertedChunkText = "";
        let lastError = "";
        while (!success && retryCount < MAX_RETRIES) {
          try {
            if (onProgress) {
              const status = retryCount === 0 ? `📦 청크 ${chunkIndex + 1}/${chunks.length} 변환 중... (${startLine}-${endLine}줄)` : `🔄 청크 ${chunkIndex + 1}/${chunks.length} 재시도 ${retryCount}/${MAX_RETRIES} (이유: ${lastError})`;
              onProgress(chunkIndex + 1, chunks.length, status);
            }
            convertedChunkText = await this.callApi(chunkText, apiKey, modelId);
            const convertedLines = convertedChunkText.split("\n");
            const convertedLineCount = convertedLines.filter((line) => line.trim().length > 0).length;
            if (convertedLineCount !== chunk.length) {
              throw new Error(`줄 수 불일치 (${chunk.length}줄 → ${convertedLineCount}줄)`);
            }
            const originalKanjiCount = countKanji(chunkText);
            const remainingKanjiCount = countKanji(convertedChunkText);
            totalOriginalKanji += originalKanjiCount;
            totalRemainingKanji += remainingKanjiCount;
            if (originalKanjiCount > 0) {
              const conversionRate = ((originalKanjiCount - remainingKanjiCount) / originalKanjiCount * 100).toFixed(1);
              if (remainingKanjiCount > originalKanjiCount * 0.1) {
                throw new Error(`한자 ${remainingKanjiCount}개 잔존 (변환률 ${conversionRate}%)`);
              }
              console.log(`[${this.name}] 청크 ${chunkIndex + 1} 한자 변환: ${originalKanjiCount} → ${remainingKanjiCount}개 (${conversionRate}%)`);
            }
            success = true;
            convertedChunks.push(convertedChunkText);
            console.log(`[${this.name}] 청크 ${chunkIndex + 1}/${chunks.length} 변환 성공`);
          } catch (error) {
            retryCount++;
            const errorMessage = error instanceof Error ? error.message : String(error);
            lastError = errorMessage;
            console.error(`[${this.name}] 청크 ${chunkIndex + 1}/${chunks.length} 실패 (${retryCount}/${MAX_RETRIES}): ${errorMessage}`);
            if (retryCount >= MAX_RETRIES) {
              const finalMsg = `청크 ${chunkIndex + 1} 실패: ${errorMessage}`;
              console.error(`[${this.name}] ❌ 전체 변환 취소: ${finalMsg}`);
              throw new Error(finalMsg);
            }
            await new Promise((resolve) => setTimeout(resolve, 1e3));
          }
        }
      }
      const finalText = convertedChunks.join("\n");
      const finalLines = finalText.split("\n").filter((line) => line.trim().length > 0);
      if (finalLines.length !== nonEmptyLines.length) {
        console.warn(`[${this.name}] 최종 줄 수 불일치: 원본 ${nonEmptyLines.length}줄 → 변환 ${finalLines.length}줄`);
        throw new Error(`최종 줄 수가 일치하지 않습니다 (원본: ${nonEmptyLines.length}, 변환: ${finalLines.length})`);
      }
      if (totalOriginalKanji > 0) {
        const totalConversionRate = ((totalOriginalKanji - totalRemainingKanji) / totalOriginalKanji * 100).toFixed(1);
        console.log(`[${this.name}] 독음 변환 완료 (${nonEmptyLines.length}줄, ${chunks.length}개 청크)`);
        console.log(`[${this.name}] 한자 변환 통계: ${totalOriginalKanji}개 → ${totalRemainingKanji}개 잔존 (변환률: ${totalConversionRate}%)`);
        if (onProgress) {
          onProgress(chunks.length, chunks.length, `📊 한자 변환: ${totalOriginalKanji}개 → ${totalRemainingKanji}개 (변환률 ${totalConversionRate}%)`, {
            originalKanji: totalOriginalKanji,
            remainingKanji: totalRemainingKanji
          });
        }
      } else {
        console.log(`[${this.name}] 독음 변환 완료 (${nonEmptyLines.length}줄, ${chunks.length}개 청크)`);
      }
      return finalText;
    }
  }
  class GeminiProvider extends BaseAiProvider {
    name = "Gemini";
async callApi(text, apiKey, modelId) {
      const prompt = `以下の日本語テキストをすべてひらがなに変換してください。

【重要な指示】
1. すべての漢字を必ずひらがなに変換すること
2. 漢字を1文字でも残してはいけません（絶対厳守）
3. カタカナはそのまま維持
4. 数字は読み方に変換（例: "78歳" → "ななじゅうはっさい"）
5. 括弧や記号は削除
6. 改行は元のテキストと完全一致させる

【変換例】
入力: 私は七十八歳の田中ヨシコです。四十年前まで東京で会社を経営していました。
出力: わたしはななじゅうはっさいのたなかヨシコです。よんじゅうねんまえまでとうきょうでかいしゃをけいえいしていました。

【確認】
変換後、出力に漢字（私、東京、会社、年、前など）が1文字でも残っていないか必ず確認してください。

入力:
${text}

出力（ひらがなとカタカナのみ、漢字は絶対に残さない）:`;
      const apiUrl = `https://generativelanguage.googleapis.com/v1beta/models/${modelId}:generateContent?key=${apiKey}`;
      const response = await gmFetch(
        apiUrl,
        {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          data: JSON.stringify({
            contents: [
              {
                parts: [
                  {
                    text: prompt
                  }
                ]
              }
            ],
            generationConfig: {
              maxOutputTokens: 65536,
              temperature: 0.3
            }
          }),
          responseType: "json"
        },
        this.name
      );
      if (!response.candidates || !response.candidates[0]?.content?.parts?.[0]?.text) {
        throw new Error("API 응답 오류");
      }
      return response.candidates[0].content.parts[0].text.trim();
    }
  }
  class ClaudeProvider extends BaseAiProvider {
    name = "Claude";
async callApi(text, apiKey, modelId) {
      const prompt = `以下の日本語テキストをすべてひらがなに変換してください。

【重要な指示】
1. すべての漢字を必ずひらがなに変換すること
2. 漢字を1文字でも残してはいけません（絶対厳守）
3. カタカナはそのまま維持
4. 数字は読み方に変換（例: "78歳" → "ななじゅうはっさい"）
5. 括弧や記号は削除
6. 改行は元のテキストと完全一致させる

【変換例】
入力: 私は七十八歳の田中ヨシコです。四十年前まで東京で会社を経営していました。
出力: わたしはななじゅうはっさいのたなかヨシコです。よんじゅうねんまえまでとうきょうでかいしゃをけいえいしていました。

【確認】
変換後、出力に漢字（私、東京、会社、年、前など）が1文字でも残っていないか必ず確認してください。

入力:
${text}

出力（ひらがなとカタカナのみ、漢字は絶対に残さない）:`;
      const apiUrl = "https://api.anthropic.com/v1/messages";
      const response = await gmFetch(
        apiUrl,
        {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            "x-api-key": apiKey,
            "anthropic-version": "2023-06-01"
          },
          data: JSON.stringify({
            model: modelId,
max_tokens: 8192,
temperature: 0.3,
            messages: [
              {
                role: "user",
                content: prompt
              }
            ]
          }),
          responseType: "json"
        },
        this.name
      );
      if (!response.content || !response.content[0]?.text) {
        throw new Error("API 응답 오류");
      }
      return response.content[0].text.trim();
    }
  }
  const AI_MODELS = [
    {
      id: "gemini-2.5-flash",
      label: "[Gemini] gemini-2.5-flash",
      provider: "gemini"
    },
    {
      id: "claude-sonnet-4-5-20250929",
      label: "[Claude] Sonnet 4.5",
      provider: "claude"
    },
    {
      id: "claude-haiku-4-5-20251001",
      label: "[Claude] Haiku 4.5",
      provider: "claude"
    }
  ];
  function getProviderFromModel(modelId) {
    const model = AI_MODELS.find((m) => m.id === modelId);
    return model?.provider || "gemini";
  }
  const DEFAULT_AI_MODEL = "gemini-2.5-flash";
  const providerInstances = new Map();
  function getAiProvider(modelId) {
    if (providerInstances.has(modelId)) {
      return providerInstances.get(modelId);
    }
    const providerType = getProviderFromModel(modelId);
    let provider;
    switch (providerType) {
      case "gemini":
        provider = new GeminiProvider();
        break;
      case "claude":
        provider = new ClaudeProvider();
        break;
      case "openai":
        throw new Error("OpenAI Provider는 아직 구현되지 않았습니다.");
      default:
        throw new Error(`알 수 없는 Provider 타입: ${providerType}`);
    }
    providerInstances.set(modelId, provider);
    return provider;
  }
  const STORAGE_KEY = "temper-vv-settings";
  function getGM_setValue() {
    if (window.parentGM_setValue) {
      return window.parentGM_setValue;
    }
    try {
      const { GM_setValue: GM_setValue2 } = require("$");
      return GM_setValue2;
    } catch {
      console.warn("[Settings] GM_setValue 없음, localStorage 사용");
      return null;
    }
  }
  function getGM_getValue() {
    if (window.parentGM_getValue) {
      return window.parentGM_getValue;
    }
    try {
      const { GM_getValue: GM_getValue2 } = require("$");
      return GM_getValue2;
    } catch {
      console.warn("[Settings] GM_getValue 없음, localStorage 사용");
      return null;
    }
  }
  const useSettingsStore = defineStore("settings", () => {
    const aiApiKeys = vue.ref({
      gemini: "",
      claude: "",
      openai: ""
    });
    const selectedAiModel = vue.ref(DEFAULT_AI_MODEL);
    const voicevoxServerUrl = vue.ref("http://localhost:50021");
    const selectedSpeakerId = vue.ref(1);
    const useYomiConversion = vue.ref(false);
    const subtitleFormat = vue.ref("both");
    const ttsSpeed = vue.ref(1);
    const audioOutputFormat = vue.ref("merged");
    const mergedAudioGap = vue.ref(0);
    const yomiChunkSize = vue.ref(50);
    const speakers = vue.ref([]);
    const geminiApiKey = vue.computed({
      get: () => aiApiKeys.value.gemini,
      set: (value) => {
        aiApiKeys.value.gemini = value;
      }
    });
    async function loadFromStorage() {
      try {
        const GM_getValue_fn = getGM_getValue();
        let stored = null;
        if (GM_getValue_fn) {
          console.log("[Settings] GM_getValue로 로드 시도");
          stored = await GM_getValue_fn(STORAGE_KEY, null);
        } else {
          console.log("[Settings] localStorage로 로드 시도");
          stored = localStorage.getItem(STORAGE_KEY);
        }
        if (stored) {
          const settings = JSON.parse(stored);
          if (settings.geminiApiKey && !settings.aiApiKeys) {
            console.log("[Settings] 🔄 기존 geminiApiKey를 aiApiKeys.gemini로 마이그레이션합니다.");
            aiApiKeys.value.gemini = settings.geminiApiKey;
            selectedAiModel.value = DEFAULT_AI_MODEL;
            await saveToStorage();
          } else {
            aiApiKeys.value = settings.aiApiKeys || { gemini: "", claude: "", openai: "" };
            let modelId = settings.selectedAiModel || DEFAULT_AI_MODEL;
            const oldToNewModelMap = {
              "claude-sonnet-4-5": "claude-sonnet-4-5-20250929",
              "claude-haiku-4-5": "claude-haiku-4-5-20251001"
            };
            if (oldToNewModelMap[modelId]) {
              console.log(`[Settings] 🔄 모델 ID 자동 마이그레이션: ${modelId} → ${oldToNewModelMap[modelId]}`);
              modelId = oldToNewModelMap[modelId];
              selectedAiModel.value = modelId;
              setTimeout(() => saveToStorage(), 100);
            } else {
              selectedAiModel.value = modelId;
            }
          }
          voicevoxServerUrl.value = settings.voicevoxServerUrl || "http://localhost:50021";
          selectedSpeakerId.value = settings.selectedSpeakerId || 1;
          useYomiConversion.value = settings.useYomiConversion ?? false;
          subtitleFormat.value = settings.subtitleFormat || "both";
          ttsSpeed.value = settings.ttsSpeed ?? 1;
          audioOutputFormat.value = settings.audioOutputFormat || "merged";
          mergedAudioGap.value = settings.mergedAudioGap ?? 0;
          yomiChunkSize.value = settings.yomiChunkSize ?? 50;
          console.log("✅ 설정을 스토리지에서 불러왔습니다:", settings);
        } else {
          console.log("ℹ️ 저장된 설정이 없습니다. 기본값 사용");
        }
      } catch (error) {
        console.error("❌ 스토리지 로드 실패:", error);
      }
    }
    async function saveToStorage() {
      try {
        const settings = {
          aiApiKeys: aiApiKeys.value,
          selectedAiModel: selectedAiModel.value,
          voicevoxServerUrl: voicevoxServerUrl.value,
          selectedSpeakerId: selectedSpeakerId.value,
          useYomiConversion: useYomiConversion.value,
          subtitleFormat: subtitleFormat.value,
          ttsSpeed: ttsSpeed.value,
          audioOutputFormat: audioOutputFormat.value,
          mergedAudioGap: mergedAudioGap.value,
          yomiChunkSize: yomiChunkSize.value
        };
        const settingsJson = JSON.stringify(settings);
        const GM_setValue_fn = getGM_setValue();
        if (GM_setValue_fn) {
          console.log("[Settings] GM_setValue로 저장:", settingsJson);
          await GM_setValue_fn(STORAGE_KEY, settingsJson);
          console.log("✅ GM storage에 저장 완료");
        } else {
          console.log("[Settings] localStorage로 저장:", settingsJson);
          localStorage.setItem(STORAGE_KEY, settingsJson);
          console.log("✅ localStorage에 저장 완료");
        }
      } catch (error) {
        console.error("❌ 스토리지 저장 실패:", error);
      }
    }
    vue.watch([aiApiKeys, selectedAiModel, voicevoxServerUrl, selectedSpeakerId, useYomiConversion, subtitleFormat, ttsSpeed, audioOutputFormat, mergedAudioGap, yomiChunkSize], () => {
      console.log("[Settings Store] 값 변경 감지, 저장 중...");
      saveToStorage();
    }, { deep: true });
    function updateVoicevoxServerUrl(url) {
      voicevoxServerUrl.value = url;
    }
    function updateSelectedSpeakerId(id) {
      selectedSpeakerId.value = id;
    }
    async function fetchSpeakers$1() {
      try {
        const fetchedSpeakers = await fetchSpeakers(voicevoxServerUrl.value);
        speakers.value = fetchedSpeakers;
        console.log(`✅ ${fetchedSpeakers.length}개의 음성을 불러왔습니다`);
        return true;
      } catch (error) {
        console.error("❌ 음성 목록 로드 실패:", error);
        speakers.value = [];
        return false;
      }
    }
    function updateUseYomiConversion(value) {
      useYomiConversion.value = value;
    }
    function updateSubtitleFormat(format) {
      subtitleFormat.value = format;
    }
    function resetSettings() {
      aiApiKeys.value = { gemini: "", claude: "", openai: "" };
      selectedAiModel.value = DEFAULT_AI_MODEL;
      voicevoxServerUrl.value = "http://localhost:50021";
      selectedSpeakerId.value = 1;
      useYomiConversion.value = false;
      subtitleFormat.value = "both";
      ttsSpeed.value = 1;
      audioOutputFormat.value = "merged";
      mergedAudioGap.value = 0;
      yomiChunkSize.value = 50;
    }
    loadFromStorage();
    return {
geminiApiKey,
      aiApiKeys,
      selectedAiModel,
      voicevoxServerUrl,
      selectedSpeakerId,
      useYomiConversion,
      subtitleFormat,
      ttsSpeed,
      audioOutputFormat,
      mergedAudioGap,
      yomiChunkSize,
      speakers,
updateVoicevoxServerUrl,
      updateSelectedSpeakerId,
      updateUseYomiConversion,
      updateSubtitleFormat,
      fetchSpeakers: fetchSpeakers$1,
      resetSettings,
      loadFromStorage,
      saveToStorage
    };
  });
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
  }
  var FileSaver_min$1 = { exports: {} };
  var FileSaver_min = FileSaver_min$1.exports;
  var hasRequiredFileSaver_min;
  function requireFileSaver_min() {
    if (hasRequiredFileSaver_min) return FileSaver_min$1.exports;
    hasRequiredFileSaver_min = 1;
    (function(module, exports) {
      (function(a, b) {
        b();
      })(FileSaver_min, function() {
        function b(a2, b2) {
          return "undefined" == typeof b2 ? b2 = { autoBom: false } : "object" != typeof b2 && (console.warn("Deprecated: Expected third argument to be a object"), b2 = { autoBom: !b2 }), b2.autoBom && /^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(a2.type) ? new Blob(["\uFEFF", a2], { type: a2.type }) : a2;
        }
        function c(a2, b2, c2) {
          var d2 = new XMLHttpRequest();
          d2.open("GET", a2), d2.responseType = "blob", d2.onload = function() {
            g(d2.response, b2, c2);
          }, d2.onerror = function() {
            console.error("could not download file");
          }, d2.send();
        }
        function d(a2) {
          var b2 = new XMLHttpRequest();
          b2.open("HEAD", a2, false);
          try {
            b2.send();
          } catch (a3) {
          }
          return 200 <= b2.status && 299 >= b2.status;
        }
        function e(a2) {
          try {
            a2.dispatchEvent(new MouseEvent("click"));
          } catch (c2) {
            var b2 = document.createEvent("MouseEvents");
            b2.initMouseEvent("click", true, true, window, 0, 0, 0, 80, 20, false, false, false, false, 0, null), a2.dispatchEvent(b2);
          }
        }
        var f = "object" == typeof window && window.window === window ? window : "object" == typeof self && self.self === self ? self : "object" == typeof commonjsGlobal && commonjsGlobal.global === commonjsGlobal ? commonjsGlobal : void 0, a = f.navigator && /Macintosh/.test(navigator.userAgent) && /AppleWebKit/.test(navigator.userAgent) && !/Safari/.test(navigator.userAgent), g = f.saveAs || ("object" != typeof window || window !== f ? function() {
        } : "download" in HTMLAnchorElement.prototype && !a ? function(b2, g2, h2) {
          var i = f.URL || f.webkitURL, j = document.createElement("a");
          g2 = g2 || b2.name || "download", j.download = g2, j.rel = "noopener", "string" == typeof b2 ? (j.href = b2, j.origin === location.origin ? e(j) : d(j.href) ? c(b2, g2, h2) : e(j, j.target = "_blank")) : (j.href = i.createObjectURL(b2), setTimeout(function() {
            i.revokeObjectURL(j.href);
          }, 4e4), setTimeout(function() {
            e(j);
          }, 0));
        } : "msSaveOrOpenBlob" in navigator ? function(f2, g2, h2) {
          if (g2 = g2 || f2.name || "download", "string" != typeof f2) navigator.msSaveOrOpenBlob(b(f2, h2), g2);
          else if (d(f2)) c(f2, g2, h2);
          else {
            var i = document.createElement("a");
            i.href = f2, i.target = "_blank", setTimeout(function() {
              e(i);
            });
          }
        } : function(b2, d2, e2, g2) {
          if (g2 = g2 || open("", "_blank"), g2 && (g2.document.title = g2.document.body.innerText = "downloading..."), "string" == typeof b2) return c(b2, d2, e2);
          var h2 = "application/octet-stream" === b2.type, i = /constructor/i.test(f.HTMLElement) || f.safari, j = /CriOS\/[\d]+/.test(navigator.userAgent);
          if ((j || h2 && i || a) && "undefined" != typeof FileReader) {
            var k = new FileReader();
            k.onloadend = function() {
              var a2 = k.result;
              a2 = j ? a2 : a2.replace(/^data:[^;]*;/, "data:attachment/file;"), g2 ? g2.location.href = a2 : location = a2, g2 = null;
            }, k.readAsDataURL(b2);
          } else {
            var l = f.URL || f.webkitURL, m = l.createObjectURL(b2);
            g2 ? g2.location = m : location.href = m, g2 = null, setTimeout(function() {
              l.revokeObjectURL(m);
            }, 4e4);
          }
        });
        f.saveAs = g.saveAs = g, module.exports = g;
      });
    })(FileSaver_min$1);
    return FileSaver_min$1.exports;
  }
  var FileSaver_minExports = requireFileSaver_min();
  function commonjsRequire(path) {
    throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
  }
  var jszip_min = { exports: {} };
var hasRequiredJszip_min;
  function requireJszip_min() {
    if (hasRequiredJszip_min) return jszip_min.exports;
    hasRequiredJszip_min = 1;
    (function(module, exports) {
      !(function(t) {
        module.exports = t();
      })(function() {
        return (function s(a, o, h2) {
          function u(r, t2) {
            if (!o[r]) {
              if (!a[r]) {
                var e = "function" == typeof commonjsRequire && commonjsRequire;
                if (!t2 && e) return e(r, true);
                if (l) return l(r, true);
                var i = new Error("Cannot find module '" + r + "'");
                throw i.code = "MODULE_NOT_FOUND", i;
              }
              var n = o[r] = { exports: {} };
              a[r][0].call(n.exports, function(t3) {
                var e2 = a[r][1][t3];
                return u(e2 || t3);
              }, n, n.exports, s, a, o, h2);
            }
            return o[r].exports;
          }
          for (var l = "function" == typeof commonjsRequire && commonjsRequire, t = 0; t < h2.length; t++) u(h2[t]);
          return u;
        })({ 1: [function(t, e, r) {
          var c = t("./utils"), d = t("./support"), p = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
          r.encode = function(t2) {
            for (var e2, r2, i, n, s, a, o, h2 = [], u = 0, l = t2.length, f = l, d2 = "string" !== c.getTypeOf(t2); u < t2.length; ) f = l - u, i = d2 ? (e2 = t2[u++], r2 = u < l ? t2[u++] : 0, u < l ? t2[u++] : 0) : (e2 = t2.charCodeAt(u++), r2 = u < l ? t2.charCodeAt(u++) : 0, u < l ? t2.charCodeAt(u++) : 0), n = e2 >> 2, s = (3 & e2) << 4 | r2 >> 4, a = 1 < f ? (15 & r2) << 2 | i >> 6 : 64, o = 2 < f ? 63 & i : 64, h2.push(p.charAt(n) + p.charAt(s) + p.charAt(a) + p.charAt(o));
            return h2.join("");
          }, r.decode = function(t2) {
            var e2, r2, i, n, s, a, o = 0, h2 = 0, u = "data:";
            if (t2.substr(0, u.length) === u) throw new Error("Invalid base64 input, it looks like a data url.");
            var l, f = 3 * (t2 = t2.replace(/[^A-Za-z0-9\+\/\=]/g, "")).length / 4;
            if (t2.charAt(t2.length - 1) === p.charAt(64) && f--, t2.charAt(t2.length - 2) === p.charAt(64) && f--, f % 1 != 0) throw new Error("Invalid base64 input, bad content length.");
            for (l = d.uint8array ? new Uint8Array(0 | f) : new Array(0 | f); o < t2.length; ) e2 = p.indexOf(t2.charAt(o++)) << 2 | (n = p.indexOf(t2.charAt(o++))) >> 4, r2 = (15 & n) << 4 | (s = p.indexOf(t2.charAt(o++))) >> 2, i = (3 & s) << 6 | (a = p.indexOf(t2.charAt(o++))), l[h2++] = e2, 64 !== s && (l[h2++] = r2), 64 !== a && (l[h2++] = i);
            return l;
          };
        }, { "./support": 30, "./utils": 32 }], 2: [function(t, e, r) {
          var i = t("./external"), n = t("./stream/DataWorker"), s = t("./stream/Crc32Probe"), a = t("./stream/DataLengthProbe");
          function o(t2, e2, r2, i2, n2) {
            this.compressedSize = t2, this.uncompressedSize = e2, this.crc32 = r2, this.compression = i2, this.compressedContent = n2;
          }
          o.prototype = { getContentWorker: function() {
            var t2 = new n(i.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new a("data_length")), e2 = this;
            return t2.on("end", function() {
              if (this.streamInfo.data_length !== e2.uncompressedSize) throw new Error("Bug : uncompressed data size mismatch");
            }), t2;
          }, getCompressedWorker: function() {
            return new n(i.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize", this.compressedSize).withStreamInfo("uncompressedSize", this.uncompressedSize).withStreamInfo("crc32", this.crc32).withStreamInfo("compression", this.compression);
          } }, o.createWorkerFrom = function(t2, e2, r2) {
            return t2.pipe(new s()).pipe(new a("uncompressedSize")).pipe(e2.compressWorker(r2)).pipe(new a("compressedSize")).withStreamInfo("compression", e2);
          }, e.exports = o;
        }, { "./external": 6, "./stream/Crc32Probe": 25, "./stream/DataLengthProbe": 26, "./stream/DataWorker": 27 }], 3: [function(t, e, r) {
          var i = t("./stream/GenericWorker");
          r.STORE = { magic: "\0\0", compressWorker: function(t2) {
            return new i("STORE compression");
          }, uncompressWorker: function() {
            return new i("STORE decompression");
          } }, r.DEFLATE = t("./flate");
        }, { "./flate": 7, "./stream/GenericWorker": 28 }], 4: [function(t, e, r) {
          var i = t("./utils");
          var o = (function() {
            for (var t2, e2 = [], r2 = 0; r2 < 256; r2++) {
              t2 = r2;
              for (var i2 = 0; i2 < 8; i2++) t2 = 1 & t2 ? 3988292384 ^ t2 >>> 1 : t2 >>> 1;
              e2[r2] = t2;
            }
            return e2;
          })();
          e.exports = function(t2, e2) {
            return void 0 !== t2 && t2.length ? "string" !== i.getTypeOf(t2) ? (function(t3, e3, r2, i2) {
              var n = o, s = i2 + r2;
              t3 ^= -1;
              for (var a = i2; a < s; a++) t3 = t3 >>> 8 ^ n[255 & (t3 ^ e3[a])];
              return -1 ^ t3;
            })(0 | e2, t2, t2.length, 0) : (function(t3, e3, r2, i2) {
              var n = o, s = i2 + r2;
              t3 ^= -1;
              for (var a = i2; a < s; a++) t3 = t3 >>> 8 ^ n[255 & (t3 ^ e3.charCodeAt(a))];
              return -1 ^ t3;
            })(0 | e2, t2, t2.length, 0) : 0;
          };
        }, { "./utils": 32 }], 5: [function(t, e, r) {
          r.base64 = false, r.binary = false, r.dir = false, r.createFolders = true, r.date = null, r.compression = null, r.compressionOptions = null, r.comment = null, r.unixPermissions = null, r.dosPermissions = null;
        }, {}], 6: [function(t, e, r) {
          var i = null;
          i = "undefined" != typeof Promise ? Promise : t("lie"), e.exports = { Promise: i };
        }, { lie: 37 }], 7: [function(t, e, r) {
          var i = "undefined" != typeof Uint8Array && "undefined" != typeof Uint16Array && "undefined" != typeof Uint32Array, n = t("pako"), s = t("./utils"), a = t("./stream/GenericWorker"), o = i ? "uint8array" : "array";
          function h2(t2, e2) {
            a.call(this, "FlateWorker/" + t2), this._pako = null, this._pakoAction = t2, this._pakoOptions = e2, this.meta = {};
          }
          r.magic = "\b\0", s.inherits(h2, a), h2.prototype.processChunk = function(t2) {
            this.meta = t2.meta, null === this._pako && this._createPako(), this._pako.push(s.transformTo(o, t2.data), false);
          }, h2.prototype.flush = function() {
            a.prototype.flush.call(this), null === this._pako && this._createPako(), this._pako.push([], true);
          }, h2.prototype.cleanUp = function() {
            a.prototype.cleanUp.call(this), this._pako = null;
          }, h2.prototype._createPako = function() {
            this._pako = new n[this._pakoAction]({ raw: true, level: this._pakoOptions.level || -1 });
            var e2 = this;
            this._pako.onData = function(t2) {
              e2.push({ data: t2, meta: e2.meta });
            };
          }, r.compressWorker = function(t2) {
            return new h2("Deflate", t2);
          }, r.uncompressWorker = function() {
            return new h2("Inflate", {});
          };
        }, { "./stream/GenericWorker": 28, "./utils": 32, pako: 38 }], 8: [function(t, e, r) {
          function A(t2, e2) {
            var r2, i2 = "";
            for (r2 = 0; r2 < e2; r2++) i2 += String.fromCharCode(255 & t2), t2 >>>= 8;
            return i2;
          }
          function i(t2, e2, r2, i2, n2, s2) {
            var a, o, h2 = t2.file, u = t2.compression, l = s2 !== O.utf8encode, f = I.transformTo("string", s2(h2.name)), d = I.transformTo("string", O.utf8encode(h2.name)), c = h2.comment, p = I.transformTo("string", s2(c)), m = I.transformTo("string", O.utf8encode(c)), _ = d.length !== h2.name.length, g = m.length !== c.length, b = "", v = "", y = "", w = h2.dir, k = h2.date, x = { crc32: 0, compressedSize: 0, uncompressedSize: 0 };
            e2 && !r2 || (x.crc32 = t2.crc32, x.compressedSize = t2.compressedSize, x.uncompressedSize = t2.uncompressedSize);
            var S = 0;
            e2 && (S |= 8), l || !_ && !g || (S |= 2048);
            var z = 0, C = 0;
            w && (z |= 16), "UNIX" === n2 ? (C = 798, z |= (function(t3, e3) {
              var r3 = t3;
              return t3 || (r3 = e3 ? 16893 : 33204), (65535 & r3) << 16;
            })(h2.unixPermissions, w)) : (C = 20, z |= (function(t3) {
              return 63 & (t3 || 0);
            })(h2.dosPermissions)), a = k.getUTCHours(), a <<= 6, a |= k.getUTCMinutes(), a <<= 5, a |= k.getUTCSeconds() / 2, o = k.getUTCFullYear() - 1980, o <<= 4, o |= k.getUTCMonth() + 1, o <<= 5, o |= k.getUTCDate(), _ && (v = A(1, 1) + A(B(f), 4) + d, b += "up" + A(v.length, 2) + v), g && (y = A(1, 1) + A(B(p), 4) + m, b += "uc" + A(y.length, 2) + y);
            var E = "";
            return E += "\n\0", E += A(S, 2), E += u.magic, E += A(a, 2), E += A(o, 2), E += A(x.crc32, 4), E += A(x.compressedSize, 4), E += A(x.uncompressedSize, 4), E += A(f.length, 2), E += A(b.length, 2), { fileRecord: R.LOCAL_FILE_HEADER + E + f + b, dirRecord: R.CENTRAL_FILE_HEADER + A(C, 2) + E + A(p.length, 2) + "\0\0\0\0" + A(z, 4) + A(i2, 4) + f + b + p };
          }
          var I = t("../utils"), n = t("../stream/GenericWorker"), O = t("../utf8"), B = t("../crc32"), R = t("../signature");
          function s(t2, e2, r2, i2) {
            n.call(this, "ZipFileWorker"), this.bytesWritten = 0, this.zipComment = e2, this.zipPlatform = r2, this.encodeFileName = i2, this.streamFiles = t2, this.accumulate = false, this.contentBuffer = [], this.dirRecords = [], this.currentSourceOffset = 0, this.entriesCount = 0, this.currentFile = null, this._sources = [];
          }
          I.inherits(s, n), s.prototype.push = function(t2) {
            var e2 = t2.meta.percent || 0, r2 = this.entriesCount, i2 = this._sources.length;
            this.accumulate ? this.contentBuffer.push(t2) : (this.bytesWritten += t2.data.length, n.prototype.push.call(this, { data: t2.data, meta: { currentFile: this.currentFile, percent: r2 ? (e2 + 100 * (r2 - i2 - 1)) / r2 : 100 } }));
          }, s.prototype.openedSource = function(t2) {
            this.currentSourceOffset = this.bytesWritten, this.currentFile = t2.file.name;
            var e2 = this.streamFiles && !t2.file.dir;
            if (e2) {
              var r2 = i(t2, e2, false, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
              this.push({ data: r2.fileRecord, meta: { percent: 0 } });
            } else this.accumulate = true;
          }, s.prototype.closedSource = function(t2) {
            this.accumulate = false;
            var e2 = this.streamFiles && !t2.file.dir, r2 = i(t2, e2, true, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
            if (this.dirRecords.push(r2.dirRecord), e2) this.push({ data: (function(t3) {
              return R.DATA_DESCRIPTOR + A(t3.crc32, 4) + A(t3.compressedSize, 4) + A(t3.uncompressedSize, 4);
            })(t2), meta: { percent: 100 } });
            else for (this.push({ data: r2.fileRecord, meta: { percent: 0 } }); this.contentBuffer.length; ) this.push(this.contentBuffer.shift());
            this.currentFile = null;
          }, s.prototype.flush = function() {
            for (var t2 = this.bytesWritten, e2 = 0; e2 < this.dirRecords.length; e2++) this.push({ data: this.dirRecords[e2], meta: { percent: 100 } });
            var r2 = this.bytesWritten - t2, i2 = (function(t3, e3, r3, i3, n2) {
              var s2 = I.transformTo("string", n2(i3));
              return R.CENTRAL_DIRECTORY_END + "\0\0\0\0" + A(t3, 2) + A(t3, 2) + A(e3, 4) + A(r3, 4) + A(s2.length, 2) + s2;
            })(this.dirRecords.length, r2, t2, this.zipComment, this.encodeFileName);
            this.push({ data: i2, meta: { percent: 100 } });
          }, s.prototype.prepareNextSource = function() {
            this.previous = this._sources.shift(), this.openedSource(this.previous.streamInfo), this.isPaused ? this.previous.pause() : this.previous.resume();
          }, s.prototype.registerPrevious = function(t2) {
            this._sources.push(t2);
            var e2 = this;
            return t2.on("data", function(t3) {
              e2.processChunk(t3);
            }), t2.on("end", function() {
              e2.closedSource(e2.previous.streamInfo), e2._sources.length ? e2.prepareNextSource() : e2.end();
            }), t2.on("error", function(t3) {
              e2.error(t3);
            }), this;
          }, s.prototype.resume = function() {
            return !!n.prototype.resume.call(this) && (!this.previous && this._sources.length ? (this.prepareNextSource(), true) : this.previous || this._sources.length || this.generatedError ? void 0 : (this.end(), true));
          }, s.prototype.error = function(t2) {
            var e2 = this._sources;
            if (!n.prototype.error.call(this, t2)) return false;
            for (var r2 = 0; r2 < e2.length; r2++) try {
              e2[r2].error(t2);
            } catch (t3) {
            }
            return true;
          }, s.prototype.lock = function() {
            n.prototype.lock.call(this);
            for (var t2 = this._sources, e2 = 0; e2 < t2.length; e2++) t2[e2].lock();
          }, e.exports = s;
        }, { "../crc32": 4, "../signature": 23, "../stream/GenericWorker": 28, "../utf8": 31, "../utils": 32 }], 9: [function(t, e, r) {
          var u = t("../compressions"), i = t("./ZipFileWorker");
          r.generateWorker = function(t2, a, e2) {
            var o = new i(a.streamFiles, e2, a.platform, a.encodeFileName), h2 = 0;
            try {
              t2.forEach(function(t3, e3) {
                h2++;
                var r2 = (function(t4, e4) {
                  var r3 = t4 || e4, i3 = u[r3];
                  if (!i3) throw new Error(r3 + " is not a valid compression method !");
                  return i3;
                })(e3.options.compression, a.compression), i2 = e3.options.compressionOptions || a.compressionOptions || {}, n = e3.dir, s = e3.date;
                e3._compressWorker(r2, i2).withStreamInfo("file", { name: t3, dir: n, date: s, comment: e3.comment || "", unixPermissions: e3.unixPermissions, dosPermissions: e3.dosPermissions }).pipe(o);
              }), o.entriesCount = h2;
            } catch (t3) {
              o.error(t3);
            }
            return o;
          };
        }, { "../compressions": 3, "./ZipFileWorker": 8 }], 10: [function(t, e, r) {
          function i() {
            if (!(this instanceof i)) return new i();
            if (arguments.length) throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
            this.files = Object.create(null), this.comment = null, this.root = "", this.clone = function() {
              var t2 = new i();
              for (var e2 in this) "function" != typeof this[e2] && (t2[e2] = this[e2]);
              return t2;
            };
          }
          (i.prototype = t("./object")).loadAsync = t("./load"), i.support = t("./support"), i.defaults = t("./defaults"), i.version = "3.9.1", i.loadAsync = function(t2, e2) {
            return new i().loadAsync(t2, e2);
          }, i.external = t("./external"), e.exports = i;
        }, { "./defaults": 5, "./external": 6, "./load": 11, "./object": 15, "./support": 30 }], 11: [function(t, e, r) {
          var u = t("./utils"), n = t("./external"), i = t("./utf8"), s = t("./zipEntries"), a = t("./stream/Crc32Probe"), l = t("./nodejsUtils");
          function f(i2) {
            return new n.Promise(function(t2, e2) {
              var r2 = i2.decompressed.getContentWorker().pipe(new a());
              r2.on("error", function(t3) {
                e2(t3);
              }).on("end", function() {
                r2.streamInfo.crc32 !== i2.decompressed.crc32 ? e2(new Error("Corrupted zip : CRC32 mismatch")) : t2();
              }).resume();
            });
          }
          e.exports = function(t2, o) {
            var h2 = this;
            return o = u.extend(o || {}, { base64: false, checkCRC32: false, optimizedBinaryString: false, createFolders: false, decodeFileName: i.utf8decode }), l.isNode && l.isStream(t2) ? n.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")) : u.prepareContent("the loaded zip file", t2, true, o.optimizedBinaryString, o.base64).then(function(t3) {
              var e2 = new s(o);
              return e2.load(t3), e2;
            }).then(function(t3) {
              var e2 = [n.Promise.resolve(t3)], r2 = t3.files;
              if (o.checkCRC32) for (var i2 = 0; i2 < r2.length; i2++) e2.push(f(r2[i2]));
              return n.Promise.all(e2);
            }).then(function(t3) {
              for (var e2 = t3.shift(), r2 = e2.files, i2 = 0; i2 < r2.length; i2++) {
                var n2 = r2[i2], s2 = n2.fileNameStr, a2 = u.resolve(n2.fileNameStr);
                h2.file(a2, n2.decompressed, { binary: true, optimizedBinaryString: true, date: n2.date, dir: n2.dir, comment: n2.fileCommentStr.length ? n2.fileCommentStr : null, unixPermissions: n2.unixPermissions, dosPermissions: n2.dosPermissions, createFolders: o.createFolders }), n2.dir || (h2.file(a2).unsafeOriginalName = s2);
              }
              return e2.zipComment.length && (h2.comment = e2.zipComment), h2;
            });
          };
        }, { "./external": 6, "./nodejsUtils": 14, "./stream/Crc32Probe": 25, "./utf8": 31, "./utils": 32, "./zipEntries": 33 }], 12: [function(t, e, r) {
          var i = t("../utils"), n = t("../stream/GenericWorker");
          function s(t2, e2) {
            n.call(this, "Nodejs stream input adapter for " + t2), this._upstreamEnded = false, this._bindStream(e2);
          }
          i.inherits(s, n), s.prototype._bindStream = function(t2) {
            var e2 = this;
            (this._stream = t2).pause(), t2.on("data", function(t3) {
              e2.push({ data: t3, meta: { percent: 0 } });
            }).on("error", function(t3) {
              e2.isPaused ? this.generatedError = t3 : e2.error(t3);
            }).on("end", function() {
              e2.isPaused ? e2._upstreamEnded = true : e2.end();
            });
          }, s.prototype.pause = function() {
            return !!n.prototype.pause.call(this) && (this._stream.pause(), true);
          }, s.prototype.resume = function() {
            return !!n.prototype.resume.call(this) && (this._upstreamEnded ? this.end() : this._stream.resume(), true);
          }, e.exports = s;
        }, { "../stream/GenericWorker": 28, "../utils": 32 }], 13: [function(t, e, r) {
          var n = t("readable-stream").Readable;
          function i(t2, e2, r2) {
            n.call(this, e2), this._helper = t2;
            var i2 = this;
            t2.on("data", function(t3, e3) {
              i2.push(t3) || i2._helper.pause(), r2 && r2(e3);
            }).on("error", function(t3) {
              i2.emit("error", t3);
            }).on("end", function() {
              i2.push(null);
            });
          }
          t("../utils").inherits(i, n), i.prototype._read = function() {
            this._helper.resume();
          }, e.exports = i;
        }, { "../utils": 32, "readable-stream": 16 }], 14: [function(t, e, r) {
          e.exports = { isNode: "undefined" != typeof Buffer, newBufferFrom: function(t2, e2) {
            if (Buffer.from && Buffer.from !== Uint8Array.from) return Buffer.from(t2, e2);
            if ("number" == typeof t2) throw new Error('The "data" argument must not be a number');
            return new Buffer(t2, e2);
          }, allocBuffer: function(t2) {
            if (Buffer.alloc) return Buffer.alloc(t2);
            var e2 = new Buffer(t2);
            return e2.fill(0), e2;
          }, isBuffer: function(t2) {
            return Buffer.isBuffer(t2);
          }, isStream: function(t2) {
            return t2 && "function" == typeof t2.on && "function" == typeof t2.pause && "function" == typeof t2.resume;
          } };
        }, {}], 15: [function(t, e, r) {
          function s(t2, e2, r2) {
            var i2, n2 = u.getTypeOf(e2), s2 = u.extend(r2 || {}, f);
            s2.date = s2.date || new Date(), null !== s2.compression && (s2.compression = s2.compression.toUpperCase()), "string" == typeof s2.unixPermissions && (s2.unixPermissions = parseInt(s2.unixPermissions, 8)), s2.unixPermissions && 16384 & s2.unixPermissions && (s2.dir = true), s2.dosPermissions && 16 & s2.dosPermissions && (s2.dir = true), s2.dir && (t2 = g(t2)), s2.createFolders && (i2 = _(t2)) && b.call(this, i2, true);
            var a2 = "string" === n2 && false === s2.binary && false === s2.base64;
            r2 && void 0 !== r2.binary || (s2.binary = !a2), (e2 instanceof d && 0 === e2.uncompressedSize || s2.dir || !e2 || 0 === e2.length) && (s2.base64 = false, s2.binary = true, e2 = "", s2.compression = "STORE", n2 = "string");
            var o2 = null;
            o2 = e2 instanceof d || e2 instanceof l ? e2 : p.isNode && p.isStream(e2) ? new m(t2, e2) : u.prepareContent(t2, e2, s2.binary, s2.optimizedBinaryString, s2.base64);
            var h3 = new c(t2, o2, s2);
            this.files[t2] = h3;
          }
          var n = t("./utf8"), u = t("./utils"), l = t("./stream/GenericWorker"), a = t("./stream/StreamHelper"), f = t("./defaults"), d = t("./compressedObject"), c = t("./zipObject"), o = t("./generate"), p = t("./nodejsUtils"), m = t("./nodejs/NodejsStreamInputAdapter"), _ = function(t2) {
            "/" === t2.slice(-1) && (t2 = t2.substring(0, t2.length - 1));
            var e2 = t2.lastIndexOf("/");
            return 0 < e2 ? t2.substring(0, e2) : "";
          }, g = function(t2) {
            return "/" !== t2.slice(-1) && (t2 += "/"), t2;
          }, b = function(t2, e2) {
            return e2 = void 0 !== e2 ? e2 : f.createFolders, t2 = g(t2), this.files[t2] || s.call(this, t2, null, { dir: true, createFolders: e2 }), this.files[t2];
          };
          function h2(t2) {
            return "[object RegExp]" === Object.prototype.toString.call(t2);
          }
          var i = { load: function() {
            throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
          }, forEach: function(t2) {
            var e2, r2, i2;
            for (e2 in this.files) i2 = this.files[e2], (r2 = e2.slice(this.root.length, e2.length)) && e2.slice(0, this.root.length) === this.root && t2(r2, i2);
          }, filter: function(r2) {
            var i2 = [];
            return this.forEach(function(t2, e2) {
              r2(t2, e2) && i2.push(e2);
            }), i2;
          }, file: function(t2, e2, r2) {
            if (1 !== arguments.length) return t2 = this.root + t2, s.call(this, t2, e2, r2), this;
            if (h2(t2)) {
              var i2 = t2;
              return this.filter(function(t3, e3) {
                return !e3.dir && i2.test(t3);
              });
            }
            var n2 = this.files[this.root + t2];
            return n2 && !n2.dir ? n2 : null;
          }, folder: function(r2) {
            if (!r2) return this;
            if (h2(r2)) return this.filter(function(t3, e3) {
              return e3.dir && r2.test(t3);
            });
            var t2 = this.root + r2, e2 = b.call(this, t2), i2 = this.clone();
            return i2.root = e2.name, i2;
          }, remove: function(r2) {
            r2 = this.root + r2;
            var t2 = this.files[r2];
            if (t2 || ("/" !== r2.slice(-1) && (r2 += "/"), t2 = this.files[r2]), t2 && !t2.dir) delete this.files[r2];
            else for (var e2 = this.filter(function(t3, e3) {
              return e3.name.slice(0, r2.length) === r2;
            }), i2 = 0; i2 < e2.length; i2++) delete this.files[e2[i2].name];
            return this;
          }, generate: function(t2) {
            throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
          }, generateInternalStream: function(t2) {
            var e2, r2 = {};
            try {
              if ((r2 = u.extend(t2 || {}, { streamFiles: false, compression: "STORE", compressionOptions: null, type: "", platform: "DOS", comment: null, mimeType: "application/zip", encodeFileName: n.utf8encode })).type = r2.type.toLowerCase(), r2.compression = r2.compression.toUpperCase(), "binarystring" === r2.type && (r2.type = "string"), !r2.type) throw new Error("No output type specified.");
              u.checkSupport(r2.type), "darwin" !== r2.platform && "freebsd" !== r2.platform && "linux" !== r2.platform && "sunos" !== r2.platform || (r2.platform = "UNIX"), "win32" === r2.platform && (r2.platform = "DOS");
              var i2 = r2.comment || this.comment || "";
              e2 = o.generateWorker(this, r2, i2);
            } catch (t3) {
              (e2 = new l("error")).error(t3);
            }
            return new a(e2, r2.type || "string", r2.mimeType);
          }, generateAsync: function(t2, e2) {
            return this.generateInternalStream(t2).accumulate(e2);
          }, generateNodeStream: function(t2, e2) {
            return (t2 = t2 || {}).type || (t2.type = "nodebuffer"), this.generateInternalStream(t2).toNodejsStream(e2);
          } };
          e.exports = i;
        }, { "./compressedObject": 2, "./defaults": 5, "./generate": 9, "./nodejs/NodejsStreamInputAdapter": 12, "./nodejsUtils": 14, "./stream/GenericWorker": 28, "./stream/StreamHelper": 29, "./utf8": 31, "./utils": 32, "./zipObject": 35 }], 16: [function(t, e, r) {
          e.exports = t("stream");
        }, { stream: void 0 }], 17: [function(t, e, r) {
          var i = t("./DataReader");
          function n(t2) {
            i.call(this, t2);
            for (var e2 = 0; e2 < this.data.length; e2++) t2[e2] = 255 & t2[e2];
          }
          t("../utils").inherits(n, i), n.prototype.byteAt = function(t2) {
            return this.data[this.zero + t2];
          }, n.prototype.lastIndexOfSignature = function(t2) {
            for (var e2 = t2.charCodeAt(0), r2 = t2.charCodeAt(1), i2 = t2.charCodeAt(2), n2 = t2.charCodeAt(3), s = this.length - 4; 0 <= s; --s) if (this.data[s] === e2 && this.data[s + 1] === r2 && this.data[s + 2] === i2 && this.data[s + 3] === n2) return s - this.zero;
            return -1;
          }, n.prototype.readAndCheckSignature = function(t2) {
            var e2 = t2.charCodeAt(0), r2 = t2.charCodeAt(1), i2 = t2.charCodeAt(2), n2 = t2.charCodeAt(3), s = this.readData(4);
            return e2 === s[0] && r2 === s[1] && i2 === s[2] && n2 === s[3];
          }, n.prototype.readData = function(t2) {
            if (this.checkOffset(t2), 0 === t2) return [];
            var e2 = this.data.slice(this.zero + this.index, this.zero + this.index + t2);
            return this.index += t2, e2;
          }, e.exports = n;
        }, { "../utils": 32, "./DataReader": 18 }], 18: [function(t, e, r) {
          var i = t("../utils");
          function n(t2) {
            this.data = t2, this.length = t2.length, this.index = 0, this.zero = 0;
          }
          n.prototype = { checkOffset: function(t2) {
            this.checkIndex(this.index + t2);
          }, checkIndex: function(t2) {
            if (this.length < this.zero + t2 || t2 < 0) throw new Error("End of data reached (data length = " + this.length + ", asked index = " + t2 + "). Corrupted zip ?");
          }, setIndex: function(t2) {
            this.checkIndex(t2), this.index = t2;
          }, skip: function(t2) {
            this.setIndex(this.index + t2);
          }, byteAt: function(t2) {
          }, readInt: function(t2) {
            var e2, r2 = 0;
            for (this.checkOffset(t2), e2 = this.index + t2 - 1; e2 >= this.index; e2--) r2 = (r2 << 8) + this.byteAt(e2);
            return this.index += t2, r2;
          }, readString: function(t2) {
            return i.transformTo("string", this.readData(t2));
          }, readData: function(t2) {
          }, lastIndexOfSignature: function(t2) {
          }, readAndCheckSignature: function(t2) {
          }, readDate: function() {
            var t2 = this.readInt(4);
            return new Date(Date.UTC(1980 + (t2 >> 25 & 127), (t2 >> 21 & 15) - 1, t2 >> 16 & 31, t2 >> 11 & 31, t2 >> 5 & 63, (31 & t2) << 1));
          } }, e.exports = n;
        }, { "../utils": 32 }], 19: [function(t, e, r) {
          var i = t("./Uint8ArrayReader");
          function n(t2) {
            i.call(this, t2);
          }
          t("../utils").inherits(n, i), n.prototype.readData = function(t2) {
            this.checkOffset(t2);
            var e2 = this.data.slice(this.zero + this.index, this.zero + this.index + t2);
            return this.index += t2, e2;
          }, e.exports = n;
        }, { "../utils": 32, "./Uint8ArrayReader": 21 }], 20: [function(t, e, r) {
          var i = t("./DataReader");
          function n(t2) {
            i.call(this, t2);
          }
          t("../utils").inherits(n, i), n.prototype.byteAt = function(t2) {
            return this.data.charCodeAt(this.zero + t2);
          }, n.prototype.lastIndexOfSignature = function(t2) {
            return this.data.lastIndexOf(t2) - this.zero;
          }, n.prototype.readAndCheckSignature = function(t2) {
            return t2 === this.readData(4);
          }, n.prototype.readData = function(t2) {
            this.checkOffset(t2);
            var e2 = this.data.slice(this.zero + this.index, this.zero + this.index + t2);
            return this.index += t2, e2;
          }, e.exports = n;
        }, { "../utils": 32, "./DataReader": 18 }], 21: [function(t, e, r) {
          var i = t("./ArrayReader");
          function n(t2) {
            i.call(this, t2);
          }
          t("../utils").inherits(n, i), n.prototype.readData = function(t2) {
            if (this.checkOffset(t2), 0 === t2) return new Uint8Array(0);
            var e2 = this.data.subarray(this.zero + this.index, this.zero + this.index + t2);
            return this.index += t2, e2;
          }, e.exports = n;
        }, { "../utils": 32, "./ArrayReader": 17 }], 22: [function(t, e, r) {
          var i = t("../utils"), n = t("../support"), s = t("./ArrayReader"), a = t("./StringReader"), o = t("./NodeBufferReader"), h2 = t("./Uint8ArrayReader");
          e.exports = function(t2) {
            var e2 = i.getTypeOf(t2);
            return i.checkSupport(e2), "string" !== e2 || n.uint8array ? "nodebuffer" === e2 ? new o(t2) : n.uint8array ? new h2(i.transformTo("uint8array", t2)) : new s(i.transformTo("array", t2)) : new a(t2);
          };
        }, { "../support": 30, "../utils": 32, "./ArrayReader": 17, "./NodeBufferReader": 19, "./StringReader": 20, "./Uint8ArrayReader": 21 }], 23: [function(t, e, r) {
          r.LOCAL_FILE_HEADER = "PK", r.CENTRAL_FILE_HEADER = "PK", r.CENTRAL_DIRECTORY_END = "PK", r.ZIP64_CENTRAL_DIRECTORY_LOCATOR = "PK\x07", r.ZIP64_CENTRAL_DIRECTORY_END = "PK", r.DATA_DESCRIPTOR = "PK\x07\b";
        }, {}], 24: [function(t, e, r) {
          var i = t("./GenericWorker"), n = t("../utils");
          function s(t2) {
            i.call(this, "ConvertWorker to " + t2), this.destType = t2;
          }
          n.inherits(s, i), s.prototype.processChunk = function(t2) {
            this.push({ data: n.transformTo(this.destType, t2.data), meta: t2.meta });
          }, e.exports = s;
        }, { "../utils": 32, "./GenericWorker": 28 }], 25: [function(t, e, r) {
          var i = t("./GenericWorker"), n = t("../crc32");
          function s() {
            i.call(this, "Crc32Probe"), this.withStreamInfo("crc32", 0);
          }
          t("../utils").inherits(s, i), s.prototype.processChunk = function(t2) {
            this.streamInfo.crc32 = n(t2.data, this.streamInfo.crc32 || 0), this.push(t2);
          }, e.exports = s;
        }, { "../crc32": 4, "../utils": 32, "./GenericWorker": 28 }], 26: [function(t, e, r) {
          var i = t("../utils"), n = t("./GenericWorker");
          function s(t2) {
            n.call(this, "DataLengthProbe for " + t2), this.propName = t2, this.withStreamInfo(t2, 0);
          }
          i.inherits(s, n), s.prototype.processChunk = function(t2) {
            if (t2) {
              var e2 = this.streamInfo[this.propName] || 0;
              this.streamInfo[this.propName] = e2 + t2.data.length;
            }
            n.prototype.processChunk.call(this, t2);
          }, e.exports = s;
        }, { "../utils": 32, "./GenericWorker": 28 }], 27: [function(t, e, r) {
          var i = t("../utils"), n = t("./GenericWorker");
          function s(t2) {
            n.call(this, "DataWorker");
            var e2 = this;
            this.dataIsReady = false, this.index = 0, this.max = 0, this.data = null, this.type = "", this._tickScheduled = false, t2.then(function(t3) {
              e2.dataIsReady = true, e2.data = t3, e2.max = t3 && t3.length || 0, e2.type = i.getTypeOf(t3), e2.isPaused || e2._tickAndRepeat();
            }, function(t3) {
              e2.error(t3);
            });
          }
          i.inherits(s, n), s.prototype.cleanUp = function() {
            n.prototype.cleanUp.call(this), this.data = null;
          }, s.prototype.resume = function() {
            return !!n.prototype.resume.call(this) && (!this._tickScheduled && this.dataIsReady && (this._tickScheduled = true, i.delay(this._tickAndRepeat, [], this)), true);
          }, s.prototype._tickAndRepeat = function() {
            this._tickScheduled = false, this.isPaused || this.isFinished || (this._tick(), this.isFinished || (i.delay(this._tickAndRepeat, [], this), this._tickScheduled = true));
          }, s.prototype._tick = function() {
            if (this.isPaused || this.isFinished) return false;
            var t2 = null, e2 = Math.min(this.max, this.index + 16384);
            if (this.index >= this.max) return this.end();
            switch (this.type) {
              case "string":
                t2 = this.data.substring(this.index, e2);
                break;
              case "uint8array":
                t2 = this.data.subarray(this.index, e2);
                break;
              case "array":
              case "nodebuffer":
                t2 = this.data.slice(this.index, e2);
            }
            return this.index = e2, this.push({ data: t2, meta: { percent: this.max ? this.index / this.max * 100 : 0 } });
          }, e.exports = s;
        }, { "../utils": 32, "./GenericWorker": 28 }], 28: [function(t, e, r) {
          function i(t2) {
            this.name = t2 || "default", this.streamInfo = {}, this.generatedError = null, this.extraStreamInfo = {}, this.isPaused = true, this.isFinished = false, this.isLocked = false, this._listeners = { data: [], end: [], error: [] }, this.previous = null;
          }
          i.prototype = { push: function(t2) {
            this.emit("data", t2);
          }, end: function() {
            if (this.isFinished) return false;
            this.flush();
            try {
              this.emit("end"), this.cleanUp(), this.isFinished = true;
            } catch (t2) {
              this.emit("error", t2);
            }
            return true;
          }, error: function(t2) {
            return !this.isFinished && (this.isPaused ? this.generatedError = t2 : (this.isFinished = true, this.emit("error", t2), this.previous && this.previous.error(t2), this.cleanUp()), true);
          }, on: function(t2, e2) {
            return this._listeners[t2].push(e2), this;
          }, cleanUp: function() {
            this.streamInfo = this.generatedError = this.extraStreamInfo = null, this._listeners = [];
          }, emit: function(t2, e2) {
            if (this._listeners[t2]) for (var r2 = 0; r2 < this._listeners[t2].length; r2++) this._listeners[t2][r2].call(this, e2);
          }, pipe: function(t2) {
            return t2.registerPrevious(this);
          }, registerPrevious: function(t2) {
            if (this.isLocked) throw new Error("The stream '" + this + "' has already been used.");
            this.streamInfo = t2.streamInfo, this.mergeStreamInfo(), this.previous = t2;
            var e2 = this;
            return t2.on("data", function(t3) {
              e2.processChunk(t3);
            }), t2.on("end", function() {
              e2.end();
            }), t2.on("error", function(t3) {
              e2.error(t3);
            }), this;
          }, pause: function() {
            return !this.isPaused && !this.isFinished && (this.isPaused = true, this.previous && this.previous.pause(), true);
          }, resume: function() {
            if (!this.isPaused || this.isFinished) return false;
            var t2 = this.isPaused = false;
            return this.generatedError && (this.error(this.generatedError), t2 = true), this.previous && this.previous.resume(), !t2;
          }, flush: function() {
          }, processChunk: function(t2) {
            this.push(t2);
          }, withStreamInfo: function(t2, e2) {
            return this.extraStreamInfo[t2] = e2, this.mergeStreamInfo(), this;
          }, mergeStreamInfo: function() {
            for (var t2 in this.extraStreamInfo) this.extraStreamInfo.hasOwnProperty(t2) && (this.streamInfo[t2] = this.extraStreamInfo[t2]);
          }, lock: function() {
            if (this.isLocked) throw new Error("The stream '" + this + "' has already been used.");
            this.isLocked = true, this.previous && this.previous.lock();
          }, toString: function() {
            var t2 = "Worker " + this.name;
            return this.previous ? this.previous + " -> " + t2 : t2;
          } }, e.exports = i;
        }, {}], 29: [function(t, e, r) {
          var h2 = t("../utils"), n = t("./ConvertWorker"), s = t("./GenericWorker"), u = t("../base64"), i = t("../support"), a = t("../external"), o = null;
          if (i.nodestream) try {
            o = t("../nodejs/NodejsStreamOutputAdapter");
          } catch (t2) {
          }
          function l(t2, o2) {
            return new a.Promise(function(e2, r2) {
              var i2 = [], n2 = t2._internalType, s2 = t2._outputType, a2 = t2._mimeType;
              t2.on("data", function(t3, e3) {
                i2.push(t3), o2 && o2(e3);
              }).on("error", function(t3) {
                i2 = [], r2(t3);
              }).on("end", function() {
                try {
                  var t3 = (function(t4, e3, r3) {
                    switch (t4) {
                      case "blob":
                        return h2.newBlob(h2.transformTo("arraybuffer", e3), r3);
                      case "base64":
                        return u.encode(e3);
                      default:
                        return h2.transformTo(t4, e3);
                    }
                  })(s2, (function(t4, e3) {
                    var r3, i3 = 0, n3 = null, s3 = 0;
                    for (r3 = 0; r3 < e3.length; r3++) s3 += e3[r3].length;
                    switch (t4) {
                      case "string":
                        return e3.join("");
                      case "array":
                        return Array.prototype.concat.apply([], e3);
                      case "uint8array":
                        for (n3 = new Uint8Array(s3), r3 = 0; r3 < e3.length; r3++) n3.set(e3[r3], i3), i3 += e3[r3].length;
                        return n3;
                      case "nodebuffer":
                        return Buffer.concat(e3);
                      default:
                        throw new Error("concat : unsupported type '" + t4 + "'");
                    }
                  })(n2, i2), a2);
                  e2(t3);
                } catch (t4) {
                  r2(t4);
                }
                i2 = [];
              }).resume();
            });
          }
          function f(t2, e2, r2) {
            var i2 = e2;
            switch (e2) {
              case "blob":
              case "arraybuffer":
                i2 = "uint8array";
                break;
              case "base64":
                i2 = "string";
            }
            try {
              this._internalType = i2, this._outputType = e2, this._mimeType = r2, h2.checkSupport(i2), this._worker = t2.pipe(new n(i2)), t2.lock();
            } catch (t3) {
              this._worker = new s("error"), this._worker.error(t3);
            }
          }
          f.prototype = { accumulate: function(t2) {
            return l(this, t2);
          }, on: function(t2, e2) {
            var r2 = this;
            return "data" === t2 ? this._worker.on(t2, function(t3) {
              e2.call(r2, t3.data, t3.meta);
            }) : this._worker.on(t2, function() {
              h2.delay(e2, arguments, r2);
            }), this;
          }, resume: function() {
            return h2.delay(this._worker.resume, [], this._worker), this;
          }, pause: function() {
            return this._worker.pause(), this;
          }, toNodejsStream: function(t2) {
            if (h2.checkSupport("nodestream"), "nodebuffer" !== this._outputType) throw new Error(this._outputType + " is not supported by this method");
            return new o(this, { objectMode: "nodebuffer" !== this._outputType }, t2);
          } }, e.exports = f;
        }, { "../base64": 1, "../external": 6, "../nodejs/NodejsStreamOutputAdapter": 13, "../support": 30, "../utils": 32, "./ConvertWorker": 24, "./GenericWorker": 28 }], 30: [function(t, e, r) {
          if (r.base64 = true, r.array = true, r.string = true, r.arraybuffer = "undefined" != typeof ArrayBuffer && "undefined" != typeof Uint8Array, r.nodebuffer = "undefined" != typeof Buffer, r.uint8array = "undefined" != typeof Uint8Array, "undefined" == typeof ArrayBuffer) r.blob = false;
          else {
            var i = new ArrayBuffer(0);
            try {
              r.blob = 0 === new Blob([i], { type: "application/zip" }).size;
            } catch (t2) {
              try {
                var n = new (self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder)();
                n.append(i), r.blob = 0 === n.getBlob("application/zip").size;
              } catch (t3) {
                r.blob = false;
              }
            }
          }
          try {
            r.nodestream = !!t("readable-stream").Readable;
          } catch (t2) {
            r.nodestream = false;
          }
        }, { "readable-stream": 16 }], 31: [function(t, e, s) {
          for (var o = t("./utils"), h2 = t("./support"), r = t("./nodejsUtils"), i = t("./stream/GenericWorker"), u = new Array(256), n = 0; n < 256; n++) u[n] = 252 <= n ? 6 : 248 <= n ? 5 : 240 <= n ? 4 : 224 <= n ? 3 : 192 <= n ? 2 : 1;
          u[254] = u[254] = 1;
          function a() {
            i.call(this, "utf-8 decode"), this.leftOver = null;
          }
          function l() {
            i.call(this, "utf-8 encode");
          }
          s.utf8encode = function(t2) {
            return h2.nodebuffer ? r.newBufferFrom(t2, "utf-8") : (function(t3) {
              var e2, r2, i2, n2, s2, a2 = t3.length, o2 = 0;
              for (n2 = 0; n2 < a2; n2++) 55296 == (64512 & (r2 = t3.charCodeAt(n2))) && n2 + 1 < a2 && 56320 == (64512 & (i2 = t3.charCodeAt(n2 + 1))) && (r2 = 65536 + (r2 - 55296 << 10) + (i2 - 56320), n2++), o2 += r2 < 128 ? 1 : r2 < 2048 ? 2 : r2 < 65536 ? 3 : 4;
              for (e2 = h2.uint8array ? new Uint8Array(o2) : new Array(o2), n2 = s2 = 0; s2 < o2; n2++) 55296 == (64512 & (r2 = t3.charCodeAt(n2))) && n2 + 1 < a2 && 56320 == (64512 & (i2 = t3.charCodeAt(n2 + 1))) && (r2 = 65536 + (r2 - 55296 << 10) + (i2 - 56320), n2++), r2 < 128 ? e2[s2++] = r2 : (r2 < 2048 ? e2[s2++] = 192 | r2 >>> 6 : (r2 < 65536 ? e2[s2++] = 224 | r2 >>> 12 : (e2[s2++] = 240 | r2 >>> 18, e2[s2++] = 128 | r2 >>> 12 & 63), e2[s2++] = 128 | r2 >>> 6 & 63), e2[s2++] = 128 | 63 & r2);
              return e2;
            })(t2);
          }, s.utf8decode = function(t2) {
            return h2.nodebuffer ? o.transformTo("nodebuffer", t2).toString("utf-8") : (function(t3) {
              var e2, r2, i2, n2, s2 = t3.length, a2 = new Array(2 * s2);
              for (e2 = r2 = 0; e2 < s2; ) if ((i2 = t3[e2++]) < 128) a2[r2++] = i2;
              else if (4 < (n2 = u[i2])) a2[r2++] = 65533, e2 += n2 - 1;
              else {
                for (i2 &= 2 === n2 ? 31 : 3 === n2 ? 15 : 7; 1 < n2 && e2 < s2; ) i2 = i2 << 6 | 63 & t3[e2++], n2--;
                1 < n2 ? a2[r2++] = 65533 : i2 < 65536 ? a2[r2++] = i2 : (i2 -= 65536, a2[r2++] = 55296 | i2 >> 10 & 1023, a2[r2++] = 56320 | 1023 & i2);
              }
              return a2.length !== r2 && (a2.subarray ? a2 = a2.subarray(0, r2) : a2.length = r2), o.applyFromCharCode(a2);
            })(t2 = o.transformTo(h2.uint8array ? "uint8array" : "array", t2));
          }, o.inherits(a, i), a.prototype.processChunk = function(t2) {
            var e2 = o.transformTo(h2.uint8array ? "uint8array" : "array", t2.data);
            if (this.leftOver && this.leftOver.length) {
              if (h2.uint8array) {
                var r2 = e2;
                (e2 = new Uint8Array(r2.length + this.leftOver.length)).set(this.leftOver, 0), e2.set(r2, this.leftOver.length);
              } else e2 = this.leftOver.concat(e2);
              this.leftOver = null;
            }
            var i2 = (function(t3, e3) {
              var r3;
              for ((e3 = e3 || t3.length) > t3.length && (e3 = t3.length), r3 = e3 - 1; 0 <= r3 && 128 == (192 & t3[r3]); ) r3--;
              return r3 < 0 ? e3 : 0 === r3 ? e3 : r3 + u[t3[r3]] > e3 ? r3 : e3;
            })(e2), n2 = e2;
            i2 !== e2.length && (h2.uint8array ? (n2 = e2.subarray(0, i2), this.leftOver = e2.subarray(i2, e2.length)) : (n2 = e2.slice(0, i2), this.leftOver = e2.slice(i2, e2.length))), this.push({ data: s.utf8decode(n2), meta: t2.meta });
          }, a.prototype.flush = function() {
            this.leftOver && this.leftOver.length && (this.push({ data: s.utf8decode(this.leftOver), meta: {} }), this.leftOver = null);
          }, s.Utf8DecodeWorker = a, o.inherits(l, i), l.prototype.processChunk = function(t2) {
            this.push({ data: s.utf8encode(t2.data), meta: t2.meta });
          }, s.Utf8EncodeWorker = l;
        }, { "./nodejsUtils": 14, "./stream/GenericWorker": 28, "./support": 30, "./utils": 32 }], 32: [function(t, e, a) {
          var o = t("./support"), h2 = t("./base64"), r = t("./nodejsUtils"), i = t("set-immediate-shim"), u = t("./external");
          function n(t2) {
            return t2;
          }
          function l(t2, e2) {
            for (var r2 = 0; r2 < t2.length; ++r2) e2[r2] = 255 & t2.charCodeAt(r2);
            return e2;
          }
          a.newBlob = function(e2, r2) {
            a.checkSupport("blob");
            try {
              return new Blob([e2], { type: r2 });
            } catch (t2) {
              try {
                var i2 = new (self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder)();
                return i2.append(e2), i2.getBlob(r2);
              } catch (t3) {
                throw new Error("Bug : can't construct the Blob.");
              }
            }
          };
          var s = { stringifyByChunk: function(t2, e2, r2) {
            var i2 = [], n2 = 0, s2 = t2.length;
            if (s2 <= r2) return String.fromCharCode.apply(null, t2);
            for (; n2 < s2; ) "array" === e2 || "nodebuffer" === e2 ? i2.push(String.fromCharCode.apply(null, t2.slice(n2, Math.min(n2 + r2, s2)))) : i2.push(String.fromCharCode.apply(null, t2.subarray(n2, Math.min(n2 + r2, s2)))), n2 += r2;
            return i2.join("");
          }, stringifyByChar: function(t2) {
            for (var e2 = "", r2 = 0; r2 < t2.length; r2++) e2 += String.fromCharCode(t2[r2]);
            return e2;
          }, applyCanBeUsed: { uint8array: (function() {
            try {
              return o.uint8array && 1 === String.fromCharCode.apply(null, new Uint8Array(1)).length;
            } catch (t2) {
              return false;
            }
          })(), nodebuffer: (function() {
            try {
              return o.nodebuffer && 1 === String.fromCharCode.apply(null, r.allocBuffer(1)).length;
            } catch (t2) {
              return false;
            }
          })() } };
          function f(t2) {
            var e2 = 65536, r2 = a.getTypeOf(t2), i2 = true;
            if ("uint8array" === r2 ? i2 = s.applyCanBeUsed.uint8array : "nodebuffer" === r2 && (i2 = s.applyCanBeUsed.nodebuffer), i2) for (; 1 < e2; ) try {
              return s.stringifyByChunk(t2, r2, e2);
            } catch (t3) {
              e2 = Math.floor(e2 / 2);
            }
            return s.stringifyByChar(t2);
          }
          function d(t2, e2) {
            for (var r2 = 0; r2 < t2.length; r2++) e2[r2] = t2[r2];
            return e2;
          }
          a.applyFromCharCode = f;
          var c = {};
          c.string = { string: n, array: function(t2) {
            return l(t2, new Array(t2.length));
          }, arraybuffer: function(t2) {
            return c.string.uint8array(t2).buffer;
          }, uint8array: function(t2) {
            return l(t2, new Uint8Array(t2.length));
          }, nodebuffer: function(t2) {
            return l(t2, r.allocBuffer(t2.length));
          } }, c.array = { string: f, array: n, arraybuffer: function(t2) {
            return new Uint8Array(t2).buffer;
          }, uint8array: function(t2) {
            return new Uint8Array(t2);
          }, nodebuffer: function(t2) {
            return r.newBufferFrom(t2);
          } }, c.arraybuffer = { string: function(t2) {
            return f(new Uint8Array(t2));
          }, array: function(t2) {
            return d(new Uint8Array(t2), new Array(t2.byteLength));
          }, arraybuffer: n, uint8array: function(t2) {
            return new Uint8Array(t2);
          }, nodebuffer: function(t2) {
            return r.newBufferFrom(new Uint8Array(t2));
          } }, c.uint8array = { string: f, array: function(t2) {
            return d(t2, new Array(t2.length));
          }, arraybuffer: function(t2) {
            return t2.buffer;
          }, uint8array: n, nodebuffer: function(t2) {
            return r.newBufferFrom(t2);
          } }, c.nodebuffer = { string: f, array: function(t2) {
            return d(t2, new Array(t2.length));
          }, arraybuffer: function(t2) {
            return c.nodebuffer.uint8array(t2).buffer;
          }, uint8array: function(t2) {
            return d(t2, new Uint8Array(t2.length));
          }, nodebuffer: n }, a.transformTo = function(t2, e2) {
            if (e2 = e2 || "", !t2) return e2;
            a.checkSupport(t2);
            var r2 = a.getTypeOf(e2);
            return c[r2][t2](e2);
          }, a.resolve = function(t2) {
            for (var e2 = t2.split("/"), r2 = [], i2 = 0; i2 < e2.length; i2++) {
              var n2 = e2[i2];
              "." === n2 || "" === n2 && 0 !== i2 && i2 !== e2.length - 1 || (".." === n2 ? r2.pop() : r2.push(n2));
            }
            return r2.join("/");
          }, a.getTypeOf = function(t2) {
            return "string" == typeof t2 ? "string" : "[object Array]" === Object.prototype.toString.call(t2) ? "array" : o.nodebuffer && r.isBuffer(t2) ? "nodebuffer" : o.uint8array && t2 instanceof Uint8Array ? "uint8array" : o.arraybuffer && t2 instanceof ArrayBuffer ? "arraybuffer" : void 0;
          }, a.checkSupport = function(t2) {
            if (!o[t2.toLowerCase()]) throw new Error(t2 + " is not supported by this platform");
          }, a.MAX_VALUE_16BITS = 65535, a.MAX_VALUE_32BITS = -1, a.pretty = function(t2) {
            var e2, r2, i2 = "";
            for (r2 = 0; r2 < (t2 || "").length; r2++) i2 += "\\x" + ((e2 = t2.charCodeAt(r2)) < 16 ? "0" : "") + e2.toString(16).toUpperCase();
            return i2;
          }, a.delay = function(t2, e2, r2) {
            i(function() {
              t2.apply(r2 || null, e2 || []);
            });
          }, a.inherits = function(t2, e2) {
            function r2() {
            }
            r2.prototype = e2.prototype, t2.prototype = new r2();
          }, a.extend = function() {
            var t2, e2, r2 = {};
            for (t2 = 0; t2 < arguments.length; t2++) for (e2 in arguments[t2]) arguments[t2].hasOwnProperty(e2) && void 0 === r2[e2] && (r2[e2] = arguments[t2][e2]);
            return r2;
          }, a.prepareContent = function(r2, t2, i2, n2, s2) {
            return u.Promise.resolve(t2).then(function(i3) {
              return o.blob && (i3 instanceof Blob || -1 !== ["[object File]", "[object Blob]"].indexOf(Object.prototype.toString.call(i3))) && "undefined" != typeof FileReader ? new u.Promise(function(e2, r3) {
                var t3 = new FileReader();
                t3.onload = function(t4) {
                  e2(t4.target.result);
                }, t3.onerror = function(t4) {
                  r3(t4.target.error);
                }, t3.readAsArrayBuffer(i3);
              }) : i3;
            }).then(function(t3) {
              var e2 = a.getTypeOf(t3);
              return e2 ? ("arraybuffer" === e2 ? t3 = a.transformTo("uint8array", t3) : "string" === e2 && (s2 ? t3 = h2.decode(t3) : i2 && true !== n2 && (t3 = (function(t4) {
                return l(t4, o.uint8array ? new Uint8Array(t4.length) : new Array(t4.length));
              })(t3))), t3) : u.Promise.reject(new Error("Can't read the data of '" + r2 + "'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"));
            });
          };
        }, { "./base64": 1, "./external": 6, "./nodejsUtils": 14, "./support": 30, "set-immediate-shim": 54 }], 33: [function(t, e, r) {
          var i = t("./reader/readerFor"), n = t("./utils"), s = t("./signature"), a = t("./zipEntry"), o = (t("./utf8"), t("./support"));
          function h2(t2) {
            this.files = [], this.loadOptions = t2;
          }
          h2.prototype = { checkSignature: function(t2) {
            if (!this.reader.readAndCheckSignature(t2)) {
              this.reader.index -= 4;
              var e2 = this.reader.readString(4);
              throw new Error("Corrupted zip or bug: unexpected signature (" + n.pretty(e2) + ", expected " + n.pretty(t2) + ")");
            }
          }, isSignature: function(t2, e2) {
            var r2 = this.reader.index;
            this.reader.setIndex(t2);
            var i2 = this.reader.readString(4) === e2;
            return this.reader.setIndex(r2), i2;
          }, readBlockEndOfCentral: function() {
            this.diskNumber = this.reader.readInt(2), this.diskWithCentralDirStart = this.reader.readInt(2), this.centralDirRecordsOnThisDisk = this.reader.readInt(2), this.centralDirRecords = this.reader.readInt(2), this.centralDirSize = this.reader.readInt(4), this.centralDirOffset = this.reader.readInt(4), this.zipCommentLength = this.reader.readInt(2);
            var t2 = this.reader.readData(this.zipCommentLength), e2 = o.uint8array ? "uint8array" : "array", r2 = n.transformTo(e2, t2);
            this.zipComment = this.loadOptions.decodeFileName(r2);
          }, readBlockZip64EndOfCentral: function() {
            this.zip64EndOfCentralSize = this.reader.readInt(8), this.reader.skip(4), this.diskNumber = this.reader.readInt(4), this.diskWithCentralDirStart = this.reader.readInt(4), this.centralDirRecordsOnThisDisk = this.reader.readInt(8), this.centralDirRecords = this.reader.readInt(8), this.centralDirSize = this.reader.readInt(8), this.centralDirOffset = this.reader.readInt(8), this.zip64ExtensibleData = {};
            for (var t2, e2, r2, i2 = this.zip64EndOfCentralSize - 44; 0 < i2; ) t2 = this.reader.readInt(2), e2 = this.reader.readInt(4), r2 = this.reader.readData(e2), this.zip64ExtensibleData[t2] = { id: t2, length: e2, value: r2 };
          }, readBlockZip64EndOfCentralLocator: function() {
            if (this.diskWithZip64CentralDirStart = this.reader.readInt(4), this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8), this.disksCount = this.reader.readInt(4), 1 < this.disksCount) throw new Error("Multi-volumes zip are not supported");
          }, readLocalFiles: function() {
            var t2, e2;
            for (t2 = 0; t2 < this.files.length; t2++) e2 = this.files[t2], this.reader.setIndex(e2.localHeaderOffset), this.checkSignature(s.LOCAL_FILE_HEADER), e2.readLocalPart(this.reader), e2.handleUTF8(), e2.processAttributes();
          }, readCentralDir: function() {
            var t2;
            for (this.reader.setIndex(this.centralDirOffset); this.reader.readAndCheckSignature(s.CENTRAL_FILE_HEADER); ) (t2 = new a({ zip64: this.zip64 }, this.loadOptions)).readCentralPart(this.reader), this.files.push(t2);
            if (this.centralDirRecords !== this.files.length && 0 !== this.centralDirRecords && 0 === this.files.length) throw new Error("Corrupted zip or bug: expected " + this.centralDirRecords + " records in central dir, got " + this.files.length);
          }, readEndOfCentral: function() {
            var t2 = this.reader.lastIndexOfSignature(s.CENTRAL_DIRECTORY_END);
            if (t2 < 0) throw !this.isSignature(0, s.LOCAL_FILE_HEADER) ? new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html") : new Error("Corrupted zip: can't find end of central directory");
            this.reader.setIndex(t2);
            var e2 = t2;
            if (this.checkSignature(s.CENTRAL_DIRECTORY_END), this.readBlockEndOfCentral(), this.diskNumber === n.MAX_VALUE_16BITS || this.diskWithCentralDirStart === n.MAX_VALUE_16BITS || this.centralDirRecordsOnThisDisk === n.MAX_VALUE_16BITS || this.centralDirRecords === n.MAX_VALUE_16BITS || this.centralDirSize === n.MAX_VALUE_32BITS || this.centralDirOffset === n.MAX_VALUE_32BITS) {
              if (this.zip64 = true, (t2 = this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR)) < 0) throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");
              if (this.reader.setIndex(t2), this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR), this.readBlockZip64EndOfCentralLocator(), !this.isSignature(this.relativeOffsetEndOfZip64CentralDir, s.ZIP64_CENTRAL_DIRECTORY_END) && (this.relativeOffsetEndOfZip64CentralDir = this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_END), this.relativeOffsetEndOfZip64CentralDir < 0)) throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");
              this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir), this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_END), this.readBlockZip64EndOfCentral();
            }
            var r2 = this.centralDirOffset + this.centralDirSize;
            this.zip64 && (r2 += 20, r2 += 12 + this.zip64EndOfCentralSize);
            var i2 = e2 - r2;
            if (0 < i2) this.isSignature(e2, s.CENTRAL_FILE_HEADER) || (this.reader.zero = i2);
            else if (i2 < 0) throw new Error("Corrupted zip: missing " + Math.abs(i2) + " bytes.");
          }, prepareReader: function(t2) {
            this.reader = i(t2);
          }, load: function(t2) {
            this.prepareReader(t2), this.readEndOfCentral(), this.readCentralDir(), this.readLocalFiles();
          } }, e.exports = h2;
        }, { "./reader/readerFor": 22, "./signature": 23, "./support": 30, "./utf8": 31, "./utils": 32, "./zipEntry": 34 }], 34: [function(t, e, r) {
          var i = t("./reader/readerFor"), s = t("./utils"), n = t("./compressedObject"), a = t("./crc32"), o = t("./utf8"), h2 = t("./compressions"), u = t("./support");
          function l(t2, e2) {
            this.options = t2, this.loadOptions = e2;
          }
          l.prototype = { isEncrypted: function() {
            return 1 == (1 & this.bitFlag);
          }, useUTF8: function() {
            return 2048 == (2048 & this.bitFlag);
          }, readLocalPart: function(t2) {
            var e2, r2;
            if (t2.skip(22), this.fileNameLength = t2.readInt(2), r2 = t2.readInt(2), this.fileName = t2.readData(this.fileNameLength), t2.skip(r2), -1 === this.compressedSize || -1 === this.uncompressedSize) throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");
            if (null === (e2 = (function(t3) {
              for (var e3 in h2) if (h2.hasOwnProperty(e3) && h2[e3].magic === t3) return h2[e3];
              return null;
            })(this.compressionMethod))) throw new Error("Corrupted zip : compression " + s.pretty(this.compressionMethod) + " unknown (inner file : " + s.transformTo("string", this.fileName) + ")");
            this.decompressed = new n(this.compressedSize, this.uncompressedSize, this.crc32, e2, t2.readData(this.compressedSize));
          }, readCentralPart: function(t2) {
            this.versionMadeBy = t2.readInt(2), t2.skip(2), this.bitFlag = t2.readInt(2), this.compressionMethod = t2.readString(2), this.date = t2.readDate(), this.crc32 = t2.readInt(4), this.compressedSize = t2.readInt(4), this.uncompressedSize = t2.readInt(4);
            var e2 = t2.readInt(2);
            if (this.extraFieldsLength = t2.readInt(2), this.fileCommentLength = t2.readInt(2), this.diskNumberStart = t2.readInt(2), this.internalFileAttributes = t2.readInt(2), this.externalFileAttributes = t2.readInt(4), this.localHeaderOffset = t2.readInt(4), this.isEncrypted()) throw new Error("Encrypted zip are not supported");
            t2.skip(e2), this.readExtraFields(t2), this.parseZIP64ExtraField(t2), this.fileComment = t2.readData(this.fileCommentLength);
          }, processAttributes: function() {
            this.unixPermissions = null, this.dosPermissions = null;
            var t2 = this.versionMadeBy >> 8;
            this.dir = !!(16 & this.externalFileAttributes), 0 == t2 && (this.dosPermissions = 63 & this.externalFileAttributes), 3 == t2 && (this.unixPermissions = this.externalFileAttributes >> 16 & 65535), this.dir || "/" !== this.fileNameStr.slice(-1) || (this.dir = true);
          }, parseZIP64ExtraField: function(t2) {
            if (this.extraFields[1]) {
              var e2 = i(this.extraFields[1].value);
              this.uncompressedSize === s.MAX_VALUE_32BITS && (this.uncompressedSize = e2.readInt(8)), this.compressedSize === s.MAX_VALUE_32BITS && (this.compressedSize = e2.readInt(8)), this.localHeaderOffset === s.MAX_VALUE_32BITS && (this.localHeaderOffset = e2.readInt(8)), this.diskNumberStart === s.MAX_VALUE_32BITS && (this.diskNumberStart = e2.readInt(4));
            }
          }, readExtraFields: function(t2) {
            var e2, r2, i2, n2 = t2.index + this.extraFieldsLength;
            for (this.extraFields || (this.extraFields = {}); t2.index + 4 < n2; ) e2 = t2.readInt(2), r2 = t2.readInt(2), i2 = t2.readData(r2), this.extraFields[e2] = { id: e2, length: r2, value: i2 };
            t2.setIndex(n2);
          }, handleUTF8: function() {
            var t2 = u.uint8array ? "uint8array" : "array";
            if (this.useUTF8()) this.fileNameStr = o.utf8decode(this.fileName), this.fileCommentStr = o.utf8decode(this.fileComment);
            else {
              var e2 = this.findExtraFieldUnicodePath();
              if (null !== e2) this.fileNameStr = e2;
              else {
                var r2 = s.transformTo(t2, this.fileName);
                this.fileNameStr = this.loadOptions.decodeFileName(r2);
              }
              var i2 = this.findExtraFieldUnicodeComment();
              if (null !== i2) this.fileCommentStr = i2;
              else {
                var n2 = s.transformTo(t2, this.fileComment);
                this.fileCommentStr = this.loadOptions.decodeFileName(n2);
              }
            }
          }, findExtraFieldUnicodePath: function() {
            var t2 = this.extraFields[28789];
            if (t2) {
              var e2 = i(t2.value);
              return 1 !== e2.readInt(1) ? null : a(this.fileName) !== e2.readInt(4) ? null : o.utf8decode(e2.readData(t2.length - 5));
            }
            return null;
          }, findExtraFieldUnicodeComment: function() {
            var t2 = this.extraFields[25461];
            if (t2) {
              var e2 = i(t2.value);
              return 1 !== e2.readInt(1) ? null : a(this.fileComment) !== e2.readInt(4) ? null : o.utf8decode(e2.readData(t2.length - 5));
            }
            return null;
          } }, e.exports = l;
        }, { "./compressedObject": 2, "./compressions": 3, "./crc32": 4, "./reader/readerFor": 22, "./support": 30, "./utf8": 31, "./utils": 32 }], 35: [function(t, e, r) {
          function i(t2, e2, r2) {
            this.name = t2, this.dir = r2.dir, this.date = r2.date, this.comment = r2.comment, this.unixPermissions = r2.unixPermissions, this.dosPermissions = r2.dosPermissions, this._data = e2, this._dataBinary = r2.binary, this.options = { compression: r2.compression, compressionOptions: r2.compressionOptions };
          }
          var s = t("./stream/StreamHelper"), n = t("./stream/DataWorker"), a = t("./utf8"), o = t("./compressedObject"), h2 = t("./stream/GenericWorker");
          i.prototype = { internalStream: function(t2) {
            var e2 = null, r2 = "string";
            try {
              if (!t2) throw new Error("No output type specified.");
              var i2 = "string" === (r2 = t2.toLowerCase()) || "text" === r2;
              "binarystring" !== r2 && "text" !== r2 || (r2 = "string"), e2 = this._decompressWorker();
              var n2 = !this._dataBinary;
              n2 && !i2 && (e2 = e2.pipe(new a.Utf8EncodeWorker())), !n2 && i2 && (e2 = e2.pipe(new a.Utf8DecodeWorker()));
            } catch (t3) {
              (e2 = new h2("error")).error(t3);
            }
            return new s(e2, r2, "");
          }, async: function(t2, e2) {
            return this.internalStream(t2).accumulate(e2);
          }, nodeStream: function(t2, e2) {
            return this.internalStream(t2 || "nodebuffer").toNodejsStream(e2);
          }, _compressWorker: function(t2, e2) {
            if (this._data instanceof o && this._data.compression.magic === t2.magic) return this._data.getCompressedWorker();
            var r2 = this._decompressWorker();
            return this._dataBinary || (r2 = r2.pipe(new a.Utf8EncodeWorker())), o.createWorkerFrom(r2, t2, e2);
          }, _decompressWorker: function() {
            return this._data instanceof o ? this._data.getContentWorker() : this._data instanceof h2 ? this._data : new n(this._data);
          } };
          for (var u = ["asText", "asBinary", "asNodeBuffer", "asUint8Array", "asArrayBuffer"], l = function() {
            throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
          }, f = 0; f < u.length; f++) i.prototype[u[f]] = l;
          e.exports = i;
        }, { "./compressedObject": 2, "./stream/DataWorker": 27, "./stream/GenericWorker": 28, "./stream/StreamHelper": 29, "./utf8": 31 }], 36: [function(t, l, e) {
          (function(e2) {
            var r, i, t2 = e2.MutationObserver || e2.WebKitMutationObserver;
            if (t2) {
              var n = 0, s = new t2(u), a = e2.document.createTextNode("");
              s.observe(a, { characterData: true }), r = function() {
                a.data = n = ++n % 2;
              };
            } else if (e2.setImmediate || void 0 === e2.MessageChannel) r = "document" in e2 && "onreadystatechange" in e2.document.createElement("script") ? function() {
              var t3 = e2.document.createElement("script");
              t3.onreadystatechange = function() {
                u(), t3.onreadystatechange = null, t3.parentNode.removeChild(t3), t3 = null;
              }, e2.document.documentElement.appendChild(t3);
            } : function() {
              setTimeout(u, 0);
            };
            else {
              var o = new e2.MessageChannel();
              o.port1.onmessage = u, r = function() {
                o.port2.postMessage(0);
              };
            }
            var h2 = [];
            function u() {
              var t3, e3;
              i = true;
              for (var r2 = h2.length; r2; ) {
                for (e3 = h2, h2 = [], t3 = -1; ++t3 < r2; ) e3[t3]();
                r2 = h2.length;
              }
              i = false;
            }
            l.exports = function(t3) {
              1 !== h2.push(t3) || i || r();
            };
          }).call(this, "undefined" != typeof commonjsGlobal ? commonjsGlobal : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
        }, {}], 37: [function(t, e, r) {
          var n = t("immediate");
          function u() {
          }
          var l = {}, s = ["REJECTED"], a = ["FULFILLED"], i = ["PENDING"];
          function o(t2) {
            if ("function" != typeof t2) throw new TypeError("resolver must be a function");
            this.state = i, this.queue = [], this.outcome = void 0, t2 !== u && c(this, t2);
          }
          function h2(t2, e2, r2) {
            this.promise = t2, "function" == typeof e2 && (this.onFulfilled = e2, this.callFulfilled = this.otherCallFulfilled), "function" == typeof r2 && (this.onRejected = r2, this.callRejected = this.otherCallRejected);
          }
          function f(e2, r2, i2) {
            n(function() {
              var t2;
              try {
                t2 = r2(i2);
              } catch (t3) {
                return l.reject(e2, t3);
              }
              t2 === e2 ? l.reject(e2, new TypeError("Cannot resolve promise with itself")) : l.resolve(e2, t2);
            });
          }
          function d(t2) {
            var e2 = t2 && t2.then;
            if (t2 && ("object" == typeof t2 || "function" == typeof t2) && "function" == typeof e2) return function() {
              e2.apply(t2, arguments);
            };
          }
          function c(e2, t2) {
            var r2 = false;
            function i2(t3) {
              r2 || (r2 = true, l.reject(e2, t3));
            }
            function n2(t3) {
              r2 || (r2 = true, l.resolve(e2, t3));
            }
            var s2 = p(function() {
              t2(n2, i2);
            });
            "error" === s2.status && i2(s2.value);
          }
          function p(t2, e2) {
            var r2 = {};
            try {
              r2.value = t2(e2), r2.status = "success";
            } catch (t3) {
              r2.status = "error", r2.value = t3;
            }
            return r2;
          }
          (e.exports = o).prototype.finally = function(e2) {
            if ("function" != typeof e2) return this;
            var r2 = this.constructor;
            return this.then(function(t2) {
              return r2.resolve(e2()).then(function() {
                return t2;
              });
            }, function(t2) {
              return r2.resolve(e2()).then(function() {
                throw t2;
              });
            });
          }, o.prototype.catch = function(t2) {
            return this.then(null, t2);
          }, o.prototype.then = function(t2, e2) {
            if ("function" != typeof t2 && this.state === a || "function" != typeof e2 && this.state === s) return this;
            var r2 = new this.constructor(u);
            this.state !== i ? f(r2, this.state === a ? t2 : e2, this.outcome) : this.queue.push(new h2(r2, t2, e2));
            return r2;
          }, h2.prototype.callFulfilled = function(t2) {
            l.resolve(this.promise, t2);
          }, h2.prototype.otherCallFulfilled = function(t2) {
            f(this.promise, this.onFulfilled, t2);
          }, h2.prototype.callRejected = function(t2) {
            l.reject(this.promise, t2);
          }, h2.prototype.otherCallRejected = function(t2) {
            f(this.promise, this.onRejected, t2);
          }, l.resolve = function(t2, e2) {
            var r2 = p(d, e2);
            if ("error" === r2.status) return l.reject(t2, r2.value);
            var i2 = r2.value;
            if (i2) c(t2, i2);
            else {
              t2.state = a, t2.outcome = e2;
              for (var n2 = -1, s2 = t2.queue.length; ++n2 < s2; ) t2.queue[n2].callFulfilled(e2);
            }
            return t2;
          }, l.reject = function(t2, e2) {
            t2.state = s, t2.outcome = e2;
            for (var r2 = -1, i2 = t2.queue.length; ++r2 < i2; ) t2.queue[r2].callRejected(e2);
            return t2;
          }, o.resolve = function(t2) {
            if (t2 instanceof this) return t2;
            return l.resolve(new this(u), t2);
          }, o.reject = function(t2) {
            var e2 = new this(u);
            return l.reject(e2, t2);
          }, o.all = function(t2) {
            var r2 = this;
            if ("[object Array]" !== Object.prototype.toString.call(t2)) return this.reject(new TypeError("must be an array"));
            var i2 = t2.length, n2 = false;
            if (!i2) return this.resolve([]);
            var s2 = new Array(i2), a2 = 0, e2 = -1, o2 = new this(u);
            for (; ++e2 < i2; ) h3(t2[e2], e2);
            return o2;
            function h3(t3, e3) {
              r2.resolve(t3).then(function(t4) {
                s2[e3] = t4, ++a2 !== i2 || n2 || (n2 = true, l.resolve(o2, s2));
              }, function(t4) {
                n2 || (n2 = true, l.reject(o2, t4));
              });
            }
          }, o.race = function(t2) {
            var e2 = this;
            if ("[object Array]" !== Object.prototype.toString.call(t2)) return this.reject(new TypeError("must be an array"));
            var r2 = t2.length, i2 = false;
            if (!r2) return this.resolve([]);
            var n2 = -1, s2 = new this(u);
            for (; ++n2 < r2; ) a2 = t2[n2], e2.resolve(a2).then(function(t3) {
              i2 || (i2 = true, l.resolve(s2, t3));
            }, function(t3) {
              i2 || (i2 = true, l.reject(s2, t3));
            });
            var a2;
            return s2;
          };
        }, { immediate: 36 }], 38: [function(t, e, r) {
          var i = {};
          (0, t("./lib/utils/common").assign)(i, t("./lib/deflate"), t("./lib/inflate"), t("./lib/zlib/constants")), e.exports = i;
        }, { "./lib/deflate": 39, "./lib/inflate": 40, "./lib/utils/common": 41, "./lib/zlib/constants": 44 }], 39: [function(t, e, r) {
          var a = t("./zlib/deflate"), o = t("./utils/common"), h2 = t("./utils/strings"), n = t("./zlib/messages"), s = t("./zlib/zstream"), u = Object.prototype.toString, l = 0, f = -1, d = 0, c = 8;
          function p(t2) {
            if (!(this instanceof p)) return new p(t2);
            this.options = o.assign({ level: f, method: c, chunkSize: 16384, windowBits: 15, memLevel: 8, strategy: d, to: "" }, t2 || {});
            var e2 = this.options;
            e2.raw && 0 < e2.windowBits ? e2.windowBits = -e2.windowBits : e2.gzip && 0 < e2.windowBits && e2.windowBits < 16 && (e2.windowBits += 16), this.err = 0, this.msg = "", this.ended = false, this.chunks = [], this.strm = new s(), this.strm.avail_out = 0;
            var r2 = a.deflateInit2(this.strm, e2.level, e2.method, e2.windowBits, e2.memLevel, e2.strategy);
            if (r2 !== l) throw new Error(n[r2]);
            if (e2.header && a.deflateSetHeader(this.strm, e2.header), e2.dictionary) {
              var i2;
              if (i2 = "string" == typeof e2.dictionary ? h2.string2buf(e2.dictionary) : "[object ArrayBuffer]" === u.call(e2.dictionary) ? new Uint8Array(e2.dictionary) : e2.dictionary, (r2 = a.deflateSetDictionary(this.strm, i2)) !== l) throw new Error(n[r2]);
              this._dict_set = true;
            }
          }
          function i(t2, e2) {
            var r2 = new p(e2);
            if (r2.push(t2, true), r2.err) throw r2.msg || n[r2.err];
            return r2.result;
          }
          p.prototype.push = function(t2, e2) {
            var r2, i2, n2 = this.strm, s2 = this.options.chunkSize;
            if (this.ended) return false;
            i2 = e2 === ~~e2 ? e2 : true === e2 ? 4 : 0, "string" == typeof t2 ? n2.input = h2.string2buf(t2) : "[object ArrayBuffer]" === u.call(t2) ? n2.input = new Uint8Array(t2) : n2.input = t2, n2.next_in = 0, n2.avail_in = n2.input.length;
            do {
              if (0 === n2.avail_out && (n2.output = new o.Buf8(s2), n2.next_out = 0, n2.avail_out = s2), 1 !== (r2 = a.deflate(n2, i2)) && r2 !== l) return this.onEnd(r2), !(this.ended = true);
              0 !== n2.avail_out && (0 !== n2.avail_in || 4 !== i2 && 2 !== i2) || ("string" === this.options.to ? this.onData(h2.buf2binstring(o.shrinkBuf(n2.output, n2.next_out))) : this.onData(o.shrinkBuf(n2.output, n2.next_out)));
            } while ((0 < n2.avail_in || 0 === n2.avail_out) && 1 !== r2);
            return 4 === i2 ? (r2 = a.deflateEnd(this.strm), this.onEnd(r2), this.ended = true, r2 === l) : 2 !== i2 || (this.onEnd(l), !(n2.avail_out = 0));
          }, p.prototype.onData = function(t2) {
            this.chunks.push(t2);
          }, p.prototype.onEnd = function(t2) {
            t2 === l && ("string" === this.options.to ? this.result = this.chunks.join("") : this.result = o.flattenChunks(this.chunks)), this.chunks = [], this.err = t2, this.msg = this.strm.msg;
          }, r.Deflate = p, r.deflate = i, r.deflateRaw = function(t2, e2) {
            return (e2 = e2 || {}).raw = true, i(t2, e2);
          }, r.gzip = function(t2, e2) {
            return (e2 = e2 || {}).gzip = true, i(t2, e2);
          };
        }, { "./utils/common": 41, "./utils/strings": 42, "./zlib/deflate": 46, "./zlib/messages": 51, "./zlib/zstream": 53 }], 40: [function(t, e, r) {
          var d = t("./zlib/inflate"), c = t("./utils/common"), p = t("./utils/strings"), m = t("./zlib/constants"), i = t("./zlib/messages"), n = t("./zlib/zstream"), s = t("./zlib/gzheader"), _ = Object.prototype.toString;
          function a(t2) {
            if (!(this instanceof a)) return new a(t2);
            this.options = c.assign({ chunkSize: 16384, windowBits: 0, to: "" }, t2 || {});
            var e2 = this.options;
            e2.raw && 0 <= e2.windowBits && e2.windowBits < 16 && (e2.windowBits = -e2.windowBits, 0 === e2.windowBits && (e2.windowBits = -15)), !(0 <= e2.windowBits && e2.windowBits < 16) || t2 && t2.windowBits || (e2.windowBits += 32), 15 < e2.windowBits && e2.windowBits < 48 && 0 == (15 & e2.windowBits) && (e2.windowBits |= 15), this.err = 0, this.msg = "", this.ended = false, this.chunks = [], this.strm = new n(), this.strm.avail_out = 0;
            var r2 = d.inflateInit2(this.strm, e2.windowBits);
            if (r2 !== m.Z_OK) throw new Error(i[r2]);
            this.header = new s(), d.inflateGetHeader(this.strm, this.header);
          }
          function o(t2, e2) {
            var r2 = new a(e2);
            if (r2.push(t2, true), r2.err) throw r2.msg || i[r2.err];
            return r2.result;
          }
          a.prototype.push = function(t2, e2) {
            var r2, i2, n2, s2, a2, o2, h2 = this.strm, u = this.options.chunkSize, l = this.options.dictionary, f = false;
            if (this.ended) return false;
            i2 = e2 === ~~e2 ? e2 : true === e2 ? m.Z_FINISH : m.Z_NO_FLUSH, "string" == typeof t2 ? h2.input = p.binstring2buf(t2) : "[object ArrayBuffer]" === _.call(t2) ? h2.input = new Uint8Array(t2) : h2.input = t2, h2.next_in = 0, h2.avail_in = h2.input.length;
            do {
              if (0 === h2.avail_out && (h2.output = new c.Buf8(u), h2.next_out = 0, h2.avail_out = u), (r2 = d.inflate(h2, m.Z_NO_FLUSH)) === m.Z_NEED_DICT && l && (o2 = "string" == typeof l ? p.string2buf(l) : "[object ArrayBuffer]" === _.call(l) ? new Uint8Array(l) : l, r2 = d.inflateSetDictionary(this.strm, o2)), r2 === m.Z_BUF_ERROR && true === f && (r2 = m.Z_OK, f = false), r2 !== m.Z_STREAM_END && r2 !== m.Z_OK) return this.onEnd(r2), !(this.ended = true);
              h2.next_out && (0 !== h2.avail_out && r2 !== m.Z_STREAM_END && (0 !== h2.avail_in || i2 !== m.Z_FINISH && i2 !== m.Z_SYNC_FLUSH) || ("string" === this.options.to ? (n2 = p.utf8border(h2.output, h2.next_out), s2 = h2.next_out - n2, a2 = p.buf2string(h2.output, n2), h2.next_out = s2, h2.avail_out = u - s2, s2 && c.arraySet(h2.output, h2.output, n2, s2, 0), this.onData(a2)) : this.onData(c.shrinkBuf(h2.output, h2.next_out)))), 0 === h2.avail_in && 0 === h2.avail_out && (f = true);
            } while ((0 < h2.avail_in || 0 === h2.avail_out) && r2 !== m.Z_STREAM_END);
            return r2 === m.Z_STREAM_END && (i2 = m.Z_FINISH), i2 === m.Z_FINISH ? (r2 = d.inflateEnd(this.strm), this.onEnd(r2), this.ended = true, r2 === m.Z_OK) : i2 !== m.Z_SYNC_FLUSH || (this.onEnd(m.Z_OK), !(h2.avail_out = 0));
          }, a.prototype.onData = function(t2) {
            this.chunks.push(t2);
          }, a.prototype.onEnd = function(t2) {
            t2 === m.Z_OK && ("string" === this.options.to ? this.result = this.chunks.join("") : this.result = c.flattenChunks(this.chunks)), this.chunks = [], this.err = t2, this.msg = this.strm.msg;
          }, r.Inflate = a, r.inflate = o, r.inflateRaw = function(t2, e2) {
            return (e2 = e2 || {}).raw = true, o(t2, e2);
          }, r.ungzip = o;
        }, { "./utils/common": 41, "./utils/strings": 42, "./zlib/constants": 44, "./zlib/gzheader": 47, "./zlib/inflate": 49, "./zlib/messages": 51, "./zlib/zstream": 53 }], 41: [function(t, e, r) {
          var i = "undefined" != typeof Uint8Array && "undefined" != typeof Uint16Array && "undefined" != typeof Int32Array;
          r.assign = function(t2) {
            for (var e2 = Array.prototype.slice.call(arguments, 1); e2.length; ) {
              var r2 = e2.shift();
              if (r2) {
                if ("object" != typeof r2) throw new TypeError(r2 + "must be non-object");
                for (var i2 in r2) r2.hasOwnProperty(i2) && (t2[i2] = r2[i2]);
              }
            }
            return t2;
          }, r.shrinkBuf = function(t2, e2) {
            return t2.length === e2 ? t2 : t2.subarray ? t2.subarray(0, e2) : (t2.length = e2, t2);
          };
          var n = { arraySet: function(t2, e2, r2, i2, n2) {
            if (e2.subarray && t2.subarray) t2.set(e2.subarray(r2, r2 + i2), n2);
            else for (var s2 = 0; s2 < i2; s2++) t2[n2 + s2] = e2[r2 + s2];
          }, flattenChunks: function(t2) {
            var e2, r2, i2, n2, s2, a;
            for (e2 = i2 = 0, r2 = t2.length; e2 < r2; e2++) i2 += t2[e2].length;
            for (a = new Uint8Array(i2), e2 = n2 = 0, r2 = t2.length; e2 < r2; e2++) s2 = t2[e2], a.set(s2, n2), n2 += s2.length;
            return a;
          } }, s = { arraySet: function(t2, e2, r2, i2, n2) {
            for (var s2 = 0; s2 < i2; s2++) t2[n2 + s2] = e2[r2 + s2];
          }, flattenChunks: function(t2) {
            return [].concat.apply([], t2);
          } };
          r.setTyped = function(t2) {
            t2 ? (r.Buf8 = Uint8Array, r.Buf16 = Uint16Array, r.Buf32 = Int32Array, r.assign(r, n)) : (r.Buf8 = Array, r.Buf16 = Array, r.Buf32 = Array, r.assign(r, s));
          }, r.setTyped(i);
        }, {}], 42: [function(t, e, r) {
          var h2 = t("./common"), n = true, s = true;
          try {
            String.fromCharCode.apply(null, [0]);
          } catch (t2) {
            n = false;
          }
          try {
            String.fromCharCode.apply(null, new Uint8Array(1));
          } catch (t2) {
            s = false;
          }
          for (var u = new h2.Buf8(256), i = 0; i < 256; i++) u[i] = 252 <= i ? 6 : 248 <= i ? 5 : 240 <= i ? 4 : 224 <= i ? 3 : 192 <= i ? 2 : 1;
          function l(t2, e2) {
            if (e2 < 65537 && (t2.subarray && s || !t2.subarray && n)) return String.fromCharCode.apply(null, h2.shrinkBuf(t2, e2));
            for (var r2 = "", i2 = 0; i2 < e2; i2++) r2 += String.fromCharCode(t2[i2]);
            return r2;
          }
          u[254] = u[254] = 1, r.string2buf = function(t2) {
            var e2, r2, i2, n2, s2, a = t2.length, o = 0;
            for (n2 = 0; n2 < a; n2++) 55296 == (64512 & (r2 = t2.charCodeAt(n2))) && n2 + 1 < a && 56320 == (64512 & (i2 = t2.charCodeAt(n2 + 1))) && (r2 = 65536 + (r2 - 55296 << 10) + (i2 - 56320), n2++), o += r2 < 128 ? 1 : r2 < 2048 ? 2 : r2 < 65536 ? 3 : 4;
            for (e2 = new h2.Buf8(o), n2 = s2 = 0; s2 < o; n2++) 55296 == (64512 & (r2 = t2.charCodeAt(n2))) && n2 + 1 < a && 56320 == (64512 & (i2 = t2.charCodeAt(n2 + 1))) && (r2 = 65536 + (r2 - 55296 << 10) + (i2 - 56320), n2++), r2 < 128 ? e2[s2++] = r2 : (r2 < 2048 ? e2[s2++] = 192 | r2 >>> 6 : (r2 < 65536 ? e2[s2++] = 224 | r2 >>> 12 : (e2[s2++] = 240 | r2 >>> 18, e2[s2++] = 128 | r2 >>> 12 & 63), e2[s2++] = 128 | r2 >>> 6 & 63), e2[s2++] = 128 | 63 & r2);
            return e2;
          }, r.buf2binstring = function(t2) {
            return l(t2, t2.length);
          }, r.binstring2buf = function(t2) {
            for (var e2 = new h2.Buf8(t2.length), r2 = 0, i2 = e2.length; r2 < i2; r2++) e2[r2] = t2.charCodeAt(r2);
            return e2;
          }, r.buf2string = function(t2, e2) {
            var r2, i2, n2, s2, a = e2 || t2.length, o = new Array(2 * a);
            for (r2 = i2 = 0; r2 < a; ) if ((n2 = t2[r2++]) < 128) o[i2++] = n2;
            else if (4 < (s2 = u[n2])) o[i2++] = 65533, r2 += s2 - 1;
            else {
              for (n2 &= 2 === s2 ? 31 : 3 === s2 ? 15 : 7; 1 < s2 && r2 < a; ) n2 = n2 << 6 | 63 & t2[r2++], s2--;
              1 < s2 ? o[i2++] = 65533 : n2 < 65536 ? o[i2++] = n2 : (n2 -= 65536, o[i2++] = 55296 | n2 >> 10 & 1023, o[i2++] = 56320 | 1023 & n2);
            }
            return l(o, i2);
          }, r.utf8border = function(t2, e2) {
            var r2;
            for ((e2 = e2 || t2.length) > t2.length && (e2 = t2.length), r2 = e2 - 1; 0 <= r2 && 128 == (192 & t2[r2]); ) r2--;
            return r2 < 0 ? e2 : 0 === r2 ? e2 : r2 + u[t2[r2]] > e2 ? r2 : e2;
          };
        }, { "./common": 41 }], 43: [function(t, e, r) {
          e.exports = function(t2, e2, r2, i) {
            for (var n = 65535 & t2 | 0, s = t2 >>> 16 & 65535 | 0, a = 0; 0 !== r2; ) {
              for (r2 -= a = 2e3 < r2 ? 2e3 : r2; s = s + (n = n + e2[i++] | 0) | 0, --a; ) ;
              n %= 65521, s %= 65521;
            }
            return n | s << 16 | 0;
          };
        }, {}], 44: [function(t, e, r) {
          e.exports = { Z_NO_FLUSH: 0, Z_PARTIAL_FLUSH: 1, Z_SYNC_FLUSH: 2, Z_FULL_FLUSH: 3, Z_FINISH: 4, Z_BLOCK: 5, Z_TREES: 6, Z_OK: 0, Z_STREAM_END: 1, Z_NEED_DICT: 2, Z_ERRNO: -1, Z_STREAM_ERROR: -2, Z_DATA_ERROR: -3, Z_BUF_ERROR: -5, Z_NO_COMPRESSION: 0, Z_BEST_SPEED: 1, Z_BEST_COMPRESSION: 9, Z_DEFAULT_COMPRESSION: -1, Z_FILTERED: 1, Z_HUFFMAN_ONLY: 2, Z_RLE: 3, Z_FIXED: 4, Z_DEFAULT_STRATEGY: 0, Z_BINARY: 0, Z_TEXT: 1, Z_UNKNOWN: 2, Z_DEFLATED: 8 };
        }, {}], 45: [function(t, e, r) {
          var o = (function() {
            for (var t2, e2 = [], r2 = 0; r2 < 256; r2++) {
              t2 = r2;
              for (var i = 0; i < 8; i++) t2 = 1 & t2 ? 3988292384 ^ t2 >>> 1 : t2 >>> 1;
              e2[r2] = t2;
            }
            return e2;
          })();
          e.exports = function(t2, e2, r2, i) {
            var n = o, s = i + r2;
            t2 ^= -1;
            for (var a = i; a < s; a++) t2 = t2 >>> 8 ^ n[255 & (t2 ^ e2[a])];
            return -1 ^ t2;
          };
        }, {}], 46: [function(t, e, r) {
          var h2, d = t("../utils/common"), u = t("./trees"), c = t("./adler32"), p = t("./crc32"), i = t("./messages"), l = 0, f = 4, m = 0, _ = -2, g = -1, b = 4, n = 2, v = 8, y = 9, s = 286, a = 30, o = 19, w = 2 * s + 1, k = 15, x = 3, S = 258, z = S + x + 1, C = 42, E = 113, A = 1, I = 2, O = 3, B = 4;
          function R(t2, e2) {
            return t2.msg = i[e2], e2;
          }
          function T(t2) {
            return (t2 << 1) - (4 < t2 ? 9 : 0);
          }
          function D(t2) {
            for (var e2 = t2.length; 0 <= --e2; ) t2[e2] = 0;
          }
          function F(t2) {
            var e2 = t2.state, r2 = e2.pending;
            r2 > t2.avail_out && (r2 = t2.avail_out), 0 !== r2 && (d.arraySet(t2.output, e2.pending_buf, e2.pending_out, r2, t2.next_out), t2.next_out += r2, e2.pending_out += r2, t2.total_out += r2, t2.avail_out -= r2, e2.pending -= r2, 0 === e2.pending && (e2.pending_out = 0));
          }
          function N(t2, e2) {
            u._tr_flush_block(t2, 0 <= t2.block_start ? t2.block_start : -1, t2.strstart - t2.block_start, e2), t2.block_start = t2.strstart, F(t2.strm);
          }
          function U(t2, e2) {
            t2.pending_buf[t2.pending++] = e2;
          }
          function P(t2, e2) {
            t2.pending_buf[t2.pending++] = e2 >>> 8 & 255, t2.pending_buf[t2.pending++] = 255 & e2;
          }
          function L(t2, e2) {
            var r2, i2, n2 = t2.max_chain_length, s2 = t2.strstart, a2 = t2.prev_length, o2 = t2.nice_match, h3 = t2.strstart > t2.w_size - z ? t2.strstart - (t2.w_size - z) : 0, u2 = t2.window, l2 = t2.w_mask, f2 = t2.prev, d2 = t2.strstart + S, c2 = u2[s2 + a2 - 1], p2 = u2[s2 + a2];
            t2.prev_length >= t2.good_match && (n2 >>= 2), o2 > t2.lookahead && (o2 = t2.lookahead);
            do {
              if (u2[(r2 = e2) + a2] === p2 && u2[r2 + a2 - 1] === c2 && u2[r2] === u2[s2] && u2[++r2] === u2[s2 + 1]) {
                s2 += 2, r2++;
                do {
                } while (u2[++s2] === u2[++r2] && u2[++s2] === u2[++r2] && u2[++s2] === u2[++r2] && u2[++s2] === u2[++r2] && u2[++s2] === u2[++r2] && u2[++s2] === u2[++r2] && u2[++s2] === u2[++r2] && u2[++s2] === u2[++r2] && s2 < d2);
                if (i2 = S - (d2 - s2), s2 = d2 - S, a2 < i2) {
                  if (t2.match_start = e2, o2 <= (a2 = i2)) break;
                  c2 = u2[s2 + a2 - 1], p2 = u2[s2 + a2];
                }
              }
            } while ((e2 = f2[e2 & l2]) > h3 && 0 != --n2);
            return a2 <= t2.lookahead ? a2 : t2.lookahead;
          }
          function j(t2) {
            var e2, r2, i2, n2, s2, a2, o2, h3, u2, l2, f2 = t2.w_size;
            do {
              if (n2 = t2.window_size - t2.lookahead - t2.strstart, t2.strstart >= f2 + (f2 - z)) {
                for (d.arraySet(t2.window, t2.window, f2, f2, 0), t2.match_start -= f2, t2.strstart -= f2, t2.block_start -= f2, e2 = r2 = t2.hash_size; i2 = t2.head[--e2], t2.head[e2] = f2 <= i2 ? i2 - f2 : 0, --r2; ) ;
                for (e2 = r2 = f2; i2 = t2.prev[--e2], t2.prev[e2] = f2 <= i2 ? i2 - f2 : 0, --r2; ) ;
                n2 += f2;
              }
              if (0 === t2.strm.avail_in) break;
              if (a2 = t2.strm, o2 = t2.window, h3 = t2.strstart + t2.lookahead, u2 = n2, l2 = void 0, l2 = a2.avail_in, u2 < l2 && (l2 = u2), r2 = 0 === l2 ? 0 : (a2.avail_in -= l2, d.arraySet(o2, a2.input, a2.next_in, l2, h3), 1 === a2.state.wrap ? a2.adler = c(a2.adler, o2, l2, h3) : 2 === a2.state.wrap && (a2.adler = p(a2.adler, o2, l2, h3)), a2.next_in += l2, a2.total_in += l2, l2), t2.lookahead += r2, t2.lookahead + t2.insert >= x) for (s2 = t2.strstart - t2.insert, t2.ins_h = t2.window[s2], t2.ins_h = (t2.ins_h << t2.hash_shift ^ t2.window[s2 + 1]) & t2.hash_mask; t2.insert && (t2.ins_h = (t2.ins_h << t2.hash_shift ^ t2.window[s2 + x - 1]) & t2.hash_mask, t2.prev[s2 & t2.w_mask] = t2.head[t2.ins_h], t2.head[t2.ins_h] = s2, s2++, t2.insert--, !(t2.lookahead + t2.insert < x)); ) ;
            } while (t2.lookahead < z && 0 !== t2.strm.avail_in);
          }
          function Z(t2, e2) {
            for (var r2, i2; ; ) {
              if (t2.lookahead < z) {
                if (j(t2), t2.lookahead < z && e2 === l) return A;
                if (0 === t2.lookahead) break;
              }
              if (r2 = 0, t2.lookahead >= x && (t2.ins_h = (t2.ins_h << t2.hash_shift ^ t2.window[t2.strstart + x - 1]) & t2.hash_mask, r2 = t2.prev[t2.strstart & t2.w_mask] = t2.head[t2.ins_h], t2.head[t2.ins_h] = t2.strstart), 0 !== r2 && t2.strstart - r2 <= t2.w_size - z && (t2.match_length = L(t2, r2)), t2.match_length >= x) if (i2 = u._tr_tally(t2, t2.strstart - t2.match_start, t2.match_length - x), t2.lookahead -= t2.match_length, t2.match_length <= t2.max_lazy_match && t2.lookahead >= x) {
                for (t2.match_length--; t2.strstart++, t2.ins_h = (t2.ins_h << t2.hash_shift ^ t2.window[t2.strstart + x - 1]) & t2.hash_mask, r2 = t2.prev[t2.strstart & t2.w_mask] = t2.head[t2.ins_h], t2.head[t2.ins_h] = t2.strstart, 0 != --t2.match_length; ) ;
                t2.strstart++;
              } else t2.strstart += t2.match_length, t2.match_length = 0, t2.ins_h = t2.window[t2.strstart], t2.ins_h = (t2.ins_h << t2.hash_shift ^ t2.window[t2.strstart + 1]) & t2.hash_mask;
              else i2 = u._tr_tally(t2, 0, t2.window[t2.strstart]), t2.lookahead--, t2.strstart++;
              if (i2 && (N(t2, false), 0 === t2.strm.avail_out)) return A;
            }
            return t2.insert = t2.strstart < x - 1 ? t2.strstart : x - 1, e2 === f ? (N(t2, true), 0 === t2.strm.avail_out ? O : B) : t2.last_lit && (N(t2, false), 0 === t2.strm.avail_out) ? A : I;
          }
          function W(t2, e2) {
            for (var r2, i2, n2; ; ) {
              if (t2.lookahead < z) {
                if (j(t2), t2.lookahead < z && e2 === l) return A;
                if (0 === t2.lookahead) break;
              }
              if (r2 = 0, t2.lookahead >= x && (t2.ins_h = (t2.ins_h << t2.hash_shift ^ t2.window[t2.strstart + x - 1]) & t2.hash_mask, r2 = t2.prev[t2.strstart & t2.w_mask] = t2.head[t2.ins_h], t2.head[t2.ins_h] = t2.strstart), t2.prev_length = t2.match_length, t2.prev_match = t2.match_start, t2.match_length = x - 1, 0 !== r2 && t2.prev_length < t2.max_lazy_match && t2.strstart - r2 <= t2.w_size - z && (t2.match_length = L(t2, r2), t2.match_length <= 5 && (1 === t2.strategy || t2.match_length === x && 4096 < t2.strstart - t2.match_start) && (t2.match_length = x - 1)), t2.prev_length >= x && t2.match_length <= t2.prev_length) {
                for (n2 = t2.strstart + t2.lookahead - x, i2 = u._tr_tally(t2, t2.strstart - 1 - t2.prev_match, t2.prev_length - x), t2.lookahead -= t2.prev_length - 1, t2.prev_length -= 2; ++t2.strstart <= n2 && (t2.ins_h = (t2.ins_h << t2.hash_shift ^ t2.window[t2.strstart + x - 1]) & t2.hash_mask, r2 = t2.prev[t2.strstart & t2.w_mask] = t2.head[t2.ins_h], t2.head[t2.ins_h] = t2.strstart), 0 != --t2.prev_length; ) ;
                if (t2.match_available = 0, t2.match_length = x - 1, t2.strstart++, i2 && (N(t2, false), 0 === t2.strm.avail_out)) return A;
              } else if (t2.match_available) {
                if ((i2 = u._tr_tally(t2, 0, t2.window[t2.strstart - 1])) && N(t2, false), t2.strstart++, t2.lookahead--, 0 === t2.strm.avail_out) return A;
              } else t2.match_available = 1, t2.strstart++, t2.lookahead--;
            }
            return t2.match_available && (i2 = u._tr_tally(t2, 0, t2.window[t2.strstart - 1]), t2.match_available = 0), t2.insert = t2.strstart < x - 1 ? t2.strstart : x - 1, e2 === f ? (N(t2, true), 0 === t2.strm.avail_out ? O : B) : t2.last_lit && (N(t2, false), 0 === t2.strm.avail_out) ? A : I;
          }
          function M(t2, e2, r2, i2, n2) {
            this.good_length = t2, this.max_lazy = e2, this.nice_length = r2, this.max_chain = i2, this.func = n2;
          }
          function H() {
            this.strm = null, this.status = 0, this.pending_buf = null, this.pending_buf_size = 0, this.pending_out = 0, this.pending = 0, this.wrap = 0, this.gzhead = null, this.gzindex = 0, this.method = v, this.last_flush = -1, this.w_size = 0, this.w_bits = 0, this.w_mask = 0, this.window = null, this.window_size = 0, this.prev = null, this.head = null, this.ins_h = 0, this.hash_size = 0, this.hash_bits = 0, this.hash_mask = 0, this.hash_shift = 0, this.block_start = 0, this.match_length = 0, this.prev_match = 0, this.match_available = 0, this.strstart = 0, this.match_start = 0, this.lookahead = 0, this.prev_length = 0, this.max_chain_length = 0, this.max_lazy_match = 0, this.level = 0, this.strategy = 0, this.good_match = 0, this.nice_match = 0, this.dyn_ltree = new d.Buf16(2 * w), this.dyn_dtree = new d.Buf16(2 * (2 * a + 1)), this.bl_tree = new d.Buf16(2 * (2 * o + 1)), D(this.dyn_ltree), D(this.dyn_dtree), D(this.bl_tree), this.l_desc = null, this.d_desc = null, this.bl_desc = null, this.bl_count = new d.Buf16(k + 1), this.heap = new d.Buf16(2 * s + 1), D(this.heap), this.heap_len = 0, this.heap_max = 0, this.depth = new d.Buf16(2 * s + 1), D(this.depth), this.l_buf = 0, this.lit_bufsize = 0, this.last_lit = 0, this.d_buf = 0, this.opt_len = 0, this.static_len = 0, this.matches = 0, this.insert = 0, this.bi_buf = 0, this.bi_valid = 0;
          }
          function G(t2) {
            var e2;
            return t2 && t2.state ? (t2.total_in = t2.total_out = 0, t2.data_type = n, (e2 = t2.state).pending = 0, e2.pending_out = 0, e2.wrap < 0 && (e2.wrap = -e2.wrap), e2.status = e2.wrap ? C : E, t2.adler = 2 === e2.wrap ? 0 : 1, e2.last_flush = l, u._tr_init(e2), m) : R(t2, _);
          }
          function K(t2) {
            var e2 = G(t2);
            return e2 === m && (function(t3) {
              t3.window_size = 2 * t3.w_size, D(t3.head), t3.max_lazy_match = h2[t3.level].max_lazy, t3.good_match = h2[t3.level].good_length, t3.nice_match = h2[t3.level].nice_length, t3.max_chain_length = h2[t3.level].max_chain, t3.strstart = 0, t3.block_start = 0, t3.lookahead = 0, t3.insert = 0, t3.match_length = t3.prev_length = x - 1, t3.match_available = 0, t3.ins_h = 0;
            })(t2.state), e2;
          }
          function Y(t2, e2, r2, i2, n2, s2) {
            if (!t2) return _;
            var a2 = 1;
            if (e2 === g && (e2 = 6), i2 < 0 ? (a2 = 0, i2 = -i2) : 15 < i2 && (a2 = 2, i2 -= 16), n2 < 1 || y < n2 || r2 !== v || i2 < 8 || 15 < i2 || e2 < 0 || 9 < e2 || s2 < 0 || b < s2) return R(t2, _);
            8 === i2 && (i2 = 9);
            var o2 = new H();
            return (t2.state = o2).strm = t2, o2.wrap = a2, o2.gzhead = null, o2.w_bits = i2, o2.w_size = 1 << o2.w_bits, o2.w_mask = o2.w_size - 1, o2.hash_bits = n2 + 7, o2.hash_size = 1 << o2.hash_bits, o2.hash_mask = o2.hash_size - 1, o2.hash_shift = ~~((o2.hash_bits + x - 1) / x), o2.window = new d.Buf8(2 * o2.w_size), o2.head = new d.Buf16(o2.hash_size), o2.prev = new d.Buf16(o2.w_size), o2.lit_bufsize = 1 << n2 + 6, o2.pending_buf_size = 4 * o2.lit_bufsize, o2.pending_buf = new d.Buf8(o2.pending_buf_size), o2.d_buf = 1 * o2.lit_bufsize, o2.l_buf = 3 * o2.lit_bufsize, o2.level = e2, o2.strategy = s2, o2.method = r2, K(t2);
          }
          h2 = [new M(0, 0, 0, 0, function(t2, e2) {
            var r2 = 65535;
            for (r2 > t2.pending_buf_size - 5 && (r2 = t2.pending_buf_size - 5); ; ) {
              if (t2.lookahead <= 1) {
                if (j(t2), 0 === t2.lookahead && e2 === l) return A;
                if (0 === t2.lookahead) break;
              }
              t2.strstart += t2.lookahead, t2.lookahead = 0;
              var i2 = t2.block_start + r2;
              if ((0 === t2.strstart || t2.strstart >= i2) && (t2.lookahead = t2.strstart - i2, t2.strstart = i2, N(t2, false), 0 === t2.strm.avail_out)) return A;
              if (t2.strstart - t2.block_start >= t2.w_size - z && (N(t2, false), 0 === t2.strm.avail_out)) return A;
            }
            return t2.insert = 0, e2 === f ? (N(t2, true), 0 === t2.strm.avail_out ? O : B) : (t2.strstart > t2.block_start && (N(t2, false), t2.strm.avail_out), A);
          }), new M(4, 4, 8, 4, Z), new M(4, 5, 16, 8, Z), new M(4, 6, 32, 32, Z), new M(4, 4, 16, 16, W), new M(8, 16, 32, 32, W), new M(8, 16, 128, 128, W), new M(8, 32, 128, 256, W), new M(32, 128, 258, 1024, W), new M(32, 258, 258, 4096, W)], r.deflateInit = function(t2, e2) {
            return Y(t2, e2, v, 15, 8, 0);
          }, r.deflateInit2 = Y, r.deflateReset = K, r.deflateResetKeep = G, r.deflateSetHeader = function(t2, e2) {
            return t2 && t2.state ? 2 !== t2.state.wrap ? _ : (t2.state.gzhead = e2, m) : _;
          }, r.deflate = function(t2, e2) {
            var r2, i2, n2, s2;
            if (!t2 || !t2.state || 5 < e2 || e2 < 0) return t2 ? R(t2, _) : _;
            if (i2 = t2.state, !t2.output || !t2.input && 0 !== t2.avail_in || 666 === i2.status && e2 !== f) return R(t2, 0 === t2.avail_out ? -5 : _);
            if (i2.strm = t2, r2 = i2.last_flush, i2.last_flush = e2, i2.status === C) if (2 === i2.wrap) t2.adler = 0, U(i2, 31), U(i2, 139), U(i2, 8), i2.gzhead ? (U(i2, (i2.gzhead.text ? 1 : 0) + (i2.gzhead.hcrc ? 2 : 0) + (i2.gzhead.extra ? 4 : 0) + (i2.gzhead.name ? 8 : 0) + (i2.gzhead.comment ? 16 : 0)), U(i2, 255 & i2.gzhead.time), U(i2, i2.gzhead.time >> 8 & 255), U(i2, i2.gzhead.time >> 16 & 255), U(i2, i2.gzhead.time >> 24 & 255), U(i2, 9 === i2.level ? 2 : 2 <= i2.strategy || i2.level < 2 ? 4 : 0), U(i2, 255 & i2.gzhead.os), i2.gzhead.extra && i2.gzhead.extra.length && (U(i2, 255 & i2.gzhead.extra.length), U(i2, i2.gzhead.extra.length >> 8 & 255)), i2.gzhead.hcrc && (t2.adler = p(t2.adler, i2.pending_buf, i2.pending, 0)), i2.gzindex = 0, i2.status = 69) : (U(i2, 0), U(i2, 0), U(i2, 0), U(i2, 0), U(i2, 0), U(i2, 9 === i2.level ? 2 : 2 <= i2.strategy || i2.level < 2 ? 4 : 0), U(i2, 3), i2.status = E);
            else {
              var a2 = v + (i2.w_bits - 8 << 4) << 8;
              a2 |= (2 <= i2.strategy || i2.level < 2 ? 0 : i2.level < 6 ? 1 : 6 === i2.level ? 2 : 3) << 6, 0 !== i2.strstart && (a2 |= 32), a2 += 31 - a2 % 31, i2.status = E, P(i2, a2), 0 !== i2.strstart && (P(i2, t2.adler >>> 16), P(i2, 65535 & t2.adler)), t2.adler = 1;
            }
            if (69 === i2.status) if (i2.gzhead.extra) {
              for (n2 = i2.pending; i2.gzindex < (65535 & i2.gzhead.extra.length) && (i2.pending !== i2.pending_buf_size || (i2.gzhead.hcrc && i2.pending > n2 && (t2.adler = p(t2.adler, i2.pending_buf, i2.pending - n2, n2)), F(t2), n2 = i2.pending, i2.pending !== i2.pending_buf_size)); ) U(i2, 255 & i2.gzhead.extra[i2.gzindex]), i2.gzindex++;
              i2.gzhead.hcrc && i2.pending > n2 && (t2.adler = p(t2.adler, i2.pending_buf, i2.pending - n2, n2)), i2.gzindex === i2.gzhead.extra.length && (i2.gzindex = 0, i2.status = 73);
            } else i2.status = 73;
            if (73 === i2.status) if (i2.gzhead.name) {
              n2 = i2.pending;
              do {
                if (i2.pending === i2.pending_buf_size && (i2.gzhead.hcrc && i2.pending > n2 && (t2.adler = p(t2.adler, i2.pending_buf, i2.pending - n2, n2)), F(t2), n2 = i2.pending, i2.pending === i2.pending_buf_size)) {
                  s2 = 1;
                  break;
                }
                s2 = i2.gzindex < i2.gzhead.name.length ? 255 & i2.gzhead.name.charCodeAt(i2.gzindex++) : 0, U(i2, s2);
              } while (0 !== s2);
              i2.gzhead.hcrc && i2.pending > n2 && (t2.adler = p(t2.adler, i2.pending_buf, i2.pending - n2, n2)), 0 === s2 && (i2.gzindex = 0, i2.status = 91);
            } else i2.status = 91;
            if (91 === i2.status) if (i2.gzhead.comment) {
              n2 = i2.pending;
              do {
                if (i2.pending === i2.pending_buf_size && (i2.gzhead.hcrc && i2.pending > n2 && (t2.adler = p(t2.adler, i2.pending_buf, i2.pending - n2, n2)), F(t2), n2 = i2.pending, i2.pending === i2.pending_buf_size)) {
                  s2 = 1;
                  break;
                }
                s2 = i2.gzindex < i2.gzhead.comment.length ? 255 & i2.gzhead.comment.charCodeAt(i2.gzindex++) : 0, U(i2, s2);
              } while (0 !== s2);
              i2.gzhead.hcrc && i2.pending > n2 && (t2.adler = p(t2.adler, i2.pending_buf, i2.pending - n2, n2)), 0 === s2 && (i2.status = 103);
            } else i2.status = 103;
            if (103 === i2.status && (i2.gzhead.hcrc ? (i2.pending + 2 > i2.pending_buf_size && F(t2), i2.pending + 2 <= i2.pending_buf_size && (U(i2, 255 & t2.adler), U(i2, t2.adler >> 8 & 255), t2.adler = 0, i2.status = E)) : i2.status = E), 0 !== i2.pending) {
              if (F(t2), 0 === t2.avail_out) return i2.last_flush = -1, m;
            } else if (0 === t2.avail_in && T(e2) <= T(r2) && e2 !== f) return R(t2, -5);
            if (666 === i2.status && 0 !== t2.avail_in) return R(t2, -5);
            if (0 !== t2.avail_in || 0 !== i2.lookahead || e2 !== l && 666 !== i2.status) {
              var o2 = 2 === i2.strategy ? (function(t3, e3) {
                for (var r3; ; ) {
                  if (0 === t3.lookahead && (j(t3), 0 === t3.lookahead)) {
                    if (e3 === l) return A;
                    break;
                  }
                  if (t3.match_length = 0, r3 = u._tr_tally(t3, 0, t3.window[t3.strstart]), t3.lookahead--, t3.strstart++, r3 && (N(t3, false), 0 === t3.strm.avail_out)) return A;
                }
                return t3.insert = 0, e3 === f ? (N(t3, true), 0 === t3.strm.avail_out ? O : B) : t3.last_lit && (N(t3, false), 0 === t3.strm.avail_out) ? A : I;
              })(i2, e2) : 3 === i2.strategy ? (function(t3, e3) {
                for (var r3, i3, n3, s3, a3 = t3.window; ; ) {
                  if (t3.lookahead <= S) {
                    if (j(t3), t3.lookahead <= S && e3 === l) return A;
                    if (0 === t3.lookahead) break;
                  }
                  if (t3.match_length = 0, t3.lookahead >= x && 0 < t3.strstart && (i3 = a3[n3 = t3.strstart - 1]) === a3[++n3] && i3 === a3[++n3] && i3 === a3[++n3]) {
                    s3 = t3.strstart + S;
                    do {
                    } while (i3 === a3[++n3] && i3 === a3[++n3] && i3 === a3[++n3] && i3 === a3[++n3] && i3 === a3[++n3] && i3 === a3[++n3] && i3 === a3[++n3] && i3 === a3[++n3] && n3 < s3);
                    t3.match_length = S - (s3 - n3), t3.match_length > t3.lookahead && (t3.match_length = t3.lookahead);
                  }
                  if (t3.match_length >= x ? (r3 = u._tr_tally(t3, 1, t3.match_length - x), t3.lookahead -= t3.match_length, t3.strstart += t3.match_length, t3.match_length = 0) : (r3 = u._tr_tally(t3, 0, t3.window[t3.strstart]), t3.lookahead--, t3.strstart++), r3 && (N(t3, false), 0 === t3.strm.avail_out)) return A;
                }
                return t3.insert = 0, e3 === f ? (N(t3, true), 0 === t3.strm.avail_out ? O : B) : t3.last_lit && (N(t3, false), 0 === t3.strm.avail_out) ? A : I;
              })(i2, e2) : h2[i2.level].func(i2, e2);
              if (o2 !== O && o2 !== B || (i2.status = 666), o2 === A || o2 === O) return 0 === t2.avail_out && (i2.last_flush = -1), m;
              if (o2 === I && (1 === e2 ? u._tr_align(i2) : 5 !== e2 && (u._tr_stored_block(i2, 0, 0, false), 3 === e2 && (D(i2.head), 0 === i2.lookahead && (i2.strstart = 0, i2.block_start = 0, i2.insert = 0))), F(t2), 0 === t2.avail_out)) return i2.last_flush = -1, m;
            }
            return e2 !== f ? m : i2.wrap <= 0 ? 1 : (2 === i2.wrap ? (U(i2, 255 & t2.adler), U(i2, t2.adler >> 8 & 255), U(i2, t2.adler >> 16 & 255), U(i2, t2.adler >> 24 & 255), U(i2, 255 & t2.total_in), U(i2, t2.total_in >> 8 & 255), U(i2, t2.total_in >> 16 & 255), U(i2, t2.total_in >> 24 & 255)) : (P(i2, t2.adler >>> 16), P(i2, 65535 & t2.adler)), F(t2), 0 < i2.wrap && (i2.wrap = -i2.wrap), 0 !== i2.pending ? m : 1);
          }, r.deflateEnd = function(t2) {
            var e2;
            return t2 && t2.state ? (e2 = t2.state.status) !== C && 69 !== e2 && 73 !== e2 && 91 !== e2 && 103 !== e2 && e2 !== E && 666 !== e2 ? R(t2, _) : (t2.state = null, e2 === E ? R(t2, -3) : m) : _;
          }, r.deflateSetDictionary = function(t2, e2) {
            var r2, i2, n2, s2, a2, o2, h3, u2, l2 = e2.length;
            if (!t2 || !t2.state) return _;
            if (2 === (s2 = (r2 = t2.state).wrap) || 1 === s2 && r2.status !== C || r2.lookahead) return _;
            for (1 === s2 && (t2.adler = c(t2.adler, e2, l2, 0)), r2.wrap = 0, l2 >= r2.w_size && (0 === s2 && (D(r2.head), r2.strstart = 0, r2.block_start = 0, r2.insert = 0), u2 = new d.Buf8(r2.w_size), d.arraySet(u2, e2, l2 - r2.w_size, r2.w_size, 0), e2 = u2, l2 = r2.w_size), a2 = t2.avail_in, o2 = t2.next_in, h3 = t2.input, t2.avail_in = l2, t2.next_in = 0, t2.input = e2, j(r2); r2.lookahead >= x; ) {
              for (i2 = r2.strstart, n2 = r2.lookahead - (x - 1); r2.ins_h = (r2.ins_h << r2.hash_shift ^ r2.window[i2 + x - 1]) & r2.hash_mask, r2.prev[i2 & r2.w_mask] = r2.head[r2.ins_h], r2.head[r2.ins_h] = i2, i2++, --n2; ) ;
              r2.strstart = i2, r2.lookahead = x - 1, j(r2);
            }
            return r2.strstart += r2.lookahead, r2.block_start = r2.strstart, r2.insert = r2.lookahead, r2.lookahead = 0, r2.match_length = r2.prev_length = x - 1, r2.match_available = 0, t2.next_in = o2, t2.input = h3, t2.avail_in = a2, r2.wrap = s2, m;
          }, r.deflateInfo = "pako deflate (from Nodeca project)";
        }, { "../utils/common": 41, "./adler32": 43, "./crc32": 45, "./messages": 51, "./trees": 52 }], 47: [function(t, e, r) {
          e.exports = function() {
            this.text = 0, this.time = 0, this.xflags = 0, this.os = 0, this.extra = null, this.extra_len = 0, this.name = "", this.comment = "", this.hcrc = 0, this.done = false;
          };
        }, {}], 48: [function(t, e, r) {
          e.exports = function(t2, e2) {
            var r2, i, n, s, a, o, h2, u, l, f, d, c, p, m, _, g, b, v, y, w, k, x, S, z, C;
            r2 = t2.state, i = t2.next_in, z = t2.input, n = i + (t2.avail_in - 5), s = t2.next_out, C = t2.output, a = s - (e2 - t2.avail_out), o = s + (t2.avail_out - 257), h2 = r2.dmax, u = r2.wsize, l = r2.whave, f = r2.wnext, d = r2.window, c = r2.hold, p = r2.bits, m = r2.lencode, _ = r2.distcode, g = (1 << r2.lenbits) - 1, b = (1 << r2.distbits) - 1;
            t: do {
              p < 15 && (c += z[i++] << p, p += 8, c += z[i++] << p, p += 8), v = m[c & g];
              e: for (; ; ) {
                if (c >>>= y = v >>> 24, p -= y, 0 === (y = v >>> 16 & 255)) C[s++] = 65535 & v;
                else {
                  if (!(16 & y)) {
                    if (0 == (64 & y)) {
                      v = m[(65535 & v) + (c & (1 << y) - 1)];
                      continue e;
                    }
                    if (32 & y) {
                      r2.mode = 12;
                      break t;
                    }
                    t2.msg = "invalid literal/length code", r2.mode = 30;
                    break t;
                  }
                  w = 65535 & v, (y &= 15) && (p < y && (c += z[i++] << p, p += 8), w += c & (1 << y) - 1, c >>>= y, p -= y), p < 15 && (c += z[i++] << p, p += 8, c += z[i++] << p, p += 8), v = _[c & b];
                  r: for (; ; ) {
                    if (c >>>= y = v >>> 24, p -= y, !(16 & (y = v >>> 16 & 255))) {
                      if (0 == (64 & y)) {
                        v = _[(65535 & v) + (c & (1 << y) - 1)];
                        continue r;
                      }
                      t2.msg = "invalid distance code", r2.mode = 30;
                      break t;
                    }
                    if (k = 65535 & v, p < (y &= 15) && (c += z[i++] << p, (p += 8) < y && (c += z[i++] << p, p += 8)), h2 < (k += c & (1 << y) - 1)) {
                      t2.msg = "invalid distance too far back", r2.mode = 30;
                      break t;
                    }
                    if (c >>>= y, p -= y, (y = s - a) < k) {
                      if (l < (y = k - y) && r2.sane) {
                        t2.msg = "invalid distance too far back", r2.mode = 30;
                        break t;
                      }
                      if (S = d, (x = 0) === f) {
                        if (x += u - y, y < w) {
                          for (w -= y; C[s++] = d[x++], --y; ) ;
                          x = s - k, S = C;
                        }
                      } else if (f < y) {
                        if (x += u + f - y, (y -= f) < w) {
                          for (w -= y; C[s++] = d[x++], --y; ) ;
                          if (x = 0, f < w) {
                            for (w -= y = f; C[s++] = d[x++], --y; ) ;
                            x = s - k, S = C;
                          }
                        }
                      } else if (x += f - y, y < w) {
                        for (w -= y; C[s++] = d[x++], --y; ) ;
                        x = s - k, S = C;
                      }
                      for (; 2 < w; ) C[s++] = S[x++], C[s++] = S[x++], C[s++] = S[x++], w -= 3;
                      w && (C[s++] = S[x++], 1 < w && (C[s++] = S[x++]));
                    } else {
                      for (x = s - k; C[s++] = C[x++], C[s++] = C[x++], C[s++] = C[x++], 2 < (w -= 3); ) ;
                      w && (C[s++] = C[x++], 1 < w && (C[s++] = C[x++]));
                    }
                    break;
                  }
                }
                break;
              }
            } while (i < n && s < o);
            i -= w = p >> 3, c &= (1 << (p -= w << 3)) - 1, t2.next_in = i, t2.next_out = s, t2.avail_in = i < n ? n - i + 5 : 5 - (i - n), t2.avail_out = s < o ? o - s + 257 : 257 - (s - o), r2.hold = c, r2.bits = p;
          };
        }, {}], 49: [function(t, e, r) {
          var I = t("../utils/common"), O = t("./adler32"), B = t("./crc32"), R = t("./inffast"), T = t("./inftrees"), D = 1, F = 2, N = 0, U = -2, P = 1, i = 852, n = 592;
          function L(t2) {
            return (t2 >>> 24 & 255) + (t2 >>> 8 & 65280) + ((65280 & t2) << 8) + ((255 & t2) << 24);
          }
          function s() {
            this.mode = 0, this.last = false, this.wrap = 0, this.havedict = false, this.flags = 0, this.dmax = 0, this.check = 0, this.total = 0, this.head = null, this.wbits = 0, this.wsize = 0, this.whave = 0, this.wnext = 0, this.window = null, this.hold = 0, this.bits = 0, this.length = 0, this.offset = 0, this.extra = 0, this.lencode = null, this.distcode = null, this.lenbits = 0, this.distbits = 0, this.ncode = 0, this.nlen = 0, this.ndist = 0, this.have = 0, this.next = null, this.lens = new I.Buf16(320), this.work = new I.Buf16(288), this.lendyn = null, this.distdyn = null, this.sane = 0, this.back = 0, this.was = 0;
          }
          function a(t2) {
            var e2;
            return t2 && t2.state ? (e2 = t2.state, t2.total_in = t2.total_out = e2.total = 0, t2.msg = "", e2.wrap && (t2.adler = 1 & e2.wrap), e2.mode = P, e2.last = 0, e2.havedict = 0, e2.dmax = 32768, e2.head = null, e2.hold = 0, e2.bits = 0, e2.lencode = e2.lendyn = new I.Buf32(i), e2.distcode = e2.distdyn = new I.Buf32(n), e2.sane = 1, e2.back = -1, N) : U;
          }
          function o(t2) {
            var e2;
            return t2 && t2.state ? ((e2 = t2.state).wsize = 0, e2.whave = 0, e2.wnext = 0, a(t2)) : U;
          }
          function h2(t2, e2) {
            var r2, i2;
            return t2 && t2.state ? (i2 = t2.state, e2 < 0 ? (r2 = 0, e2 = -e2) : (r2 = 1 + (e2 >> 4), e2 < 48 && (e2 &= 15)), e2 && (e2 < 8 || 15 < e2) ? U : (null !== i2.window && i2.wbits !== e2 && (i2.window = null), i2.wrap = r2, i2.wbits = e2, o(t2))) : U;
          }
          function u(t2, e2) {
            var r2, i2;
            return t2 ? (i2 = new s(), (t2.state = i2).window = null, (r2 = h2(t2, e2)) !== N && (t2.state = null), r2) : U;
          }
          var l, f, d = true;
          function j(t2) {
            if (d) {
              var e2;
              for (l = new I.Buf32(512), f = new I.Buf32(32), e2 = 0; e2 < 144; ) t2.lens[e2++] = 8;
              for (; e2 < 256; ) t2.lens[e2++] = 9;
              for (; e2 < 280; ) t2.lens[e2++] = 7;
              for (; e2 < 288; ) t2.lens[e2++] = 8;
              for (T(D, t2.lens, 0, 288, l, 0, t2.work, { bits: 9 }), e2 = 0; e2 < 32; ) t2.lens[e2++] = 5;
              T(F, t2.lens, 0, 32, f, 0, t2.work, { bits: 5 }), d = false;
            }
            t2.lencode = l, t2.lenbits = 9, t2.distcode = f, t2.distbits = 5;
          }
          function Z(t2, e2, r2, i2) {
            var n2, s2 = t2.state;
            return null === s2.window && (s2.wsize = 1 << s2.wbits, s2.wnext = 0, s2.whave = 0, s2.window = new I.Buf8(s2.wsize)), i2 >= s2.wsize ? (I.arraySet(s2.window, e2, r2 - s2.wsize, s2.wsize, 0), s2.wnext = 0, s2.whave = s2.wsize) : (i2 < (n2 = s2.wsize - s2.wnext) && (n2 = i2), I.arraySet(s2.window, e2, r2 - i2, n2, s2.wnext), (i2 -= n2) ? (I.arraySet(s2.window, e2, r2 - i2, i2, 0), s2.wnext = i2, s2.whave = s2.wsize) : (s2.wnext += n2, s2.wnext === s2.wsize && (s2.wnext = 0), s2.whave < s2.wsize && (s2.whave += n2))), 0;
          }
          r.inflateReset = o, r.inflateReset2 = h2, r.inflateResetKeep = a, r.inflateInit = function(t2) {
            return u(t2, 15);
          }, r.inflateInit2 = u, r.inflate = function(t2, e2) {
            var r2, i2, n2, s2, a2, o2, h3, u2, l2, f2, d2, c, p, m, _, g, b, v, y, w, k, x, S, z, C = 0, E = new I.Buf8(4), A = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];
            if (!t2 || !t2.state || !t2.output || !t2.input && 0 !== t2.avail_in) return U;
            12 === (r2 = t2.state).mode && (r2.mode = 13), a2 = t2.next_out, n2 = t2.output, h3 = t2.avail_out, s2 = t2.next_in, i2 = t2.input, o2 = t2.avail_in, u2 = r2.hold, l2 = r2.bits, f2 = o2, d2 = h3, x = N;
            t: for (; ; ) switch (r2.mode) {
              case P:
                if (0 === r2.wrap) {
                  r2.mode = 13;
                  break;
                }
                for (; l2 < 16; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                if (2 & r2.wrap && 35615 === u2) {
                  E[r2.check = 0] = 255 & u2, E[1] = u2 >>> 8 & 255, r2.check = B(r2.check, E, 2, 0), l2 = u2 = 0, r2.mode = 2;
                  break;
                }
                if (r2.flags = 0, r2.head && (r2.head.done = false), !(1 & r2.wrap) || (((255 & u2) << 8) + (u2 >> 8)) % 31) {
                  t2.msg = "incorrect header check", r2.mode = 30;
                  break;
                }
                if (8 != (15 & u2)) {
                  t2.msg = "unknown compression method", r2.mode = 30;
                  break;
                }
                if (l2 -= 4, k = 8 + (15 & (u2 >>>= 4)), 0 === r2.wbits) r2.wbits = k;
                else if (k > r2.wbits) {
                  t2.msg = "invalid window size", r2.mode = 30;
                  break;
                }
                r2.dmax = 1 << k, t2.adler = r2.check = 1, r2.mode = 512 & u2 ? 10 : 12, l2 = u2 = 0;
                break;
              case 2:
                for (; l2 < 16; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                if (r2.flags = u2, 8 != (255 & r2.flags)) {
                  t2.msg = "unknown compression method", r2.mode = 30;
                  break;
                }
                if (57344 & r2.flags) {
                  t2.msg = "unknown header flags set", r2.mode = 30;
                  break;
                }
                r2.head && (r2.head.text = u2 >> 8 & 1), 512 & r2.flags && (E[0] = 255 & u2, E[1] = u2 >>> 8 & 255, r2.check = B(r2.check, E, 2, 0)), l2 = u2 = 0, r2.mode = 3;
              case 3:
                for (; l2 < 32; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                r2.head && (r2.head.time = u2), 512 & r2.flags && (E[0] = 255 & u2, E[1] = u2 >>> 8 & 255, E[2] = u2 >>> 16 & 255, E[3] = u2 >>> 24 & 255, r2.check = B(r2.check, E, 4, 0)), l2 = u2 = 0, r2.mode = 4;
              case 4:
                for (; l2 < 16; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                r2.head && (r2.head.xflags = 255 & u2, r2.head.os = u2 >> 8), 512 & r2.flags && (E[0] = 255 & u2, E[1] = u2 >>> 8 & 255, r2.check = B(r2.check, E, 2, 0)), l2 = u2 = 0, r2.mode = 5;
              case 5:
                if (1024 & r2.flags) {
                  for (; l2 < 16; ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  r2.length = u2, r2.head && (r2.head.extra_len = u2), 512 & r2.flags && (E[0] = 255 & u2, E[1] = u2 >>> 8 & 255, r2.check = B(r2.check, E, 2, 0)), l2 = u2 = 0;
                } else r2.head && (r2.head.extra = null);
                r2.mode = 6;
              case 6:
                if (1024 & r2.flags && (o2 < (c = r2.length) && (c = o2), c && (r2.head && (k = r2.head.extra_len - r2.length, r2.head.extra || (r2.head.extra = new Array(r2.head.extra_len)), I.arraySet(r2.head.extra, i2, s2, c, k)), 512 & r2.flags && (r2.check = B(r2.check, i2, c, s2)), o2 -= c, s2 += c, r2.length -= c), r2.length)) break t;
                r2.length = 0, r2.mode = 7;
              case 7:
                if (2048 & r2.flags) {
                  if (0 === o2) break t;
                  for (c = 0; k = i2[s2 + c++], r2.head && k && r2.length < 65536 && (r2.head.name += String.fromCharCode(k)), k && c < o2; ) ;
                  if (512 & r2.flags && (r2.check = B(r2.check, i2, c, s2)), o2 -= c, s2 += c, k) break t;
                } else r2.head && (r2.head.name = null);
                r2.length = 0, r2.mode = 8;
              case 8:
                if (4096 & r2.flags) {
                  if (0 === o2) break t;
                  for (c = 0; k = i2[s2 + c++], r2.head && k && r2.length < 65536 && (r2.head.comment += String.fromCharCode(k)), k && c < o2; ) ;
                  if (512 & r2.flags && (r2.check = B(r2.check, i2, c, s2)), o2 -= c, s2 += c, k) break t;
                } else r2.head && (r2.head.comment = null);
                r2.mode = 9;
              case 9:
                if (512 & r2.flags) {
                  for (; l2 < 16; ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  if (u2 !== (65535 & r2.check)) {
                    t2.msg = "header crc mismatch", r2.mode = 30;
                    break;
                  }
                  l2 = u2 = 0;
                }
                r2.head && (r2.head.hcrc = r2.flags >> 9 & 1, r2.head.done = true), t2.adler = r2.check = 0, r2.mode = 12;
                break;
              case 10:
                for (; l2 < 32; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                t2.adler = r2.check = L(u2), l2 = u2 = 0, r2.mode = 11;
              case 11:
                if (0 === r2.havedict) return t2.next_out = a2, t2.avail_out = h3, t2.next_in = s2, t2.avail_in = o2, r2.hold = u2, r2.bits = l2, 2;
                t2.adler = r2.check = 1, r2.mode = 12;
              case 12:
                if (5 === e2 || 6 === e2) break t;
              case 13:
                if (r2.last) {
                  u2 >>>= 7 & l2, l2 -= 7 & l2, r2.mode = 27;
                  break;
                }
                for (; l2 < 3; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                switch (r2.last = 1 & u2, l2 -= 1, 3 & (u2 >>>= 1)) {
                  case 0:
                    r2.mode = 14;
                    break;
                  case 1:
                    if (j(r2), r2.mode = 20, 6 !== e2) break;
                    u2 >>>= 2, l2 -= 2;
                    break t;
                  case 2:
                    r2.mode = 17;
                    break;
                  case 3:
                    t2.msg = "invalid block type", r2.mode = 30;
                }
                u2 >>>= 2, l2 -= 2;
                break;
              case 14:
                for (u2 >>>= 7 & l2, l2 -= 7 & l2; l2 < 32; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                if ((65535 & u2) != (u2 >>> 16 ^ 65535)) {
                  t2.msg = "invalid stored block lengths", r2.mode = 30;
                  break;
                }
                if (r2.length = 65535 & u2, l2 = u2 = 0, r2.mode = 15, 6 === e2) break t;
              case 15:
                r2.mode = 16;
              case 16:
                if (c = r2.length) {
                  if (o2 < c && (c = o2), h3 < c && (c = h3), 0 === c) break t;
                  I.arraySet(n2, i2, s2, c, a2), o2 -= c, s2 += c, h3 -= c, a2 += c, r2.length -= c;
                  break;
                }
                r2.mode = 12;
                break;
              case 17:
                for (; l2 < 14; ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                if (r2.nlen = 257 + (31 & u2), u2 >>>= 5, l2 -= 5, r2.ndist = 1 + (31 & u2), u2 >>>= 5, l2 -= 5, r2.ncode = 4 + (15 & u2), u2 >>>= 4, l2 -= 4, 286 < r2.nlen || 30 < r2.ndist) {
                  t2.msg = "too many length or distance symbols", r2.mode = 30;
                  break;
                }
                r2.have = 0, r2.mode = 18;
              case 18:
                for (; r2.have < r2.ncode; ) {
                  for (; l2 < 3; ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  r2.lens[A[r2.have++]] = 7 & u2, u2 >>>= 3, l2 -= 3;
                }
                for (; r2.have < 19; ) r2.lens[A[r2.have++]] = 0;
                if (r2.lencode = r2.lendyn, r2.lenbits = 7, S = { bits: r2.lenbits }, x = T(0, r2.lens, 0, 19, r2.lencode, 0, r2.work, S), r2.lenbits = S.bits, x) {
                  t2.msg = "invalid code lengths set", r2.mode = 30;
                  break;
                }
                r2.have = 0, r2.mode = 19;
              case 19:
                for (; r2.have < r2.nlen + r2.ndist; ) {
                  for (; g = (C = r2.lencode[u2 & (1 << r2.lenbits) - 1]) >>> 16 & 255, b = 65535 & C, !((_ = C >>> 24) <= l2); ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  if (b < 16) u2 >>>= _, l2 -= _, r2.lens[r2.have++] = b;
                  else {
                    if (16 === b) {
                      for (z = _ + 2; l2 < z; ) {
                        if (0 === o2) break t;
                        o2--, u2 += i2[s2++] << l2, l2 += 8;
                      }
                      if (u2 >>>= _, l2 -= _, 0 === r2.have) {
                        t2.msg = "invalid bit length repeat", r2.mode = 30;
                        break;
                      }
                      k = r2.lens[r2.have - 1], c = 3 + (3 & u2), u2 >>>= 2, l2 -= 2;
                    } else if (17 === b) {
                      for (z = _ + 3; l2 < z; ) {
                        if (0 === o2) break t;
                        o2--, u2 += i2[s2++] << l2, l2 += 8;
                      }
                      l2 -= _, k = 0, c = 3 + (7 & (u2 >>>= _)), u2 >>>= 3, l2 -= 3;
                    } else {
                      for (z = _ + 7; l2 < z; ) {
                        if (0 === o2) break t;
                        o2--, u2 += i2[s2++] << l2, l2 += 8;
                      }
                      l2 -= _, k = 0, c = 11 + (127 & (u2 >>>= _)), u2 >>>= 7, l2 -= 7;
                    }
                    if (r2.have + c > r2.nlen + r2.ndist) {
                      t2.msg = "invalid bit length repeat", r2.mode = 30;
                      break;
                    }
                    for (; c--; ) r2.lens[r2.have++] = k;
                  }
                }
                if (30 === r2.mode) break;
                if (0 === r2.lens[256]) {
                  t2.msg = "invalid code -- missing end-of-block", r2.mode = 30;
                  break;
                }
                if (r2.lenbits = 9, S = { bits: r2.lenbits }, x = T(D, r2.lens, 0, r2.nlen, r2.lencode, 0, r2.work, S), r2.lenbits = S.bits, x) {
                  t2.msg = "invalid literal/lengths set", r2.mode = 30;
                  break;
                }
                if (r2.distbits = 6, r2.distcode = r2.distdyn, S = { bits: r2.distbits }, x = T(F, r2.lens, r2.nlen, r2.ndist, r2.distcode, 0, r2.work, S), r2.distbits = S.bits, x) {
                  t2.msg = "invalid distances set", r2.mode = 30;
                  break;
                }
                if (r2.mode = 20, 6 === e2) break t;
              case 20:
                r2.mode = 21;
              case 21:
                if (6 <= o2 && 258 <= h3) {
                  t2.next_out = a2, t2.avail_out = h3, t2.next_in = s2, t2.avail_in = o2, r2.hold = u2, r2.bits = l2, R(t2, d2), a2 = t2.next_out, n2 = t2.output, h3 = t2.avail_out, s2 = t2.next_in, i2 = t2.input, o2 = t2.avail_in, u2 = r2.hold, l2 = r2.bits, 12 === r2.mode && (r2.back = -1);
                  break;
                }
                for (r2.back = 0; g = (C = r2.lencode[u2 & (1 << r2.lenbits) - 1]) >>> 16 & 255, b = 65535 & C, !((_ = C >>> 24) <= l2); ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                if (g && 0 == (240 & g)) {
                  for (v = _, y = g, w = b; g = (C = r2.lencode[w + ((u2 & (1 << v + y) - 1) >> v)]) >>> 16 & 255, b = 65535 & C, !(v + (_ = C >>> 24) <= l2); ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  u2 >>>= v, l2 -= v, r2.back += v;
                }
                if (u2 >>>= _, l2 -= _, r2.back += _, r2.length = b, 0 === g) {
                  r2.mode = 26;
                  break;
                }
                if (32 & g) {
                  r2.back = -1, r2.mode = 12;
                  break;
                }
                if (64 & g) {
                  t2.msg = "invalid literal/length code", r2.mode = 30;
                  break;
                }
                r2.extra = 15 & g, r2.mode = 22;
              case 22:
                if (r2.extra) {
                  for (z = r2.extra; l2 < z; ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  r2.length += u2 & (1 << r2.extra) - 1, u2 >>>= r2.extra, l2 -= r2.extra, r2.back += r2.extra;
                }
                r2.was = r2.length, r2.mode = 23;
              case 23:
                for (; g = (C = r2.distcode[u2 & (1 << r2.distbits) - 1]) >>> 16 & 255, b = 65535 & C, !((_ = C >>> 24) <= l2); ) {
                  if (0 === o2) break t;
                  o2--, u2 += i2[s2++] << l2, l2 += 8;
                }
                if (0 == (240 & g)) {
                  for (v = _, y = g, w = b; g = (C = r2.distcode[w + ((u2 & (1 << v + y) - 1) >> v)]) >>> 16 & 255, b = 65535 & C, !(v + (_ = C >>> 24) <= l2); ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  u2 >>>= v, l2 -= v, r2.back += v;
                }
                if (u2 >>>= _, l2 -= _, r2.back += _, 64 & g) {
                  t2.msg = "invalid distance code", r2.mode = 30;
                  break;
                }
                r2.offset = b, r2.extra = 15 & g, r2.mode = 24;
              case 24:
                if (r2.extra) {
                  for (z = r2.extra; l2 < z; ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  r2.offset += u2 & (1 << r2.extra) - 1, u2 >>>= r2.extra, l2 -= r2.extra, r2.back += r2.extra;
                }
                if (r2.offset > r2.dmax) {
                  t2.msg = "invalid distance too far back", r2.mode = 30;
                  break;
                }
                r2.mode = 25;
              case 25:
                if (0 === h3) break t;
                if (c = d2 - h3, r2.offset > c) {
                  if ((c = r2.offset - c) > r2.whave && r2.sane) {
                    t2.msg = "invalid distance too far back", r2.mode = 30;
                    break;
                  }
                  p = c > r2.wnext ? (c -= r2.wnext, r2.wsize - c) : r2.wnext - c, c > r2.length && (c = r2.length), m = r2.window;
                } else m = n2, p = a2 - r2.offset, c = r2.length;
                for (h3 < c && (c = h3), h3 -= c, r2.length -= c; n2[a2++] = m[p++], --c; ) ;
                0 === r2.length && (r2.mode = 21);
                break;
              case 26:
                if (0 === h3) break t;
                n2[a2++] = r2.length, h3--, r2.mode = 21;
                break;
              case 27:
                if (r2.wrap) {
                  for (; l2 < 32; ) {
                    if (0 === o2) break t;
                    o2--, u2 |= i2[s2++] << l2, l2 += 8;
                  }
                  if (d2 -= h3, t2.total_out += d2, r2.total += d2, d2 && (t2.adler = r2.check = r2.flags ? B(r2.check, n2, d2, a2 - d2) : O(r2.check, n2, d2, a2 - d2)), d2 = h3, (r2.flags ? u2 : L(u2)) !== r2.check) {
                    t2.msg = "incorrect data check", r2.mode = 30;
                    break;
                  }
                  l2 = u2 = 0;
                }
                r2.mode = 28;
              case 28:
                if (r2.wrap && r2.flags) {
                  for (; l2 < 32; ) {
                    if (0 === o2) break t;
                    o2--, u2 += i2[s2++] << l2, l2 += 8;
                  }
                  if (u2 !== (4294967295 & r2.total)) {
                    t2.msg = "incorrect length check", r2.mode = 30;
                    break;
                  }
                  l2 = u2 = 0;
                }
                r2.mode = 29;
              case 29:
                x = 1;
                break t;
              case 30:
                x = -3;
                break t;
              case 31:
                return -4;
              case 32:
              default:
                return U;
            }
            return t2.next_out = a2, t2.avail_out = h3, t2.next_in = s2, t2.avail_in = o2, r2.hold = u2, r2.bits = l2, (r2.wsize || d2 !== t2.avail_out && r2.mode < 30 && (r2.mode < 27 || 4 !== e2)) && Z(t2, t2.output, t2.next_out, d2 - t2.avail_out) ? (r2.mode = 31, -4) : (f2 -= t2.avail_in, d2 -= t2.avail_out, t2.total_in += f2, t2.total_out += d2, r2.total += d2, r2.wrap && d2 && (t2.adler = r2.check = r2.flags ? B(r2.check, n2, d2, t2.next_out - d2) : O(r2.check, n2, d2, t2.next_out - d2)), t2.data_type = r2.bits + (r2.last ? 64 : 0) + (12 === r2.mode ? 128 : 0) + (20 === r2.mode || 15 === r2.mode ? 256 : 0), (0 == f2 && 0 === d2 || 4 === e2) && x === N && (x = -5), x);
          }, r.inflateEnd = function(t2) {
            if (!t2 || !t2.state) return U;
            var e2 = t2.state;
            return e2.window && (e2.window = null), t2.state = null, N;
          }, r.inflateGetHeader = function(t2, e2) {
            var r2;
            return t2 && t2.state ? 0 == (2 & (r2 = t2.state).wrap) ? U : ((r2.head = e2).done = false, N) : U;
          }, r.inflateSetDictionary = function(t2, e2) {
            var r2, i2 = e2.length;
            return t2 && t2.state ? 0 !== (r2 = t2.state).wrap && 11 !== r2.mode ? U : 11 === r2.mode && O(1, e2, i2, 0) !== r2.check ? -3 : Z(t2, e2, i2, i2) ? (r2.mode = 31, -4) : (r2.havedict = 1, N) : U;
          }, r.inflateInfo = "pako inflate (from Nodeca project)";
        }, { "../utils/common": 41, "./adler32": 43, "./crc32": 45, "./inffast": 48, "./inftrees": 50 }], 50: [function(t, e, r) {
          var D = t("../utils/common"), F = [3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0], N = [16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78], U = [1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0], P = [16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 64, 64];
          e.exports = function(t2, e2, r2, i, n, s, a, o) {
            var h2, u, l, f, d, c, p, m, _, g = o.bits, b = 0, v = 0, y = 0, w = 0, k = 0, x = 0, S = 0, z = 0, C = 0, E = 0, A = null, I = 0, O = new D.Buf16(16), B = new D.Buf16(16), R = null, T = 0;
            for (b = 0; b <= 15; b++) O[b] = 0;
            for (v = 0; v < i; v++) O[e2[r2 + v]]++;
            for (k = g, w = 15; 1 <= w && 0 === O[w]; w--) ;
            if (w < k && (k = w), 0 === w) return n[s++] = 20971520, n[s++] = 20971520, o.bits = 1, 0;
            for (y = 1; y < w && 0 === O[y]; y++) ;
            for (k < y && (k = y), b = z = 1; b <= 15; b++) if (z <<= 1, (z -= O[b]) < 0) return -1;
            if (0 < z && (0 === t2 || 1 !== w)) return -1;
            for (B[1] = 0, b = 1; b < 15; b++) B[b + 1] = B[b] + O[b];
            for (v = 0; v < i; v++) 0 !== e2[r2 + v] && (a[B[e2[r2 + v]]++] = v);
            if (c = 0 === t2 ? (A = R = a, 19) : 1 === t2 ? (A = F, I -= 257, R = N, T -= 257, 256) : (A = U, R = P, -1), b = y, d = s, S = v = E = 0, l = -1, f = (C = 1 << (x = k)) - 1, 1 === t2 && 852 < C || 2 === t2 && 592 < C) return 1;
            for (; ; ) {
              for (p = b - S, _ = a[v] < c ? (m = 0, a[v]) : a[v] > c ? (m = R[T + a[v]], A[I + a[v]]) : (m = 96, 0), h2 = 1 << b - S, y = u = 1 << x; n[d + (E >> S) + (u -= h2)] = p << 24 | m << 16 | _ | 0, 0 !== u; ) ;
              for (h2 = 1 << b - 1; E & h2; ) h2 >>= 1;
              if (0 !== h2 ? (E &= h2 - 1, E += h2) : E = 0, v++, 0 == --O[b]) {
                if (b === w) break;
                b = e2[r2 + a[v]];
              }
              if (k < b && (E & f) !== l) {
                for (0 === S && (S = k), d += y, z = 1 << (x = b - S); x + S < w && !((z -= O[x + S]) <= 0); ) x++, z <<= 1;
                if (C += 1 << x, 1 === t2 && 852 < C || 2 === t2 && 592 < C) return 1;
                n[l = E & f] = k << 24 | x << 16 | d - s | 0;
              }
            }
            return 0 !== E && (n[d + E] = b - S << 24 | 64 << 16 | 0), o.bits = k, 0;
          };
        }, { "../utils/common": 41 }], 51: [function(t, e, r) {
          e.exports = { 2: "need dictionary", 1: "stream end", 0: "", "-1": "file error", "-2": "stream error", "-3": "data error", "-4": "insufficient memory", "-5": "buffer error", "-6": "incompatible version" };
        }, {}], 52: [function(t, e, r) {
          var n = t("../utils/common"), o = 0, h2 = 1;
          function i(t2) {
            for (var e2 = t2.length; 0 <= --e2; ) t2[e2] = 0;
          }
          var s = 0, a = 29, u = 256, l = u + 1 + a, f = 30, d = 19, _ = 2 * l + 1, g = 15, c = 16, p = 7, m = 256, b = 16, v = 17, y = 18, w = [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0], k = [0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13], x = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7], S = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15], z = new Array(2 * (l + 2));
          i(z);
          var C = new Array(2 * f);
          i(C);
          var E = new Array(512);
          i(E);
          var A = new Array(256);
          i(A);
          var I = new Array(a);
          i(I);
          var O, B, R, T = new Array(f);
          function D(t2, e2, r2, i2, n2) {
            this.static_tree = t2, this.extra_bits = e2, this.extra_base = r2, this.elems = i2, this.max_length = n2, this.has_stree = t2 && t2.length;
          }
          function F(t2, e2) {
            this.dyn_tree = t2, this.max_code = 0, this.stat_desc = e2;
          }
          function N(t2) {
            return t2 < 256 ? E[t2] : E[256 + (t2 >>> 7)];
          }
          function U(t2, e2) {
            t2.pending_buf[t2.pending++] = 255 & e2, t2.pending_buf[t2.pending++] = e2 >>> 8 & 255;
          }
          function P(t2, e2, r2) {
            t2.bi_valid > c - r2 ? (t2.bi_buf |= e2 << t2.bi_valid & 65535, U(t2, t2.bi_buf), t2.bi_buf = e2 >> c - t2.bi_valid, t2.bi_valid += r2 - c) : (t2.bi_buf |= e2 << t2.bi_valid & 65535, t2.bi_valid += r2);
          }
          function L(t2, e2, r2) {
            P(t2, r2[2 * e2], r2[2 * e2 + 1]);
          }
          function j(t2, e2) {
            for (var r2 = 0; r2 |= 1 & t2, t2 >>>= 1, r2 <<= 1, 0 < --e2; ) ;
            return r2 >>> 1;
          }
          function Z(t2, e2, r2) {
            var i2, n2, s2 = new Array(g + 1), a2 = 0;
            for (i2 = 1; i2 <= g; i2++) s2[i2] = a2 = a2 + r2[i2 - 1] << 1;
            for (n2 = 0; n2 <= e2; n2++) {
              var o2 = t2[2 * n2 + 1];
              0 !== o2 && (t2[2 * n2] = j(s2[o2]++, o2));
            }
          }
          function W(t2) {
            var e2;
            for (e2 = 0; e2 < l; e2++) t2.dyn_ltree[2 * e2] = 0;
            for (e2 = 0; e2 < f; e2++) t2.dyn_dtree[2 * e2] = 0;
            for (e2 = 0; e2 < d; e2++) t2.bl_tree[2 * e2] = 0;
            t2.dyn_ltree[2 * m] = 1, t2.opt_len = t2.static_len = 0, t2.last_lit = t2.matches = 0;
          }
          function M(t2) {
            8 < t2.bi_valid ? U(t2, t2.bi_buf) : 0 < t2.bi_valid && (t2.pending_buf[t2.pending++] = t2.bi_buf), t2.bi_buf = 0, t2.bi_valid = 0;
          }
          function H(t2, e2, r2, i2) {
            var n2 = 2 * e2, s2 = 2 * r2;
            return t2[n2] < t2[s2] || t2[n2] === t2[s2] && i2[e2] <= i2[r2];
          }
          function G(t2, e2, r2) {
            for (var i2 = t2.heap[r2], n2 = r2 << 1; n2 <= t2.heap_len && (n2 < t2.heap_len && H(e2, t2.heap[n2 + 1], t2.heap[n2], t2.depth) && n2++, !H(e2, i2, t2.heap[n2], t2.depth)); ) t2.heap[r2] = t2.heap[n2], r2 = n2, n2 <<= 1;
            t2.heap[r2] = i2;
          }
          function K(t2, e2, r2) {
            var i2, n2, s2, a2, o2 = 0;
            if (0 !== t2.last_lit) for (; i2 = t2.pending_buf[t2.d_buf + 2 * o2] << 8 | t2.pending_buf[t2.d_buf + 2 * o2 + 1], n2 = t2.pending_buf[t2.l_buf + o2], o2++, 0 === i2 ? L(t2, n2, e2) : (L(t2, (s2 = A[n2]) + u + 1, e2), 0 !== (a2 = w[s2]) && P(t2, n2 -= I[s2], a2), L(t2, s2 = N(--i2), r2), 0 !== (a2 = k[s2]) && P(t2, i2 -= T[s2], a2)), o2 < t2.last_lit; ) ;
            L(t2, m, e2);
          }
          function Y(t2, e2) {
            var r2, i2, n2, s2 = e2.dyn_tree, a2 = e2.stat_desc.static_tree, o2 = e2.stat_desc.has_stree, h3 = e2.stat_desc.elems, u2 = -1;
            for (t2.heap_len = 0, t2.heap_max = _, r2 = 0; r2 < h3; r2++) 0 !== s2[2 * r2] ? (t2.heap[++t2.heap_len] = u2 = r2, t2.depth[r2] = 0) : s2[2 * r2 + 1] = 0;
            for (; t2.heap_len < 2; ) s2[2 * (n2 = t2.heap[++t2.heap_len] = u2 < 2 ? ++u2 : 0)] = 1, t2.depth[n2] = 0, t2.opt_len--, o2 && (t2.static_len -= a2[2 * n2 + 1]);
            for (e2.max_code = u2, r2 = t2.heap_len >> 1; 1 <= r2; r2--) G(t2, s2, r2);
            for (n2 = h3; r2 = t2.heap[1], t2.heap[1] = t2.heap[t2.heap_len--], G(t2, s2, 1), i2 = t2.heap[1], t2.heap[--t2.heap_max] = r2, t2.heap[--t2.heap_max] = i2, s2[2 * n2] = s2[2 * r2] + s2[2 * i2], t2.depth[n2] = (t2.depth[r2] >= t2.depth[i2] ? t2.depth[r2] : t2.depth[i2]) + 1, s2[2 * r2 + 1] = s2[2 * i2 + 1] = n2, t2.heap[1] = n2++, G(t2, s2, 1), 2 <= t2.heap_len; ) ;
            t2.heap[--t2.heap_max] = t2.heap[1], (function(t3, e3) {
              var r3, i3, n3, s3, a3, o3, h4 = e3.dyn_tree, u3 = e3.max_code, l2 = e3.stat_desc.static_tree, f2 = e3.stat_desc.has_stree, d2 = e3.stat_desc.extra_bits, c2 = e3.stat_desc.extra_base, p2 = e3.stat_desc.max_length, m2 = 0;
              for (s3 = 0; s3 <= g; s3++) t3.bl_count[s3] = 0;
              for (h4[2 * t3.heap[t3.heap_max] + 1] = 0, r3 = t3.heap_max + 1; r3 < _; r3++) p2 < (s3 = h4[2 * h4[2 * (i3 = t3.heap[r3]) + 1] + 1] + 1) && (s3 = p2, m2++), h4[2 * i3 + 1] = s3, u3 < i3 || (t3.bl_count[s3]++, a3 = 0, c2 <= i3 && (a3 = d2[i3 - c2]), o3 = h4[2 * i3], t3.opt_len += o3 * (s3 + a3), f2 && (t3.static_len += o3 * (l2[2 * i3 + 1] + a3)));
              if (0 !== m2) {
                do {
                  for (s3 = p2 - 1; 0 === t3.bl_count[s3]; ) s3--;
                  t3.bl_count[s3]--, t3.bl_count[s3 + 1] += 2, t3.bl_count[p2]--, m2 -= 2;
                } while (0 < m2);
                for (s3 = p2; 0 !== s3; s3--) for (i3 = t3.bl_count[s3]; 0 !== i3; ) u3 < (n3 = t3.heap[--r3]) || (h4[2 * n3 + 1] !== s3 && (t3.opt_len += (s3 - h4[2 * n3 + 1]) * h4[2 * n3], h4[2 * n3 + 1] = s3), i3--);
              }
            })(t2, e2), Z(s2, u2, t2.bl_count);
          }
          function X(t2, e2, r2) {
            var i2, n2, s2 = -1, a2 = e2[1], o2 = 0, h3 = 7, u2 = 4;
            for (0 === a2 && (h3 = 138, u2 = 3), e2[2 * (r2 + 1) + 1] = 65535, i2 = 0; i2 <= r2; i2++) n2 = a2, a2 = e2[2 * (i2 + 1) + 1], ++o2 < h3 && n2 === a2 || (o2 < u2 ? t2.bl_tree[2 * n2] += o2 : 0 !== n2 ? (n2 !== s2 && t2.bl_tree[2 * n2]++, t2.bl_tree[2 * b]++) : o2 <= 10 ? t2.bl_tree[2 * v]++ : t2.bl_tree[2 * y]++, s2 = n2, u2 = (o2 = 0) === a2 ? (h3 = 138, 3) : n2 === a2 ? (h3 = 6, 3) : (h3 = 7, 4));
          }
          function V(t2, e2, r2) {
            var i2, n2, s2 = -1, a2 = e2[1], o2 = 0, h3 = 7, u2 = 4;
            for (0 === a2 && (h3 = 138, u2 = 3), i2 = 0; i2 <= r2; i2++) if (n2 = a2, a2 = e2[2 * (i2 + 1) + 1], !(++o2 < h3 && n2 === a2)) {
              if (o2 < u2) for (; L(t2, n2, t2.bl_tree), 0 != --o2; ) ;
              else 0 !== n2 ? (n2 !== s2 && (L(t2, n2, t2.bl_tree), o2--), L(t2, b, t2.bl_tree), P(t2, o2 - 3, 2)) : o2 <= 10 ? (L(t2, v, t2.bl_tree), P(t2, o2 - 3, 3)) : (L(t2, y, t2.bl_tree), P(t2, o2 - 11, 7));
              s2 = n2, u2 = (o2 = 0) === a2 ? (h3 = 138, 3) : n2 === a2 ? (h3 = 6, 3) : (h3 = 7, 4);
            }
          }
          i(T);
          var q = false;
          function J(t2, e2, r2, i2) {
            P(t2, (s << 1) + (i2 ? 1 : 0), 3), (function(t3, e3, r3, i3) {
              M(t3), U(t3, r3), U(t3, ~r3), n.arraySet(t3.pending_buf, t3.window, e3, r3, t3.pending), t3.pending += r3;
            })(t2, e2, r2);
          }
          r._tr_init = function(t2) {
            q || ((function() {
              var t3, e2, r2, i2, n2, s2 = new Array(g + 1);
              for (i2 = r2 = 0; i2 < a - 1; i2++) for (I[i2] = r2, t3 = 0; t3 < 1 << w[i2]; t3++) A[r2++] = i2;
              for (A[r2 - 1] = i2, i2 = n2 = 0; i2 < 16; i2++) for (T[i2] = n2, t3 = 0; t3 < 1 << k[i2]; t3++) E[n2++] = i2;
              for (n2 >>= 7; i2 < f; i2++) for (T[i2] = n2 << 7, t3 = 0; t3 < 1 << k[i2] - 7; t3++) E[256 + n2++] = i2;
              for (e2 = 0; e2 <= g; e2++) s2[e2] = 0;
              for (t3 = 0; t3 <= 143; ) z[2 * t3 + 1] = 8, t3++, s2[8]++;
              for (; t3 <= 255; ) z[2 * t3 + 1] = 9, t3++, s2[9]++;
              for (; t3 <= 279; ) z[2 * t3 + 1] = 7, t3++, s2[7]++;
              for (; t3 <= 287; ) z[2 * t3 + 1] = 8, t3++, s2[8]++;
              for (Z(z, l + 1, s2), t3 = 0; t3 < f; t3++) C[2 * t3 + 1] = 5, C[2 * t3] = j(t3, 5);
              O = new D(z, w, u + 1, l, g), B = new D(C, k, 0, f, g), R = new D(new Array(0), x, 0, d, p);
            })(), q = true), t2.l_desc = new F(t2.dyn_ltree, O), t2.d_desc = new F(t2.dyn_dtree, B), t2.bl_desc = new F(t2.bl_tree, R), t2.bi_buf = 0, t2.bi_valid = 0, W(t2);
          }, r._tr_stored_block = J, r._tr_flush_block = function(t2, e2, r2, i2) {
            var n2, s2, a2 = 0;
            0 < t2.level ? (2 === t2.strm.data_type && (t2.strm.data_type = (function(t3) {
              var e3, r3 = 4093624447;
              for (e3 = 0; e3 <= 31; e3++, r3 >>>= 1) if (1 & r3 && 0 !== t3.dyn_ltree[2 * e3]) return o;
              if (0 !== t3.dyn_ltree[18] || 0 !== t3.dyn_ltree[20] || 0 !== t3.dyn_ltree[26]) return h2;
              for (e3 = 32; e3 < u; e3++) if (0 !== t3.dyn_ltree[2 * e3]) return h2;
              return o;
            })(t2)), Y(t2, t2.l_desc), Y(t2, t2.d_desc), a2 = (function(t3) {
              var e3;
              for (X(t3, t3.dyn_ltree, t3.l_desc.max_code), X(t3, t3.dyn_dtree, t3.d_desc.max_code), Y(t3, t3.bl_desc), e3 = d - 1; 3 <= e3 && 0 === t3.bl_tree[2 * S[e3] + 1]; e3--) ;
              return t3.opt_len += 3 * (e3 + 1) + 5 + 5 + 4, e3;
            })(t2), n2 = t2.opt_len + 3 + 7 >>> 3, (s2 = t2.static_len + 3 + 7 >>> 3) <= n2 && (n2 = s2)) : n2 = s2 = r2 + 5, r2 + 4 <= n2 && -1 !== e2 ? J(t2, e2, r2, i2) : 4 === t2.strategy || s2 === n2 ? (P(t2, 2 + (i2 ? 1 : 0), 3), K(t2, z, C)) : (P(t2, 4 + (i2 ? 1 : 0), 3), (function(t3, e3, r3, i3) {
              var n3;
              for (P(t3, e3 - 257, 5), P(t3, r3 - 1, 5), P(t3, i3 - 4, 4), n3 = 0; n3 < i3; n3++) P(t3, t3.bl_tree[2 * S[n3] + 1], 3);
              V(t3, t3.dyn_ltree, e3 - 1), V(t3, t3.dyn_dtree, r3 - 1);
            })(t2, t2.l_desc.max_code + 1, t2.d_desc.max_code + 1, a2 + 1), K(t2, t2.dyn_ltree, t2.dyn_dtree)), W(t2), i2 && M(t2);
          }, r._tr_tally = function(t2, e2, r2) {
            return t2.pending_buf[t2.d_buf + 2 * t2.last_lit] = e2 >>> 8 & 255, t2.pending_buf[t2.d_buf + 2 * t2.last_lit + 1] = 255 & e2, t2.pending_buf[t2.l_buf + t2.last_lit] = 255 & r2, t2.last_lit++, 0 === e2 ? t2.dyn_ltree[2 * r2]++ : (t2.matches++, e2--, t2.dyn_ltree[2 * (A[r2] + u + 1)]++, t2.dyn_dtree[2 * N(e2)]++), t2.last_lit === t2.lit_bufsize - 1;
          }, r._tr_align = function(t2) {
            P(t2, 2, 3), L(t2, m, z), (function(t3) {
              16 === t3.bi_valid ? (U(t3, t3.bi_buf), t3.bi_buf = 0, t3.bi_valid = 0) : 8 <= t3.bi_valid && (t3.pending_buf[t3.pending++] = 255 & t3.bi_buf, t3.bi_buf >>= 8, t3.bi_valid -= 8);
            })(t2);
          };
        }, { "../utils/common": 41 }], 53: [function(t, e, r) {
          e.exports = function() {
            this.input = null, this.next_in = 0, this.avail_in = 0, this.total_in = 0, this.output = null, this.next_out = 0, this.avail_out = 0, this.total_out = 0, this.msg = "", this.state = null, this.data_type = 2, this.adler = 0;
          };
        }, {}], 54: [function(t, e, r) {
          e.exports = "function" == typeof setImmediate ? setImmediate : function() {
            var t2 = [].slice.apply(arguments);
            t2.splice(1, 0, 0), setTimeout.apply(null, t2);
          };
        }, {}] }, {}, [10])(10);
      });
    })(jszip_min);
    return jszip_min.exports;
  }
  var jszip_minExports = requireJszip_min();
  const JSZip = getDefaultExportFromCjs(jszip_minExports);
  function useLogs() {
    const logs = vue.ref([]);
    function addLog(message) {
      const timestamp = ( new Date()).toLocaleTimeString("ko-KR");
      logs.value.push(`[${timestamp}] ${message}`);
      vue.nextTick(() => {
        setTimeout(() => {
          const logContainer = document.getElementById("log-container");
          if (logContainer) {
            logContainer.scrollTop = logContainer.scrollHeight;
          }
        }, 0);
      });
    }
    function clearLogs() {
      logs.value = [];
    }
    return {
      logs,
      addLog,
      clearLogs
    };
  }
  async function convertToYomiChunked(text, apiKey, chunkSize = 50, onProgress, modelId = DEFAULT_AI_MODEL) {
    const provider = getAiProvider(modelId);
    console.log(`[aiConverter] 독음 변환 시작: ${provider.name} (모델: ${modelId})`);
    return provider.convertToYomi(text, apiKey, chunkSize, onProgress, modelId);
  }
  async function getAudioDuration(blob) {
    return new Promise((resolve, reject) => {
      try {
        const audioContext = new (window.AudioContext || window.webkitAudioContext)();
        const fileReader = new FileReader();
        fileReader.onload = async () => {
          try {
            const arrayBuffer = fileReader.result;
            const audioBuffer = await audioContext.decodeAudioData(arrayBuffer);
            const duration = audioBuffer.duration;
            audioContext.close();
            resolve(Number(duration.toFixed(3)));
          } catch (error) {
            audioContext.close();
            console.error("[AudioUtils] 오디오 디코딩 실패:", error);
            reject(new Error("오디오 파일 디코딩 실패"));
          }
        };
        fileReader.onerror = () => {
          console.error("[AudioUtils] 파일 읽기 실패:", fileReader.error);
          reject(new Error("오디오 파일 읽기 실패"));
        };
        fileReader.readAsArrayBuffer(blob);
      } catch (error) {
        console.error("[AudioUtils] AudioContext 생성 실패:", error);
        reject(new Error("AudioContext 생성 실패"));
      }
    });
  }
  async function calculateAudioTimeline(segments, texts) {
    const result = [];
    let currentTime = 0;
    for (let i = 0; i < segments.length; i++) {
      const { filename, blob } = segments[i];
      const text = texts[i] || "";
      try {
        const duration = await getAudioDuration(blob);
        const startTime = currentTime;
        const endTime = currentTime + duration;
        result.push({
          text,
          filename,
          blob,
          duration,
          startTime,
          endTime
        });
        currentTime = endTime;
        console.log(`[AudioUtils] ${filename}: ${startTime.toFixed(3)}s ~ ${endTime.toFixed(3)}s (${duration.toFixed(3)}s)`);
      } catch (error) {
        console.error(`[AudioUtils] ${filename} 길이 측정 실패:`, error);
        throw new Error(`${filename} 길이 측정 실패`);
      }
    }
    return result;
  }
  function formatSrtTimestamp(seconds) {
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor(seconds % 3600 / 60);
    const secs = Math.floor(seconds % 60);
    const millis = Math.floor(seconds % 1 * 1e3);
    return `${hours.toString().padStart(2, "0")}:${minutes.toString().padStart(2, "0")}:${secs.toString().padStart(2, "0")},${millis.toString().padStart(3, "0")}`;
  }
  function formatLrcTimestamp(seconds) {
    const minutes = Math.floor(seconds / 60);
    const secs = Math.floor(seconds % 60);
    const centisecs = Math.floor(seconds % 1 * 100);
    return `[${minutes.toString().padStart(2, "0")}:${secs.toString().padStart(2, "0")}.${centisecs.toString().padStart(2, "0")}]`;
  }
  function generateSrtSubtitle(segments) {
    const lines = [];
    segments.forEach((segment, index) => {
      const sequenceNumber = index + 1;
      const startTime = formatSrtTimestamp(segment.startTime);
      const endTime = formatSrtTimestamp(segment.endTime);
      lines.push(sequenceNumber.toString());
      lines.push(`${startTime} --> ${endTime}`);
      lines.push(segment.text);
      lines.push("");
    });
    return lines.join("\n");
  }
  function generateLrcSubtitle(segments) {
    const lines = [];
    segments.forEach((segment) => {
      const timestamp = formatLrcTimestamp(segment.startTime);
      lines.push(`${timestamp}${segment.text}`);
    });
    return lines.join("\n");
  }
  function generateSubtitles(segments, format) {
    const result = [];
    if (format === "srt" || format === "both") {
      const srtContent = generateSrtSubtitle(segments);
      result.push({
        filename: "subtitle.srt",
        content: srtContent
      });
    }
    if (format === "lrc" || format === "both") {
      const lrcContent = generateLrcSubtitle(segments);
      result.push({
        filename: "subtitle.lrc",
        content: lrcContent
      });
    }
    return result;
  }
  async function mergeAudioBlobs(audioBlobs, gap = 0.5) {
    if (audioBlobs.length === 0) {
      throw new Error("병합할 오디오가 없습니다.");
    }
    if (audioBlobs.length === 1) {
      return audioBlobs[0];
    }
    const audioContext = new AudioContext();
    try {
      const audioBuffers = [];
      for (const blob of audioBlobs) {
        const arrayBuffer = await blob.arrayBuffer();
        const audioBuffer = await audioContext.decodeAudioData(arrayBuffer);
        audioBuffers.push(audioBuffer);
      }
      const totalDuration = audioBuffers.reduce((sum, buffer) => sum + buffer.duration, 0) + gap * (audioBuffers.length - 1);
      const sampleRate = audioBuffers[0].sampleRate;
      const numberOfChannels = audioBuffers[0].numberOfChannels;
      const totalLength = Math.ceil(totalDuration * sampleRate);
      const mergedBuffer = audioContext.createBuffer(
        numberOfChannels,
        totalLength,
        sampleRate
      );
      let offset = 0;
      for (let i = 0; i < audioBuffers.length; i++) {
        const buffer = audioBuffers[i];
        for (let channel = 0; channel < numberOfChannels; channel++) {
          const sourceData = buffer.getChannelData(channel);
          const targetData = mergedBuffer.getChannelData(channel);
          targetData.set(sourceData, offset);
        }
        offset += buffer.length + Math.floor(gap * sampleRate);
      }
      const wavBlob = audioBufferToWav(mergedBuffer);
      return wavBlob;
    } finally {
      await audioContext.close();
    }
  }
  function audioBufferToWav(audioBuffer) {
    const numberOfChannels = audioBuffer.numberOfChannels;
    const sampleRate = audioBuffer.sampleRate;
    const format = 1;
    const bitDepth = 16;
    const bytesPerSample = bitDepth / 8;
    const blockAlign = numberOfChannels * bytesPerSample;
    const data = interleave(audioBuffer);
    const dataLength = data.length * bytesPerSample;
    const buffer = new ArrayBuffer(44 + dataLength);
    const view = new DataView(buffer);
    writeString(view, 0, "RIFF");
    view.setUint32(4, 36 + dataLength, true);
    writeString(view, 8, "WAVE");
    writeString(view, 12, "fmt ");
    view.setUint32(16, 16, true);
    view.setUint16(20, format, true);
    view.setUint16(22, numberOfChannels, true);
    view.setUint32(24, sampleRate, true);
    view.setUint32(28, sampleRate * blockAlign, true);
    view.setUint16(32, blockAlign, true);
    view.setUint16(34, bitDepth, true);
    writeString(view, 36, "data");
    view.setUint32(40, dataLength, true);
    floatTo16BitPCM(view, 44, data);
    return new Blob([buffer], { type: "audio/wav" });
  }
  function interleave(audioBuffer) {
    const numberOfChannels = audioBuffer.numberOfChannels;
    const length = audioBuffer.length * numberOfChannels;
    const result = new Float32Array(length);
    let offset = 0;
    for (let i = 0; i < audioBuffer.length; i++) {
      for (let channel = 0; channel < numberOfChannels; channel++) {
        result[offset++] = audioBuffer.getChannelData(channel)[i];
      }
    }
    return result;
  }
  function writeString(view, offset, string) {
    for (let i = 0; i < string.length; i++) {
      view.setUint8(offset + i, string.charCodeAt(i));
    }
  }
  function floatTo16BitPCM(view, offset, input) {
    for (let i = 0; i < input.length; i++, offset += 2) {
      const s = Math.max(-1, Math.min(1, input[i]));
      view.setInt16(offset, s < 0 ? s * 32768 : s * 32767, true);
    }
  }
  function useTtsGeneration(settingsStore, addLog) {
    const isGenerating = vue.ref(false);
    const isServerConnected = vue.ref(false);
    async function generateAllTTS(inputText) {
      if (!inputText.trim()) {
        throw new Error("텍스트를 입력해주세요.");
      }
      addLog("🔄 VOICEVOX 서버 연결 확인 중...");
      const connected = await checkServerStatus(settingsStore.voicevoxServerUrl);
      if (!connected) {
        isServerConnected.value = false;
        addLog("❌ VOICEVOX 서버에 연결할 수 없습니다.");
        addLog(`   서버 주소: ${settingsStore.voicevoxServerUrl}`);
        addLog('   "재접속" 버튼을 눌러 다시 시도하거나, VOICEVOX가 실행 중인지 확인해주세요.');
        throw new Error("VOICEVOX 서버에 연결할 수 없습니다.");
      }
      isServerConnected.value = true;
      addLog("✅ VOICEVOX 서버 연결 확인 완료");
      addLog("");
      if (settingsStore.speakers.length === 0) {
        throw new Error("음성 목록을 불러오는 데 실패했습니다.");
      }
      if (settingsStore.useYomiConversion) {
        const provider = getProviderFromModel(settingsStore.selectedAiModel);
        const apiKey = settingsStore.aiApiKeys[provider];
        if (!apiKey) {
          throw new Error(`일본어 독음 변환을 사용하려면 ${provider.toUpperCase()} API 키가 필요합니다.`);
        }
      }
      isGenerating.value = true;
      try {
        const originalLines = inputText.split("\n").map((line) => line.trim()).filter((line) => line.length > 0);
        if (originalLines.length === 0) {
          addLog("⚠️ 변환할 텍스트가 없습니다.");
          return null;
        }
        addLog(`📝 총 ${originalLines.length}개의 줄을 처리합니다.`);
        addLog("");
        let processLines = originalLines;
        let yomiResult = null;
        if (settingsStore.useYomiConversion) {
          yomiResult = await performYomiConversion(inputText, originalLines, settingsStore, addLog);
          if (yomiResult) {
            processLines = yomiResult.converted.split("\n").map((line) => line.trim()).filter((line) => line.length > 0);
          }
        }
        const audioBlobs = await generateTTSBatch(processLines, settingsStore, addLog);
        addLog("⏱️ 오디오 길이 측정 중...");
        const audioSegments = await calculateAudioTimeline(audioBlobs, originalLines);
        const totalDuration = audioSegments[audioSegments.length - 1].endTime;
        addLog(`✅ 전체 길이: ${totalDuration.toFixed(3)}초`);
        addLog("");
        addLog(`📄 자막 생성 중 (형식: ${settingsStore.subtitleFormat})...`);
        const subtitles = generateSubtitles(audioSegments, settingsStore.subtitleFormat);
        addLog(`✅ ${subtitles.length}개의 자막 파일 생성 완료`);
        addLog("");
        const mergedBlob = await mergeAudioIfNeeded(audioBlobs, settingsStore, addLog);
        addLog("");
        addLog(`✅ 모든 작업 완료!`);
        addLog(`💾 원하는 형식의 "다운로드" 버튼을 눌러 파일을 저장하세요.`);
        return {
          audioBlobs,
          subtitles,
          mergedBlob,
          originalText: yomiResult?.original,
          convertedYomiText: yomiResult?.converted
        };
      } finally {
        isGenerating.value = false;
      }
    }
    return {
      isGenerating,
      isServerConnected,
      generateAllTTS
    };
  }
  async function performYomiConversion(inputText, originalLines, settingsStore, addLog) {
    const provider = getProviderFromModel(settingsStore.selectedAiModel);
    const apiKey = settingsStore.aiApiKeys[provider];
    const modelInfo = AI_MODELS.find((m) => m.id === settingsStore.selectedAiModel);
    const modelLabel = modelInfo?.label || settingsStore.selectedAiModel;
    addLog(`🤖 사용 AI 모델: ${modelLabel}`);
    addLog(`🔄 일본어 독음 변환 중... (총 ${originalLines.length}줄)`);
    addLog("");
    try {
      const conversionStartTime = Date.now();
      const yomiText = await convertToYomiChunked(
        inputText,
        apiKey,
        settingsStore.yomiChunkSize,
        (_current, _total, status) => {
          addLog(status);
        },
        settingsStore.selectedAiModel
);
      const yomiLines = yomiText.split("\n").map((line) => line.trim()).filter((line) => line.length > 0);
      const conversionElapsed = ((Date.now() - conversionStartTime) / 1e3).toFixed(1);
      if (yomiLines.length === originalLines.length) {
        addLog(`✅ 독음 변환 완료 (${yomiLines.length}줄, ${conversionElapsed}초)`);
        addLog('💡 "변환 결과 보기" 버튼을 눌러 확인할 수 있습니다.');
        addLog("");
        return {
          original: originalLines.join("\n"),
          converted: yomiText
        };
      } else {
        addLog(`⚠️ 독음 변환 후 줄 수 불일치 (원본: ${originalLines.length}, 변환: ${yomiLines.length})`);
        addLog("⚠️ 원본 텍스트로 진행합니다.");
        addLog("");
        return null;
      }
    } catch (error) {
      const errorMessage = error instanceof Error ? error.message : String(error);
      addLog(`❌ 독음 변환 실패: ${errorMessage}`);
      addLog("⚠️ 원본 텍스트로 진행합니다.");
      addLog("");
      return null;
    }
  }
  async function generateTTSBatch(lines, settingsStore, addLog) {
    const audioBlobs = [];
    const BATCH_SIZE = 10;
    const totalBatches = Math.ceil(lines.length / BATCH_SIZE);
    addLog(`🚀 TTS 생성 시작 (${BATCH_SIZE}개씩 병렬 처리, 총 ${totalBatches}개 배치)`);
    addLog("");
    for (let batchIndex = 0; batchIndex < totalBatches; batchIndex++) {
      const startIdx = batchIndex * BATCH_SIZE;
      const endIdx = Math.min(startIdx + BATCH_SIZE, lines.length);
      const batchSize = endIdx - startIdx;
      addLog(`📦 배치 ${batchIndex + 1}/${totalBatches} 처리 중... (${startIdx + 1}-${endIdx}줄, ${batchSize}개)`);
      const batchStartTime = Date.now();
      const promises = [];
      for (let i = startIdx; i < endIdx; i++) {
        const lineNumber = i + 1;
        const lineText = lines[i];
        const filename = `${lineNumber.toString().padStart(3, "0")}.wav`;
        const promise = generateTTS(
          settingsStore.voicevoxServerUrl,
          lineText,
          settingsStore.selectedSpeakerId,
          settingsStore.ttsSpeed
        ).then((blob) => ({ lineNumber, filename, blob }));
        promises.push(promise);
      }
      try {
        const results = await Promise.all(promises);
        results.forEach(({ filename, blob }) => {
          audioBlobs.push({ filename, blob });
        });
        const batchElapsed = ((Date.now() - batchStartTime) / 1e3).toFixed(1);
        addLog(`✅ 배치 ${batchIndex + 1}/${totalBatches} 완료 (${batchElapsed}초, 평균 ${(parseFloat(batchElapsed) / batchSize).toFixed(2)}초/줄)`);
        addLog("");
      } catch (error) {
        const errorMessage = error instanceof Error ? error.message : String(error);
        addLog(`❌ 배치 ${batchIndex + 1}/${totalBatches} 실패: ${errorMessage}`);
        addLog(`💡 VOICEVOX 서버 상태를 확인해주세요.`);
        addLog("");
        throw new Error(`배치 ${batchIndex + 1} TTS 생성 실패: ${errorMessage}`);
      }
    }
    return audioBlobs;
  }
  async function mergeAudioIfNeeded(audioBlobs, settingsStore, addLog) {
    if (settingsStore.audioOutputFormat !== "merged" && settingsStore.audioOutputFormat !== "both") {
      return null;
    }
    addLog(`🔗 음성 파일 병합 중... (간격: ${settingsStore.mergedAudioGap}초)`);
    const mergeStartTime = Date.now();
    try {
      const blobs = audioBlobs.map((item) => item.blob);
      const mergedBlob = await mergeAudioBlobs(blobs, settingsStore.mergedAudioGap);
      const mergeElapsed = ((Date.now() - mergeStartTime) / 1e3).toFixed(1);
      addLog(`✅ 음성 파일 병합 완료 (${mergeElapsed}초)`);
      addLog("");
      return mergedBlob;
    } catch (error) {
      const errorMessage = error instanceof Error ? error.message : String(error);
      addLog(`⚠️ 병합 실패: ${errorMessage}`);
      addLog("⚠️ 개별 파일만 포함합니다.");
      addLog("");
      return null;
    }
  }
  const _hoisted_1$4 = { class: "flex-1 flex flex-col bg-gray-900 rounded-lg shadow-xl border border-gray-800 min-h-0 overflow-hidden" };
  const _hoisted_2$4 = {
    id: "log-container",
    class: "flex-1 overflow-auto p-6 font-mono text-sm text-gray-300 leading-relaxed min-h-0"
  };
  const _hoisted_3$4 = {
    key: 0,
    class: "text-gray-500 italic"
  };
  const _sfc_main$4 = vue.defineComponent({
    __name: "LogPanel",
    props: {
      logs: {}
    },
    setup(__props) {
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$4, [
          _cache[0] || (_cache[0] = vue.createElementVNode("div", { class: "px-6 py-4 border-b border-gray-800 flex-shrink-0" }, [
            vue.createElementVNode("h2", { class: "text-lg font-semibold text-gray-200" }, "실행 로그")
          ], -1)),
          vue.createElementVNode("div", _hoisted_2$4, [
            __props.logs.length === 0 ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_3$4, " 로그가 여기에 표시됩니다... ")) : vue.createCommentVNode("", true),
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(__props.logs, (log, index) => {
              return vue.openBlock(), vue.createElementBlock("div", {
                key: index,
                class: "mb-1"
              }, vue.toDisplayString(log), 1);
            }), 128))
          ])
        ]);
      };
    }
  });
  const _hoisted_1$3 = { class: "flex-1 flex flex-col bg-gray-900 rounded-lg shadow-xl border border-gray-800 min-h-0 overflow-hidden" };
  const _hoisted_2$3 = { class: "px-6 py-4 border-b border-gray-800 flex-shrink-0" };
  const _hoisted_3$3 = { class: "flex items-center justify-between mb-3" };
  const _hoisted_4$3 = { class: "text-sm text-gray-400 font-mono" };
  const _hoisted_5$3 = { class: "mb-4" };
  const _hoisted_6$3 = ["disabled"];
  const _hoisted_7$3 = {
    key: 0,
    value: 1
  };
  const _hoisted_8$3 = ["value"];
  const _hoisted_9$2 = { class: "mb-4" };
  const _hoisted_10$2 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_11$2 = ["disabled"];
  const _hoisted_12$2 = {
    key: 0,
    class: "mt-1 text-xs text-red-400"
  };
  const _hoisted_13$1 = { class: "flex gap-4" };
  const _hoisted_14$1 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_15$1 = ["disabled"];
  const _hoisted_16$1 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_17$1 = ["disabled"];
  const _hoisted_18$1 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_19$1 = ["disabled"];
  const _hoisted_20$1 = { class: "flex-1 p-6 min-h-0 overflow-hidden" };
  const _hoisted_21$1 = ["disabled"];
  const _sfc_main$3 = vue.defineComponent({
    __name: "TextInputPanel",
    props: {
      modelValue: {},
      lineCount: {},
      selectedSpeakerId: {},
      speakerOptions: {},
      useYomiConversion: { type: Boolean },
      currentAiApiKey: {},
      currentAiModelLabel: {},
      subtitleFormat: {},
      isGenerating: { type: Boolean }
    },
    emits: ["update:modelValue", "update:selectedSpeakerId", "update:useYomiConversion", "update:subtitleFormat"],
    setup(__props, { emit: __emit }) {
      const props = __props;
      const emit = __emit;
      const text = vue.computed({
        get: () => props.modelValue,
        set: (val) => emit("update:modelValue", val)
      });
      const speakerId = vue.computed({
        get: () => props.selectedSpeakerId,
        set: (val) => emit("update:selectedSpeakerId", val)
      });
      const yomiConversion = vue.computed({
        get: () => props.useYomiConversion,
        set: (val) => emit("update:useYomiConversion", val)
      });
      const subtitle = vue.computed({
        get: () => props.subtitleFormat,
        set: (val) => emit("update:subtitleFormat", val)
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$3, [
          vue.createElementVNode("div", _hoisted_2$3, [
            vue.createElementVNode("div", _hoisted_3$3, [
              _cache[6] || (_cache[6] = vue.createElementVNode("h2", { class: "text-lg font-semibold text-gray-200" }, "텍스트 입력", -1)),
              vue.createElementVNode("span", _hoisted_4$3, vue.toDisplayString(__props.lineCount) + "줄", 1)
            ]),
            vue.createElementVNode("div", _hoisted_5$3, [
              _cache[7] || (_cache[7] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, "음성 선택", -1)),
              vue.withDirectives(vue.createElementVNode("select", {
                "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => speakerId.value = $event),
                disabled: __props.isGenerating || __props.speakerOptions.length === 0,
                class: "w-full bg-gray-800 text-white rounded-lg px-4 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 border border-gray-700 disabled:opacity-50"
              }, [
                __props.speakerOptions.length === 0 ? (vue.openBlock(), vue.createElementBlock("option", _hoisted_7$3, "로딩 중...")) : vue.createCommentVNode("", true),
                (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(__props.speakerOptions, (option) => {
                  return vue.openBlock(), vue.createElementBlock("option", {
                    key: option.value,
                    value: option.value
                  }, vue.toDisplayString(option.label), 9, _hoisted_8$3);
                }), 128))
              ], 8, _hoisted_6$3), [
                [vue.vModelSelect, speakerId.value]
              ])
            ]),
            vue.createElementVNode("div", _hoisted_9$2, [
              vue.createElementVNode("label", _hoisted_10$2, [
                vue.withDirectives(vue.createElementVNode("input", {
                  type: "checkbox",
                  "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => yomiConversion.value = $event),
                  disabled: __props.isGenerating,
                  class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 rounded focus:ring-blue-500 focus:ring-2 disabled:opacity-50"
                }, null, 8, _hoisted_11$2), [
                  [vue.vModelCheckbox, yomiConversion.value]
                ]),
                _cache[8] || (_cache[8] = vue.createTextVNode(" 일본어 독음 변환 사용 (한자 → 히라가나) ", -1))
              ]),
              yomiConversion.value && !__props.currentAiApiKey ? (vue.openBlock(), vue.createElementBlock("p", _hoisted_12$2, " ⚠️ " + vue.toDisplayString(__props.currentAiModelLabel) + " API 키가 설정되지 않았습니다. 설정 메뉴에서 API 키를 입력해주세요. ", 1)) : vue.createCommentVNode("", true)
            ]),
            vue.createElementVNode("div", null, [
              _cache[12] || (_cache[12] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, "자막 형식", -1)),
              vue.createElementVNode("div", _hoisted_13$1, [
                vue.createElementVNode("label", _hoisted_14$1, [
                  vue.withDirectives(vue.createElementVNode("input", {
                    type: "radio",
                    "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => subtitle.value = $event),
                    value: "srt",
                    disabled: __props.isGenerating,
                    class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2 disabled:opacity-50"
                  }, null, 8, _hoisted_15$1), [
                    [vue.vModelRadio, subtitle.value]
                  ]),
                  _cache[9] || (_cache[9] = vue.createTextVNode(" SRT ", -1))
                ]),
                vue.createElementVNode("label", _hoisted_16$1, [
                  vue.withDirectives(vue.createElementVNode("input", {
                    type: "radio",
                    "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => subtitle.value = $event),
                    value: "lrc",
                    disabled: __props.isGenerating,
                    class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2 disabled:opacity-50"
                  }, null, 8, _hoisted_17$1), [
                    [vue.vModelRadio, subtitle.value]
                  ]),
                  _cache[10] || (_cache[10] = vue.createTextVNode(" LRC ", -1))
                ]),
                vue.createElementVNode("label", _hoisted_18$1, [
                  vue.withDirectives(vue.createElementVNode("input", {
                    type: "radio",
                    "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => subtitle.value = $event),
                    value: "both",
                    disabled: __props.isGenerating,
                    class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2 disabled:opacity-50"
                  }, null, 8, _hoisted_19$1), [
                    [vue.vModelRadio, subtitle.value]
                  ]),
                  _cache[11] || (_cache[11] = vue.createTextVNode(" 둘 다 ", -1))
                ])
              ])
            ])
          ]),
          vue.createElementVNode("div", _hoisted_20$1, [
            vue.withDirectives(vue.createElementVNode("textarea", {
              "onUpdate:modelValue": _cache[5] || (_cache[5] = ($event) => text.value = $event),
              disabled: __props.isGenerating,
              class: "w-full h-full bg-gray-800 text-white rounded-lg p-4 resize-none focus:outline-none focus:ring-2 focus:ring-blue-500 border border-gray-700 disabled:opacity-50",
              placeholder: "변환할 일본어 텍스트를 입력하세요...\n각 줄이 하나의 음성 파일로 생성됩니다."
            }, null, 8, _hoisted_21$1), [
              [vue.vModelText, text.value]
            ])
          ])
        ]);
      };
    }
  });
  const _hoisted_1$2 = { class: "bg-gray-900 rounded-lg shadow-2xl border border-gray-700 max-w-6xl w-full max-h-[80vh] flex flex-col" };
  const _hoisted_2$2 = { class: "flex-1 flex gap-4 p-6 min-h-0 overflow-hidden" };
  const _hoisted_3$2 = { class: "flex-1 flex flex-col min-h-0" };
  const _hoisted_4$2 = { class: "flex-1 bg-gray-950 rounded border border-gray-700 overflow-hidden" };
  const _hoisted_5$2 = ["value"];
  const _hoisted_6$2 = { class: "flex-1 flex flex-col min-h-0" };
  const _hoisted_7$2 = { class: "flex-1 bg-gray-950 rounded border border-purple-500/30 overflow-hidden" };
  const _hoisted_8$2 = ["value"];
  const _sfc_main$2 = vue.defineComponent({
    __name: "YomiResultModal",
    props: vue.mergeModels({
      show: { type: Boolean }
    }, {
      "originalText": { required: true },
      "originalTextModifiers": {},
      "convertedText": { required: true },
      "convertedTextModifiers": {}
    }),
    emits: vue.mergeModels(["update:show", "copy"], ["update:originalText", "update:convertedText"]),
    setup(__props, { emit: __emit }) {
      const emit = __emit;
      function close() {
        emit("update:show", false);
      }
      function copyOriginal() {
        emit("copy", originalText.value);
      }
      function copyConverted() {
        emit("copy", convertedText.value);
      }
      const originalText = vue.useModel(__props, "originalText");
      const convertedText = vue.useModel(__props, "convertedText");
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createBlock(vue.Transition, {
          "enter-active-class": "transition-opacity duration-200",
          "leave-active-class": "transition-opacity duration-200",
          "enter-from-class": "opacity-0",
          "leave-to-class": "opacity-0"
        }, {
          default: vue.withCtx(() => [
            __props.show ? (vue.openBlock(), vue.createElementBlock("div", {
              key: 0,
              class: "fixed inset-0 bg-black/70 flex items-center justify-center z-50 p-4",
              onClick: vue.withModifiers(close, ["self"])
            }, [
              vue.createElementVNode("div", _hoisted_1$2, [
                vue.createElementVNode("div", { class: "px-6 py-4 border-b border-gray-700 flex items-center justify-between flex-shrink-0" }, [
                  _cache[1] || (_cache[1] = vue.createElementVNode("h2", { class: "text-xl font-bold text-white" }, "독음 변환 결과", -1)),
                  vue.createElementVNode("button", {
                    onClick: close,
                    class: "text-gray-400 hover:text-white transition-colors"
                  }, [..._cache[0] || (_cache[0] = [
                    vue.createElementVNode("svg", {
                      class: "w-6 h-6",
                      fill: "none",
                      stroke: "currentColor",
                      viewBox: "0 0 24 24"
                    }, [
                      vue.createElementVNode("path", {
                        "stroke-linecap": "round",
                        "stroke-linejoin": "round",
                        "stroke-width": "2",
                        d: "M6 18L18 6M6 6l12 12"
                      })
                    ], -1)
                  ])])
                ]),
                vue.createElementVNode("div", _hoisted_2$2, [
                  vue.createElementVNode("div", _hoisted_3$2, [
                    vue.createElementVNode("div", { class: "flex items-center justify-between mb-2" }, [
                      _cache[2] || (_cache[2] = vue.createElementVNode("h3", { class: "text-sm font-semibold text-gray-300" }, "원본 텍스트", -1)),
                      vue.createElementVNode("button", {
                        onClick: copyOriginal,
                        class: "text-xs px-3 py-1 bg-gray-800 hover:bg-gray-700 text-gray-300 rounded transition-colors"
                      }, " 복사 ")
                    ]),
                    vue.createElementVNode("div", _hoisted_4$2, [
                      vue.createElementVNode("textarea", {
                        value: originalText.value,
                        readonly: "",
                        class: "w-full h-full bg-transparent text-sm text-gray-300 font-mono leading-relaxed p-4 resize-none focus:outline-none border-0"
                      }, null, 8, _hoisted_5$2)
                    ])
                  ]),
                  vue.createElementVNode("div", _hoisted_6$2, [
                    vue.createElementVNode("div", { class: "flex items-center justify-between mb-2" }, [
                      _cache[3] || (_cache[3] = vue.createElementVNode("h3", { class: "text-sm font-semibold text-purple-400" }, "변환된 히라가나", -1)),
                      vue.createElementVNode("button", {
                        onClick: copyConverted,
                        class: "text-xs px-3 py-1 bg-purple-600 hover:bg-purple-700 text-white rounded transition-colors"
                      }, " 복사 ")
                    ]),
                    vue.createElementVNode("div", _hoisted_7$2, [
                      vue.createElementVNode("textarea", {
                        value: convertedText.value,
                        readonly: "",
                        class: "w-full h-full bg-transparent text-sm text-purple-300 font-mono leading-relaxed p-4 resize-none focus:outline-none border-0"
                      }, null, 8, _hoisted_8$2)
                    ])
                  ])
                ]),
                vue.createElementVNode("div", { class: "px-6 py-4 border-t border-gray-700 flex justify-end flex-shrink-0" }, [
                  vue.createElementVNode("button", {
                    onClick: close,
                    class: "px-6 py-2 bg-gray-800 hover:bg-gray-700 text-white rounded-lg font-medium transition-colors"
                  }, " 닫기 ")
                ])
              ])
            ])) : vue.createCommentVNode("", true)
          ]),
          _: 1
        });
      };
    }
  });
  const _hoisted_1$1 = { class: "w-full h-full flex flex-col bg-gray-950 overflow-hidden" };
  const _hoisted_2$1 = { class: "flex-1 flex flex-col p-6 min-h-0 overflow-hidden" };
  const _hoisted_3$1 = { class: "flex-shrink-0 mb-6" };
  const _hoisted_4$1 = { class: "flex items-center justify-between bg-gray-900 rounded-lg p-4 border border-gray-800" };
  const _hoisted_5$1 = { class: "flex items-center gap-3" };
  const _hoisted_6$1 = { class: "text-sm font-medium text-gray-200" };
  const _hoisted_7$1 = { class: "text-xs text-gray-400" };
  const _hoisted_8$1 = ["disabled"];
  const _hoisted_9$1 = { class: "flex-1 flex gap-6 min-h-0 overflow-hidden" };
  const _hoisted_10$1 = { class: "mt-6 flex gap-4 justify-end flex-shrink-0" };
  const _hoisted_11$1 = ["disabled"];
  const _hoisted_12$1 = ["disabled"];
  const _sfc_main$1 = vue.defineComponent({
    __name: "TtsSubtitle",
    setup(__props) {
      const settingsStore = useSettingsStore();
      const { voicevoxServerUrl, selectedSpeakerId, speakers, useYomiConversion, subtitleFormat, aiApiKeys, selectedAiModel } = storeToRefs(settingsStore);
      const { logs, addLog, clearLogs } = useLogs();
      const { isGenerating, isServerConnected, generateAllTTS: performTtsGeneration } = useTtsGeneration(settingsStore, addLog);
      const text = vue.ref("");
      const isCheckingServer = vue.ref(false);
      const audioBlobs = vue.ref([]);
      const subtitles = vue.ref([]);
      const mergedBlob = vue.ref(null);
      const showYomiModal = vue.ref(false);
      const originalText = vue.ref("");
      const convertedYomiText = vue.ref("");
      const lineCount = vue.computed(() => {
        if (!text.value.trim()) return 0;
        return text.value.split("\n").map((line) => line.trim()).filter((line) => line.length > 0).length;
      });
      const speakerOptions = vue.computed(() => {
        const options = [];
        speakers.value.forEach((speaker) => {
          speaker.styles.forEach((style) => {
            options.push({ label: `${speaker.name} (${style.name})`, value: style.id });
          });
        });
        return options;
      });
      const currentAiApiKey = vue.computed(() => {
        const provider = getProviderFromModel(selectedAiModel.value);
        return aiApiKeys.value[provider] || "";
      });
      const currentAiModelLabel = vue.computed(() => {
        const model = AI_MODELS.find((m) => m.id === selectedAiModel.value);
        return model?.label || selectedAiModel.value;
      });
      function reset() {
        text.value = "";
        clearLogs();
        originalText.value = "";
        convertedYomiText.value = "";
        audioBlobs.value = [];
        subtitles.value = [];
        mergedBlob.value = null;
      }
      async function downloadIndividualAudio() {
        if (audioBlobs.value.length === 0) {
          addLog("❌ 다운로드 오류: 생성된 음성 파일이 없습니다.");
          return;
        }
        addLog("📦 개별 음성 파일 압축 중...");
        const zip = new JSZip();
        audioBlobs.value.forEach(({ filename: filename2, blob }) => {
          zip.file(filename2, blob);
        });
        const zipBlob = await zip.generateAsync({ type: "blob" });
        const timestamp = ( new Date()).toISOString().replace(/[:.]/g, "-").substring(0, 19);
        const filename = `tts_individual_${timestamp}.zip`;
        FileSaver_minExports.saveAs(zipBlob, filename);
        addLog(`📥 개별 음성 다운로드 완료: ${filename}`);
      }
      async function downloadMergedAudio() {
        if (!mergedBlob.value) {
          addLog("❌ 다운로드 오류: 병합된 음성 파일이 없습니다.");
          return;
        }
        const timestamp = ( new Date()).toISOString().replace(/[:.]/g, "-").substring(0, 19);
        const filename = `tts_merged_${timestamp}.wav`;
        FileSaver_minExports.saveAs(mergedBlob.value, filename);
        addLog(`📥 이어진 음성 다운로드 완료: ${filename}`);
      }
      async function downloadSubtitles() {
        if (subtitles.value.length === 0) {
          addLog("❌ 다운로드 오류: 생성된 자막 파일이 없습니다.");
          return;
        }
        const timestamp = ( new Date()).toISOString().replace(/[:.]/g, "-").substring(0, 19);
        if (subtitles.value.length === 1) {
          const { filename, content } = subtitles.value[0];
          const blob = new Blob([content], { type: "text/plain;charset=utf-8" });
          const ext = filename.split(".").pop();
          FileSaver_minExports.saveAs(blob, `subtitle_${timestamp}.${ext}`);
          addLog(`📥 자막 다운로드 완료: subtitle_${timestamp}.${ext}`);
        } else {
          addLog("📦 자막 파일 압축 중...");
          const zip = new JSZip();
          subtitles.value.forEach(({ filename: filename2, content }) => {
            zip.file(filename2, content);
          });
          const zipBlob = await zip.generateAsync({ type: "blob" });
          const filename = `subtitles_${timestamp}.zip`;
          FileSaver_minExports.saveAs(zipBlob, filename);
          addLog(`📥 자막 다운로드 완료: ${filename}`);
        }
      }
      function copyToClipboard(copyText) {
        navigator.clipboard.writeText(copyText).then(() => {
          addLog("📋 클립보드에 복사되었습니다.");
        }).catch(() => {
          addLog("❌ 클립보드 복사 실패");
        });
      }
      async function checkConnection() {
        isCheckingServer.value = true;
        addLog("🔄 VOICEVOX 서버 연결 확인 중...");
        try {
          const connected = await checkServerStatus(voicevoxServerUrl.value);
          if (connected) {
            isServerConnected.value = true;
            addLog("✅ VOICEVOX 서버 연결 성공");
            const success = await settingsStore.fetchSpeakers();
            if (success) {
              addLog(`✅ ${speakers.value.length}개의 음성을 불러왔습니다.`);
            } else {
              addLog("❌ 음성 목록 로드 실패");
            }
          } else {
            isServerConnected.value = false;
            addLog("❌ VOICEVOX 서버에 연결할 수 없습니다.");
            addLog(`   서버 주소: ${voicevoxServerUrl.value}`);
            addLog("   VOICEVOX가 실행 중인지 확인해주세요.");
          }
        } catch (error) {
          isServerConnected.value = false;
          addLog("❌ 연결 확인 중 오류 발생");
        } finally {
          isCheckingServer.value = false;
        }
      }
      async function generateAllTTS() {
        if (!text.value.trim()) {
          alert("텍스트를 입력해주세요.");
          return;
        }
        clearLogs();
        try {
          const result = await performTtsGeneration(text.value);
          if (result) {
            audioBlobs.value = result.audioBlobs;
            subtitles.value = result.subtitles;
            mergedBlob.value = result.mergedBlob;
            if (result.originalText && result.convertedYomiText) {
              originalText.value = result.originalText;
              convertedYomiText.value = result.convertedYomiText;
            }
          }
        } catch (error) {
          const errorMessage = error instanceof Error ? error.message : String(error);
          addLog(`❌ 오류 발생: ${errorMessage}`);
          alert(errorMessage);
        }
      }
      vue.onMounted(async () => {
        await checkConnection();
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$1, [
          vue.createElementVNode("div", _hoisted_2$1, [
            vue.createElementVNode("div", _hoisted_3$1, [
              _cache[6] || (_cache[6] = vue.createElementVNode("h1", { class: "text-3xl font-bold text-white mb-4" }, "TTS 자막 변환", -1)),
              vue.createElementVNode("div", _hoisted_4$1, [
                vue.createElementVNode("div", _hoisted_5$1, [
                  vue.createElementVNode("div", {
                    class: vue.normalizeClass([
                      "w-3 h-3 rounded-full",
                      vue.unref(isServerConnected) ? "bg-green-500 animate-pulse" : "bg-red-500"
                    ])
                  }, null, 2),
                  vue.createElementVNode("div", null, [
                    vue.createElementVNode("div", _hoisted_6$1, vue.toDisplayString(vue.unref(isServerConnected) ? "VOICEVOX 서버 연결됨" : "VOICEVOX 서버 연결 안 됨"), 1),
                    vue.createElementVNode("div", _hoisted_7$1, vue.toDisplayString(vue.unref(voicevoxServerUrl)), 1)
                  ])
                ]),
                vue.createElementVNode("button", {
                  onClick: checkConnection,
                  disabled: isCheckingServer.value || vue.unref(isGenerating),
                  class: "px-4 py-2 bg-gray-800 hover:bg-gray-700 text-white rounded-lg text-sm font-medium transition-colors border border-gray-700 disabled:opacity-50 disabled:cursor-not-allowed"
                }, vue.toDisplayString(isCheckingServer.value ? "확인 중..." : "재접속"), 9, _hoisted_8$1)
              ])
            ]),
            vue.createElementVNode("div", _hoisted_9$1, [
              vue.createVNode(_sfc_main$3, {
                modelValue: text.value,
                "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => text.value = $event),
                selectedSpeakerId: vue.unref(selectedSpeakerId),
                "onUpdate:selectedSpeakerId": _cache[1] || (_cache[1] = ($event) => vue.isRef(selectedSpeakerId) ? selectedSpeakerId.value = $event : null),
                useYomiConversion: vue.unref(useYomiConversion),
                "onUpdate:useYomiConversion": _cache[2] || (_cache[2] = ($event) => vue.isRef(useYomiConversion) ? useYomiConversion.value = $event : null),
                subtitleFormat: vue.unref(subtitleFormat),
                "onUpdate:subtitleFormat": _cache[3] || (_cache[3] = ($event) => vue.isRef(subtitleFormat) ? subtitleFormat.value = $event : null),
                lineCount: lineCount.value,
                speakerOptions: speakerOptions.value,
                currentAiApiKey: currentAiApiKey.value,
                currentAiModelLabel: currentAiModelLabel.value,
                isGenerating: vue.unref(isGenerating)
              }, null, 8, ["modelValue", "selectedSpeakerId", "useYomiConversion", "subtitleFormat", "lineCount", "speakerOptions", "currentAiApiKey", "currentAiModelLabel", "isGenerating"]),
              vue.createVNode(_sfc_main$4, { logs: vue.unref(logs) }, null, 8, ["logs"])
            ]),
            vue.createElementVNode("div", _hoisted_10$1, [
              convertedYomiText.value ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 0,
                onClick: _cache[4] || (_cache[4] = ($event) => showYomiModal.value = true),
                class: "px-6 py-2.5 bg-purple-600 hover:bg-purple-700 text-white rounded-lg font-medium transition-colors shadow-lg"
              }, " 🔍 변환 결과 보기 ")) : vue.createCommentVNode("", true),
              audioBlobs.value.length > 0 ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 1,
                onClick: downloadIndividualAudio,
                class: "px-6 py-2.5 bg-green-600 hover:bg-green-700 text-white rounded-lg font-medium transition-colors shadow-lg"
              }, " 📥 따로 받기 ")) : vue.createCommentVNode("", true),
              mergedBlob.value ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 2,
                onClick: downloadMergedAudio,
                class: "px-6 py-2.5 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-medium transition-colors shadow-lg"
              }, " 🎵 합쳐 받기 ")) : vue.createCommentVNode("", true),
              subtitles.value.length > 0 ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 3,
                onClick: downloadSubtitles,
                class: "px-6 py-2.5 bg-yellow-600 hover:bg-yellow-700 text-white rounded-lg font-medium transition-colors shadow-lg"
              }, " 📄 자막 ")) : vue.createCommentVNode("", true),
              vue.createElementVNode("button", {
                onClick: reset,
                disabled: vue.unref(isGenerating),
                class: "px-6 py-2.5 bg-gray-800 hover:bg-gray-700 text-white rounded-lg font-medium transition-colors shadow-lg disabled:opacity-50"
              }, " 초기화 ", 8, _hoisted_11$1),
              vue.createElementVNode("button", {
                onClick: generateAllTTS,
                disabled: vue.unref(isGenerating) || !text.value.trim() || speakerOptions.value.length === 0,
                class: "px-8 py-2.5 bg-indigo-600 hover:bg-indigo-700 text-white rounded-lg font-medium transition-colors shadow-lg disabled:opacity-50"
              }, vue.toDisplayString(vue.unref(isGenerating) ? "생성 중..." : "TTS 생성"), 9, _hoisted_12$1)
            ])
          ]),
          vue.createVNode(_sfc_main$2, {
            show: showYomiModal.value,
            "onUpdate:show": _cache[5] || (_cache[5] = ($event) => showYomiModal.value = $event),
            originalText: originalText.value,
            convertedText: convertedYomiText.value,
            onCopy: copyToClipboard
          }, null, 8, ["show", "originalText", "convertedText"])
        ]);
      };
    }
  });
  const _hoisted_1 = { class: "w-full h-full flex flex-col bg-gray-950 overflow-auto" };
  const _hoisted_2 = { class: "flex-1 p-8" };
  const _hoisted_3 = { class: "max-w-4xl mx-auto" };
  const _hoisted_4 = { class: "space-y-6" };
  const _hoisted_5 = { class: "bg-gray-900 rounded-lg shadow-xl border border-gray-800 p-6" };
  const _hoisted_6 = { class: "space-y-4" };
  const _hoisted_7 = ["value"];
  const _hoisted_8 = { key: 0 };
  const _hoisted_9 = { key: 1 };
  const _hoisted_10 = { key: 2 };
  const _hoisted_11 = { class: "bg-gray-900 rounded-lg shadow-xl border border-gray-800 p-6" };
  const _hoisted_12 = { class: "space-y-4" };
  const _hoisted_13 = { class: "flex gap-2" };
  const _hoisted_14 = ["disabled"];
  const _hoisted_15 = { class: "flex items-start gap-3" };
  const _hoisted_16 = { class: "flex-shrink-0 mt-0.5" };
  const _hoisted_17 = {
    key: 0,
    class: "w-5 h-5 border-2 border-blue-400 border-t-transparent rounded-full animate-spin"
  };
  const _hoisted_18 = {
    key: 1,
    class: "w-5 h-5 rounded-full bg-green-500 flex items-center justify-center text-white text-xs"
  };
  const _hoisted_19 = {
    key: 2,
    class: "w-5 h-5 rounded-full bg-red-500 flex items-center justify-center text-white text-xs"
  };
  const _hoisted_20 = { class: "flex-1" };
  const _hoisted_21 = { class: "bg-gray-900 rounded-lg shadow-xl border border-gray-800 p-6" };
  const _hoisted_22 = { class: "space-y-4" };
  const _hoisted_23 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_24 = { key: 0 };
  const _hoisted_25 = { class: "block text-sm font-medium text-gray-300 mb-2" };
  const _hoisted_26 = { class: "flex gap-4" };
  const _hoisted_27 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_28 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_29 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_30 = { class: "block text-sm font-medium text-gray-300 mb-2" };
  const _hoisted_31 = { class: "space-y-2" };
  const _hoisted_32 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_33 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_34 = { class: "flex items-center text-sm text-gray-300 cursor-pointer" };
  const _hoisted_35 = { key: 1 };
  const _hoisted_36 = { class: "block text-sm font-medium text-gray-300 mb-2" };
  const _hoisted_37 = {
    key: 0,
    class: "fixed bottom-6 right-6 px-6 py-3 bg-green-600 text-white rounded-lg shadow-2xl text-sm font-medium flex items-center gap-2 z-50"
  };
  const _hoisted_38 = { class: "bg-gray-900 rounded-lg shadow-2xl border border-gray-700 max-w-6xl w-full max-h-[80vh] flex flex-col" };
  const _hoisted_39 = { class: "px-6 py-4 border-b border-gray-700 flex items-center justify-between flex-shrink-0" };
  const _hoisted_40 = { class: "flex-1 p-6 min-h-0 overflow-hidden flex flex-col" };
  const _hoisted_41 = { class: "flex items-center justify-between mb-2" };
  const _hoisted_42 = { class: "text-sm font-semibold text-orange-400" };
  const _hoisted_43 = { class: "flex-1 bg-gray-950 rounded border border-orange-500/30 overflow-hidden" };
  const _hoisted_44 = ["value"];
  const _hoisted_45 = { class: "px-6 py-4 border-t border-gray-700 flex justify-between items-center flex-shrink-0" };
  const _sfc_main = vue.defineComponent({
    __name: "Settings",
    setup(__props) {
      const settingsStore = useSettingsStore();
      const { aiApiKeys, selectedAiModel, voicevoxServerUrl, useYomiConversion, subtitleFormat, ttsSpeed, audioOutputFormat, mergedAudioGap, yomiChunkSize } = storeToRefs(settingsStore);
      const currentProvider = vue.computed(() => {
        return getProviderFromModel(selectedAiModel.value);
      });
      const showSuccess = vue.ref(false);
      const testStatus = vue.ref("idle");
      const testMessage = vue.ref("");
      const testDetails = vue.ref("");
      const showDebugModal = vue.ref(false);
      const generateLargeJapaneseText = () => {
        const sampleLines = [
          "私は七十八歳の田中ヨシコです。四十年前まで東京で会社を経営していました。",
          "今日は天気が良いので、公園を散歩しています。桜の花が綺麗に咲いています。",
          "昨日、友達と一緒に映画を見に行きました。とても面白かったです。",
          "来週、家族で温泉旅行に行く予定です。楽しみにしています。",
          "最近、新しい趣味として写真撮影を始めました。カメラの使い方を勉強中です。",
          "子供の頃、祖母が作ってくれたお菓子の味が今でも忘れられません。",
          "毎朝六時に起きて、近所をジョギングしています。健康のためです。",
          "図書館で本を借りて読むのが好きです。歴史の本をよく読みます。",
          "料理を作るのが趣味で、週末は新しいレシピに挑戦しています。",
          "夏になったら、海に行ってみたいです。泳ぐのが好きです。"
        ];
        let result = "";
        for (let i = 1; i <= 450; i++) {
          const line = sampleLines[i % sampleLines.length];
          result += `${i}. ${line}
`;
        }
        return result;
      };
      const debugSampleText = vue.ref("");
      const debugLineCount = vue.ref(0);
      async function saveSettings() {
        await settingsStore.saveToStorage();
        showSuccess.value = true;
        setTimeout(() => {
          showSuccess.value = false;
        }, 3e3);
      }
      async function testVoicevoxConnection() {
        testStatus.value = "testing";
        testMessage.value = "연결 중...";
        testDetails.value = "";
        try {
          console.log("[Settings] VOICEVOX 접속 테스트 시작:", voicevoxServerUrl.value);
          const speakers = await fetchSpeakers(voicevoxServerUrl.value);
          console.log("[Settings] 테스트 성공, 음성 개수:", speakers.length);
          const totalStyles = speakers.reduce((sum, speaker) => sum + speaker.styles.length, 0);
          testStatus.value = "success";
          testMessage.value = "✅ 연결 성공!";
          testDetails.value = `${speakers.length}개의 캐릭터, 총 ${totalStyles}개의 음성 스타일을 찾았습니다.`;
          setTimeout(() => {
            testStatus.value = "idle";
          }, 5e3);
        } catch (error) {
          console.error("[Settings] 테스트 실패:", error);
          testStatus.value = "error";
          testMessage.value = "❌ 연결 실패";
          const errorMessage = error instanceof Error ? error.message : String(error);
          testDetails.value = `오류: ${errorMessage}

확인사항:
1. VOICEVOX가 실행 중인가요?
2. 서버 주소가 올바른가요? (${voicevoxServerUrl.value})
3. 방화벽이 차단하고 있지 않나요?`;
          setTimeout(() => {
            testStatus.value = "idle";
          }, 8e3);
        }
      }
      function openDebugModal() {
        const text = generateLargeJapaneseText();
        debugSampleText.value = text;
        debugLineCount.value = text.split("\n").filter((line) => line.trim()).length;
        showDebugModal.value = true;
      }
      function copyDebugText() {
        navigator.clipboard.writeText(debugSampleText.value).then(() => {
          alert("클립보드에 복사되었습니다.");
        }).catch((err) => {
          console.error("클립보드 복사 실패:", err);
          alert("클립보드 복사 실패");
        });
      }
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", _hoisted_1, [
          vue.createElementVNode("div", _hoisted_2, [
            vue.createElementVNode("div", _hoisted_3, [
              _cache[49] || (_cache[49] = vue.createElementVNode("div", { class: "mb-6" }, [
                vue.createElementVNode("h1", { class: "text-3xl font-bold text-white" }, "설정")
              ], -1)),
              vue.createElementVNode("div", _hoisted_4, [
                vue.createElementVNode("div", _hoisted_5, [
                  _cache[26] || (_cache[26] = vue.createElementVNode("h2", { class: "text-xl font-semibold mb-4 text-gray-200" }, "AI 모델 설정", -1)),
                  vue.createElementVNode("div", _hoisted_6, [
                    vue.createElementVNode("div", null, [
                      _cache[18] || (_cache[18] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " AI 모델 선택 ", -1)),
                      vue.withDirectives(vue.createElementVNode("select", {
                        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => vue.isRef(selectedAiModel) ? selectedAiModel.value = $event : null),
                        class: "w-full bg-gray-800 text-white rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-blue-500 border border-gray-700"
                      }, [
                        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(vue.unref(AI_MODELS), (model) => {
                          return vue.openBlock(), vue.createElementBlock("option", {
                            key: model.id,
                            value: model.id
                          }, vue.toDisplayString(model.label), 9, _hoisted_7);
                        }), 128))
                      ], 512), [
                        [vue.vModelSelect, vue.unref(selectedAiModel)]
                      ]),
                      _cache[19] || (_cache[19] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " 일본어 독음 변환에 사용할 AI 모델을 선택하세요. ", -1))
                    ]),
                    currentProvider.value === "gemini" ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_8, [
                      _cache[20] || (_cache[20] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " Gemini API Key ", -1)),
                      vue.withDirectives(vue.createElementVNode("input", {
                        "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => vue.unref(aiApiKeys).gemini = $event),
                        type: "password",
                        class: "w-full bg-gray-800 text-white rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-blue-500 border border-gray-700",
                        placeholder: "AIza..."
                      }, null, 512), [
                        [vue.vModelText, vue.unref(aiApiKeys).gemini]
                      ]),
                      _cache[21] || (_cache[21] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " API 키는 브라우저 스토리지에 안전하게 저장됩니다. ", -1))
                    ])) : vue.createCommentVNode("", true),
                    currentProvider.value === "claude" ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_9, [
                      _cache[22] || (_cache[22] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " Claude API Key ", -1)),
                      vue.withDirectives(vue.createElementVNode("input", {
                        "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => vue.unref(aiApiKeys).claude = $event),
                        type: "password",
                        class: "w-full bg-gray-800 text-white rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-blue-500 border border-gray-700",
                        placeholder: "sk-ant-..."
                      }, null, 512), [
                        [vue.vModelText, vue.unref(aiApiKeys).claude]
                      ]),
                      _cache[23] || (_cache[23] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " API 키는 브라우저 스토리지에 안전하게 저장됩니다. ", -1))
                    ])) : vue.createCommentVNode("", true),
                    currentProvider.value === "openai" ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_10, [
                      _cache[24] || (_cache[24] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " OpenAI API Key ", -1)),
                      vue.withDirectives(vue.createElementVNode("input", {
                        "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => vue.unref(aiApiKeys).openai = $event),
                        type: "password",
                        class: "w-full bg-gray-800 text-white rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-blue-500 border border-gray-700",
                        placeholder: "sk-..."
                      }, null, 512), [
                        [vue.vModelText, vue.unref(aiApiKeys).openai]
                      ]),
                      _cache[25] || (_cache[25] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " API 키는 브라우저 스토리지에 안전하게 저장됩니다. ", -1))
                    ])) : vue.createCommentVNode("", true)
                  ])
                ]),
                vue.createElementVNode("div", _hoisted_11, [
                  _cache[29] || (_cache[29] = vue.createElementVNode("h2", { class: "text-xl font-semibold mb-4 text-gray-200" }, "VOICEVOX 설정", -1)),
                  vue.createElementVNode("div", _hoisted_12, [
                    vue.createElementVNode("div", null, [
                      _cache[27] || (_cache[27] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " 서버 URL ", -1)),
                      vue.createElementVNode("div", _hoisted_13, [
                        vue.withDirectives(vue.createElementVNode("input", {
                          "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => vue.isRef(voicevoxServerUrl) ? voicevoxServerUrl.value = $event : null),
                          type: "text",
                          class: "flex-1 bg-gray-800 text-white rounded-lg px-4 py-2.5 focus:outline-none focus:ring-2 focus:ring-blue-500 border border-gray-700",
                          placeholder: "http://localhost:50021"
                        }, null, 512), [
                          [vue.vModelText, vue.unref(voicevoxServerUrl)]
                        ]),
                        vue.createElementVNode("button", {
                          onClick: testVoicevoxConnection,
                          disabled: testStatus.value === "testing",
                          class: "px-4 py-2.5 bg-purple-600 hover:bg-purple-700 text-white rounded-lg font-medium transition-colors disabled:opacity-50 disabled:cursor-not-allowed whitespace-nowrap"
                        }, vue.toDisplayString(testStatus.value === "testing" ? "테스트 중..." : "접속 테스트"), 9, _hoisted_14)
                      ]),
                      _cache[28] || (_cache[28] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " VOICEVOX 서버 주소를 입력하세요. 기본값: http://localhost:50021 ", -1))
                    ]),
                    vue.createVNode(vue.Transition, {
                      "enter-active-class": "transition-all duration-300",
                      "leave-active-class": "transition-all duration-300",
                      "enter-from-class": "opacity-0 -translate-y-2",
                      "leave-to-class": "opacity-0 -translate-y-2"
                    }, {
                      default: vue.withCtx(() => [
                        testStatus.value !== "idle" ? (vue.openBlock(), vue.createElementBlock("div", {
                          key: 0,
                          class: vue.normalizeClass(["p-4 rounded-lg border", {
                            "bg-blue-900/20 border-blue-700": testStatus.value === "testing",
                            "bg-green-900/20 border-green-700": testStatus.value === "success",
                            "bg-red-900/20 border-red-700": testStatus.value === "error"
                          }])
                        }, [
                          vue.createElementVNode("div", _hoisted_15, [
                            vue.createElementVNode("div", _hoisted_16, [
                              testStatus.value === "testing" ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_17)) : testStatus.value === "success" ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_18, " ✓ ")) : testStatus.value === "error" ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_19, " ✕ ")) : vue.createCommentVNode("", true)
                            ]),
                            vue.createElementVNode("div", _hoisted_20, [
                              vue.createElementVNode("p", {
                                class: vue.normalizeClass(["font-semibold mb-1", {
                                  "text-blue-300": testStatus.value === "testing",
                                  "text-green-300": testStatus.value === "success",
                                  "text-red-300": testStatus.value === "error"
                                }])
                              }, vue.toDisplayString(testMessage.value), 3),
                              testDetails.value ? (vue.openBlock(), vue.createElementBlock("p", {
                                key: 0,
                                class: vue.normalizeClass(["text-sm whitespace-pre-line", {
                                  "text-blue-200": testStatus.value === "testing",
                                  "text-green-200": testStatus.value === "success",
                                  "text-red-200": testStatus.value === "error"
                                }])
                              }, vue.toDisplayString(testDetails.value), 3)) : vue.createCommentVNode("", true)
                            ])
                          ])
                        ], 2)) : vue.createCommentVNode("", true)
                      ]),
                      _: 1
                    })
                  ])
                ]),
                vue.createElementVNode("div", _hoisted_21, [
                  _cache[45] || (_cache[45] = vue.createElementVNode("h2", { class: "text-xl font-semibold mb-4 text-gray-200" }, "TTS 생성 설정", -1)),
                  vue.createElementVNode("div", _hoisted_22, [
                    vue.createElementVNode("div", null, [
                      vue.createElementVNode("label", _hoisted_23, [
                        vue.withDirectives(vue.createElementVNode("input", {
                          type: "checkbox",
                          "onUpdate:modelValue": _cache[5] || (_cache[5] = ($event) => vue.isRef(useYomiConversion) ? useYomiConversion.value = $event : null),
                          class: "mr-3 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 rounded focus:ring-blue-500 focus:ring-2"
                        }, null, 512), [
                          [vue.vModelCheckbox, vue.unref(useYomiConversion)]
                        ]),
                        _cache[30] || (_cache[30] = vue.createElementVNode("span", null, "일본어 독음 변환 기본 사용 (한자 → 히라가나)", -1))
                      ]),
                      _cache[31] || (_cache[31] = vue.createElementVNode("p", { class: "mt-2 ml-7 text-xs text-gray-400" }, " 일본어 한자를 히라가나로 자동 변환하여 더 정확한 발음으로 TTS를 생성합니다. ", -1))
                    ]),
                    vue.unref(useYomiConversion) ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_24, [
                      vue.createElementVNode("label", _hoisted_25, " 독음 변환 청크 크기: " + vue.toDisplayString(vue.unref(yomiChunkSize)) + "줄 ", 1),
                      vue.withDirectives(vue.createElementVNode("input", {
                        type: "range",
                        "onUpdate:modelValue": _cache[6] || (_cache[6] = ($event) => vue.isRef(yomiChunkSize) ? yomiChunkSize.value = $event : null),
                        min: "10",
                        max: "200",
                        step: "10",
                        class: "w-full h-2 bg-gray-700 rounded-lg appearance-none cursor-pointer accent-blue-500"
                      }, null, 512), [
                        [
                          vue.vModelText,
                          vue.unref(yomiChunkSize),
                          void 0,
                          { number: true }
                        ]
                      ]),
                      _cache[32] || (_cache[32] = vue.createElementVNode("div", { class: "flex justify-between text-xs text-gray-400 mt-1" }, [
                        vue.createElementVNode("span", null, "10줄 (안정적)"),
                        vue.createElementVNode("span", null, "50줄 (기본)"),
                        vue.createElementVNode("span", null, "200줄 (빠름)")
                      ], -1)),
                      _cache[33] || (_cache[33] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " 한 번에 처리할 줄 수를 설정합니다. 작을수록 안정적이지만 느리고, 클수록 빠르지만 타임아웃 위험이 있습니다. ", -1))
                    ])) : vue.createCommentVNode("", true),
                    vue.createElementVNode("div", null, [
                      _cache[37] || (_cache[37] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " 기본 자막 형식 ", -1)),
                      vue.createElementVNode("div", _hoisted_26, [
                        vue.createElementVNode("label", _hoisted_27, [
                          vue.withDirectives(vue.createElementVNode("input", {
                            type: "radio",
                            "onUpdate:modelValue": _cache[7] || (_cache[7] = ($event) => vue.isRef(subtitleFormat) ? subtitleFormat.value = $event : null),
                            value: "srt",
                            class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2"
                          }, null, 512), [
                            [vue.vModelRadio, vue.unref(subtitleFormat)]
                          ]),
                          _cache[34] || (_cache[34] = vue.createTextVNode(" SRT ", -1))
                        ]),
                        vue.createElementVNode("label", _hoisted_28, [
                          vue.withDirectives(vue.createElementVNode("input", {
                            type: "radio",
                            "onUpdate:modelValue": _cache[8] || (_cache[8] = ($event) => vue.isRef(subtitleFormat) ? subtitleFormat.value = $event : null),
                            value: "lrc",
                            class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2"
                          }, null, 512), [
                            [vue.vModelRadio, vue.unref(subtitleFormat)]
                          ]),
                          _cache[35] || (_cache[35] = vue.createTextVNode(" LRC ", -1))
                        ]),
                        vue.createElementVNode("label", _hoisted_29, [
                          vue.withDirectives(vue.createElementVNode("input", {
                            type: "radio",
                            "onUpdate:modelValue": _cache[9] || (_cache[9] = ($event) => vue.isRef(subtitleFormat) ? subtitleFormat.value = $event : null),
                            value: "both",
                            class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2"
                          }, null, 512), [
                            [vue.vModelRadio, vue.unref(subtitleFormat)]
                          ]),
                          _cache[36] || (_cache[36] = vue.createTextVNode(" 둘 다 ", -1))
                        ])
                      ]),
                      _cache[38] || (_cache[38] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " TTS 생성 시 함께 생성할 자막 파일 형식을 선택하세요. ", -1))
                    ]),
                    vue.createElementVNode("div", null, [
                      vue.createElementVNode("label", _hoisted_30, " TTS 속도: " + vue.toDisplayString(vue.unref(ttsSpeed).toFixed(1)) + "x ", 1),
                      vue.withDirectives(vue.createElementVNode("input", {
                        type: "range",
                        "onUpdate:modelValue": _cache[10] || (_cache[10] = ($event) => vue.isRef(ttsSpeed) ? ttsSpeed.value = $event : null),
                        min: "0.5",
                        max: "2.0",
                        step: "0.1",
                        class: "w-full h-2 bg-gray-700 rounded-lg appearance-none cursor-pointer accent-blue-500"
                      }, null, 512), [
                        [
                          vue.vModelText,
                          vue.unref(ttsSpeed),
                          void 0,
                          { number: true }
                        ]
                      ]),
                      _cache[39] || (_cache[39] = vue.createElementVNode("div", { class: "flex justify-between text-xs text-gray-400 mt-1" }, [
                        vue.createElementVNode("span", null, "0.5x (느리게)"),
                        vue.createElementVNode("span", null, "1.0x (보통)"),
                        vue.createElementVNode("span", null, "2.0x (빠르게)")
                      ], -1))
                    ]),
                    vue.createElementVNode("div", null, [
                      _cache[43] || (_cache[43] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " 음성 파일 출력 형식 ", -1)),
                      vue.createElementVNode("div", _hoisted_31, [
                        vue.createElementVNode("label", _hoisted_32, [
                          vue.withDirectives(vue.createElementVNode("input", {
                            type: "radio",
                            "onUpdate:modelValue": _cache[11] || (_cache[11] = ($event) => vue.isRef(audioOutputFormat) ? audioOutputFormat.value = $event : null),
                            value: "individual",
                            class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2"
                          }, null, 512), [
                            [vue.vModelRadio, vue.unref(audioOutputFormat)]
                          ]),
                          _cache[40] || (_cache[40] = vue.createTextVNode(" 개별 파일만 (001.wav, 002.wav, 003.wav...) ", -1))
                        ]),
                        vue.createElementVNode("label", _hoisted_33, [
                          vue.withDirectives(vue.createElementVNode("input", {
                            type: "radio",
                            "onUpdate:modelValue": _cache[12] || (_cache[12] = ($event) => vue.isRef(audioOutputFormat) ? audioOutputFormat.value = $event : null),
                            value: "merged",
                            class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2"
                          }, null, 512), [
                            [vue.vModelRadio, vue.unref(audioOutputFormat)]
                          ]),
                          _cache[41] || (_cache[41] = vue.createTextVNode(" 합친 파일만 (merged.wav) ", -1))
                        ]),
                        vue.createElementVNode("label", _hoisted_34, [
                          vue.withDirectives(vue.createElementVNode("input", {
                            type: "radio",
                            "onUpdate:modelValue": _cache[13] || (_cache[13] = ($event) => vue.isRef(audioOutputFormat) ? audioOutputFormat.value = $event : null),
                            value: "both",
                            class: "mr-2 w-4 h-4 text-blue-600 bg-gray-800 border-gray-600 focus:ring-blue-500 focus:ring-2"
                          }, null, 512), [
                            [vue.vModelRadio, vue.unref(audioOutputFormat)]
                          ]),
                          _cache[42] || (_cache[42] = vue.createTextVNode(" 둘 다 포함 (개별 + merged.wav) ", -1))
                        ])
                      ])
                    ]),
                    vue.unref(audioOutputFormat) === "merged" || vue.unref(audioOutputFormat) === "both" ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_35, [
                      vue.createElementVNode("label", _hoisted_36, " 합친 파일 줄 사이 간격: " + vue.toDisplayString(vue.unref(mergedAudioGap).toFixed(1)) + "초 ", 1),
                      vue.withDirectives(vue.createElementVNode("input", {
                        type: "range",
                        "onUpdate:modelValue": _cache[14] || (_cache[14] = ($event) => vue.isRef(mergedAudioGap) ? mergedAudioGap.value = $event : null),
                        min: "0",
                        max: "2.0",
                        step: "0.1",
                        class: "w-full h-2 bg-gray-700 rounded-lg appearance-none cursor-pointer accent-blue-500"
                      }, null, 512), [
                        [
                          vue.vModelText,
                          vue.unref(mergedAudioGap),
                          void 0,
                          { number: true }
                        ]
                      ]),
                      _cache[44] || (_cache[44] = vue.createElementVNode("div", { class: "flex justify-between text-xs text-gray-400 mt-1" }, [
                        vue.createElementVNode("span", null, "0초 (바로 이어서)"),
                        vue.createElementVNode("span", null, "1.0초"),
                        vue.createElementVNode("span", null, "2.0초")
                      ], -1))
                    ])) : vue.createCommentVNode("", true)
                  ])
                ]),
                vue.createElementVNode("div", { class: "bg-gray-900 rounded-lg shadow-xl border border-gray-800 p-6" }, [
                  _cache[48] || (_cache[48] = vue.createElementVNode("h2", { class: "text-xl font-semibold mb-4 text-gray-200" }, "디버그", -1)),
                  vue.createElementVNode("div", { class: "space-y-4" }, [
                    vue.createElementVNode("div", null, [
                      _cache[46] || (_cache[46] = vue.createElementVNode("label", { class: "block text-sm font-medium text-gray-300 mb-2" }, " 모달 렌더링 테스트 ", -1)),
                      vue.createElementVNode("button", {
                        onClick: openDebugModal,
                        class: "px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white rounded-lg font-medium transition-colors"
                      }, " 🔍 400줄+ 일본어 샘플 보기 "),
                      _cache[47] || (_cache[47] = vue.createElementVNode("p", { class: "mt-2 text-xs text-gray-400" }, " 대용량 텍스트 모달 렌더링 성능을 테스트합니다. ", -1))
                    ])
                  ])
                ]),
                vue.createElementVNode("div", { class: "flex justify-end pb-8" }, [
                  vue.createElementVNode("button", {
                    onClick: saveSettings,
                    class: "px-8 py-2.5 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-medium transition-colors shadow-lg"
                  }, " 저장 ")
                ])
              ])
            ])
          ]),
          vue.createVNode(vue.Transition, {
            "enter-active-class": "transition-all duration-300",
            "leave-active-class": "transition-all duration-300",
            "enter-from-class": "opacity-0 translate-x-4",
            "leave-to-class": "opacity-0 translate-x-4"
          }, {
            default: vue.withCtx(() => [
              showSuccess.value ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_37, [..._cache[50] || (_cache[50] = [
                vue.createElementVNode("svg", {
                  class: "w-5 h-5",
                  fill: "none",
                  stroke: "currentColor",
                  viewBox: "0 0 24 24"
                }, [
                  vue.createElementVNode("path", {
                    "stroke-linecap": "round",
                    "stroke-linejoin": "round",
                    "stroke-width": "2",
                    d: "M5 13l4 4L19 7"
                  })
                ], -1),
                vue.createTextVNode(" 저장되었습니다 ", -1)
              ])])) : vue.createCommentVNode("", true)
            ]),
            _: 1
          }),
          vue.createVNode(vue.Transition, {
            "enter-active-class": "transition-opacity duration-200",
            "leave-active-class": "transition-opacity duration-200",
            "enter-from-class": "opacity-0",
            "leave-to-class": "opacity-0"
          }, {
            default: vue.withCtx(() => [
              showDebugModal.value ? (vue.openBlock(), vue.createElementBlock("div", {
                key: 0,
                class: "fixed inset-0 bg-black/70 flex items-center justify-center z-50 p-4",
                onClick: _cache[17] || (_cache[17] = vue.withModifiers(($event) => showDebugModal.value = false, ["self"]))
              }, [
                vue.createElementVNode("div", _hoisted_38, [
                  vue.createElementVNode("div", _hoisted_39, [
                    _cache[52] || (_cache[52] = vue.createElementVNode("div", null, [
                      vue.createElementVNode("h2", { class: "text-xl font-bold text-white" }, "디버그: 대용량 텍스트 렌더링 테스트"),
                      vue.createElementVNode("p", { class: "text-sm text-gray-400 mt-1" }, "450줄의 일본어 샘플 텍스트")
                    ], -1)),
                    vue.createElementVNode("button", {
                      onClick: _cache[15] || (_cache[15] = ($event) => showDebugModal.value = false),
                      class: "text-gray-400 hover:text-white transition-colors"
                    }, [..._cache[51] || (_cache[51] = [
                      vue.createElementVNode("svg", {
                        class: "w-6 h-6",
                        fill: "none",
                        stroke: "currentColor",
                        viewBox: "0 0 24 24"
                      }, [
                        vue.createElementVNode("path", {
                          "stroke-linecap": "round",
                          "stroke-linejoin": "round",
                          "stroke-width": "2",
                          d: "M6 18L18 6M6 6l12 12"
                        })
                      ], -1)
                    ])])
                  ]),
                  vue.createElementVNode("div", _hoisted_40, [
                    vue.createElementVNode("div", _hoisted_41, [
                      vue.createElementVNode("h3", _hoisted_42, "샘플 텍스트 (" + vue.toDisplayString(debugLineCount.value) + "줄)", 1),
                      vue.createElementVNode("button", {
                        onClick: copyDebugText,
                        class: "text-xs px-3 py-1 bg-orange-600 hover:bg-orange-700 text-white rounded transition-colors"
                      }, " 📋 복사 ")
                    ]),
                    vue.createElementVNode("div", _hoisted_43, [
                      vue.createElementVNode("textarea", {
                        value: debugSampleText.value,
                        readonly: "",
                        class: "w-full h-full bg-transparent text-sm text-orange-300 font-mono leading-relaxed p-4 resize-none focus:outline-none border-0"
                      }, null, 8, _hoisted_44)
                    ])
                  ]),
                  vue.createElementVNode("div", _hoisted_45, [
                    _cache[53] || (_cache[53] = vue.createElementVNode("div", { class: "text-sm text-gray-400" }, " ✅ 모달이 즉시 열렸다면 렌더링 최적화 성공! ", -1)),
                    vue.createElementVNode("button", {
                      onClick: _cache[16] || (_cache[16] = ($event) => showDebugModal.value = false),
                      class: "px-6 py-2 bg-gray-800 hover:bg-gray-700 text-white rounded-lg font-medium transition-colors"
                    }, " 닫기 ")
                  ])
                ])
              ])) : vue.createCommentVNode("", true)
            ]),
            _: 1
          })
        ]);
      };
    }
  });
  const router = createRouter({
    history: createWebHashHistory(),
    routes: [
      {
        path: "/",
        redirect: "/tts"
      },
      {
        path: "/tts",
        name: "TtsSubtitle",
        component: _sfc_main$1
      },
      {
        path: "/settings",
        name: "Settings",
        component: _sfc_main
      }
    ]
  });
  window.parentGM_xmlhttpRequest = _GM_xmlhttpRequest;
  window.parentGM_setValue = _GM_setValue;
  window.parentGM_getValue = _GM_getValue;
  function openVideoEditor() {
    const popup = window.open("", "TemperVV_VideoEditor", "width=1280,height=800,resizable=yes");
    if (!popup) {
      alert("팝업이 차단되었습니다. 브라우저 설정에서 팝업을 허용해주세요.");
      return;
    }
    popup.document.write(`
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🎬 Temper-VV Video Editor</title>
    <script src="https://cdn.tailwindcss.com"><\/script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }
        #app {
            width: 100%;
            height: 100vh;
        }
    </style>
</head>
<body>
    <div id="app"></div>
</body>
</html>
    `);
    popup.document.close();
    popup.opener = window;
    popup.parentGM_xmlhttpRequest = _GM_xmlhttpRequest;
    popup.parentGM_setValue = _GM_setValue;
    popup.parentGM_getValue = _GM_getValue;
    const mountVueApp = async () => {
      const appElement = popup.document.getElementById("app");
      if (appElement) {
        const pinia = createPinia();
        const app = vue.createApp(App);
        app.use(pinia);
        app.use(router);
        app.mount(appElement);
        await router.push("/tts");
        console.log("✅ Vue 앱이 새 창에 마운트되었습니다!");
      } else {
        console.error("❌ #app 요소를 찾을 수 없습니다!");
      }
    };
    const waitForReady = () => {
      const checkReady = () => {
        const hasAppElement = !!popup.document.getElementById("app");
        const hasTailwind = !!popup.document.querySelector('script[src*="tailwindcss"]');
        return hasAppElement && hasTailwind;
      };
      if (checkReady()) {
        setTimeout(mountVueApp, 100);
      } else {
        const observer = new MutationObserver(() => {
          if (checkReady()) {
            observer.disconnect();
            setTimeout(mountVueApp, 100);
          }
        });
        observer.observe(popup.document.documentElement, {
          childList: true,
          subtree: true
        });
        setTimeout(() => {
          observer.disconnect();
          console.warn("⚠️ 타임아웃: 강제로 Vue 앱 마운트 시도");
          mountVueApp();
        }, 3e3);
      }
    };
    waitForReady();
  }
  _GM_registerMenuCommand("🎬 보이스복스 딸깍툴열기", openVideoEditor);
  document.addEventListener("keydown", (e) => {
    if (e.ctrlKey && e.shiftKey && e.key === "E") {
      e.preventDefault();
      openVideoEditor();
    }
  });
  console.log("✅ Temper-VV 로드 완료! (Ctrl+Shift+E 또는 TM 메뉴에서 실행)");

})(Vue);